/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.toutiao.sdk.service;

import cn.insmart.mp.toutiao.common.expander.JsonExpander;
import cn.insmart.mp.toutiao.sdk.annotation.AdvertiserId;
import cn.insmart.mp.toutiao.sdk.filter.CreativeGetFilter;
import cn.insmart.mp.toutiao.sdk.request.bo.CreativeCustomSave;
import cn.insmart.mp.toutiao.sdk.request.bo.CreativeProceduralSave;
import cn.insmart.mp.toutiao.sdk.response.bo.CreativeCustomSaveData;
import cn.insmart.mp.toutiao.sdk.response.bo.CreativeGetData;
import cn.insmart.mp.toutiao.sdk.response.bo.CreativeReadData;
import cn.insmart.mp.toutiao.sdk.response.bo.EmptyData;
import cn.insmart.mp.toutiao.sdk.response.bo.ResponseBO;
import cn.insmart.mp.toutiao.sdk.service.ApiService;
import feign.Param;
import feign.RequestLine;
import javax.validation.constraints.NotNull;

public interface CreativeService
extends ApiService {
    public static final String READ_CREATIVE = "/creative/read_v2/";
    public static final String GET_CREATIVE = "/creative/get/";
    public static final String CREATE_CUSTOM_CREATIVE = "/creative/custom_creative/create/";
    public static final String UPDATE_CUSTOM_CREATIVE = "/creative/custom_creative/update/";
    public static final String CREATE_PROCEDURAL_CREATIVE = "/creative/procedural_creative/create/";
    public static final String UPDATE_PROCEDURAL_CREATIVE = "/creative/procedural_creative/update/";
    public static final String[] DEFAULT_CREATIVE_GET_FIELDS = new String[]{"creative_id", "ad_id", "advertiser_id", "status", "opt_status", "image_mode", "title", "creative_word_ids", "third_party_id", "image_ids", "image_id", "video_id", "materials"};
    public static final String[] TEST_CREATIVE_GET_FIELDS = new String[]{"creative_id", "ad_id", "status", "opt_status"};

    @RequestLine(value="POST /creative/custom_creative/create/")
    public ResponseBO<CreativeCustomSaveData> createCustom(@AdvertiserId @NotNull CreativeCustomSave var1);

    @RequestLine(value="POST /creative/custom_creative/update/")
    public ResponseBO<CreativeCustomSaveData> updateCustom(@AdvertiserId @NotNull CreativeCustomSave var1);

    @RequestLine(value="POST /creative/procedural_creative/create/")
    public ResponseBO<EmptyData> createProcedural(@AdvertiserId @NotNull CreativeProceduralSave var1);

    @RequestLine(value="POST /creative/procedural_creative/update/")
    public ResponseBO<EmptyData> updateProcedural(@AdvertiserId @NotNull CreativeProceduralSave var1);

    @RequestLine(value="GET /creative/read_v2/?advertiser_id={advertiserId}&ad_id={adId}")
    public ResponseBO<CreativeReadData> read(@NotNull @AdvertiserId @Param(value="advertiserId") Long var1, @NotNull @Param(value="adId") Long var2);

    @RequestLine(value="GET /creative/get/?advertiser_id={advertiserId}&page={page}&page_size={pageSize}&fields={fields}&filtering={filtering}")
    public ResponseBO<CreativeGetData> get(@AdvertiserId @NotNull @Param(value="advertiserId") Long var1, @Param(value="filtering", expander=JsonExpander.class) CreativeGetFilter var2, @Param(value="fields", expander=JsonExpander.class) String[] var3, @Param(value="page") Integer var4, @Param(value="pageSize") Integer var5);

    @RequestLine(value="GET /creative/get/?advertiser_id={advertiserId}&cursor={cursor}&count={count}&fields={fields}&filtering={filtering}")
    public ResponseBO<CreativeGetData> getByCursor(@AdvertiserId @NotNull @Param(value="advertiserId") Long var1, @Param(value="filtering", expander=JsonExpander.class) CreativeGetFilter var2, @Param(value="fields", expander=JsonExpander.class) String[] var3, @Param(value="cursor") Long var4, @Param(value="count") Integer var5);
}

