/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.toutiao.sdk.support;

import cn.insmart.fx.common.exception.business.BusinessException;
import cn.insmart.fx.common.lang.util.Message;
import cn.insmart.fx.common.lang.util.NumberUtils;
import cn.insmart.fx.common.lang.util.ReflectionUtils;
import cn.insmart.fx.common.lang.util.StringUtils;
import cn.insmart.mp.toutiao.sdk.annotation.AdvertiserId;
import cn.insmart.mp.toutiao.sdk.annotation.V3Api;
import cn.insmart.mp.toutiao.sdk.codec.JacksonDecoder;
import cn.insmart.mp.toutiao.sdk.codec.JacksonEncoder;
import cn.insmart.mp.toutiao.sdk.configuration.SdkProperties;
import cn.insmart.mp.toutiao.sdk.exception.SdkInitException;
import cn.insmart.mp.toutiao.sdk.request.bo.RequestData;
import cn.insmart.mp.toutiao.sdk.service.ApiService;
import cn.insmart.mp.toutiao.sdk.support.ApiServiceFactory;
import cn.insmart.mp.toutiao.sdk.support.QpsLimiter;
import cn.insmart.mp.toutiao.sdk.support.TokenProvider;
import com.google.common.util.concurrent.RateLimiter;
import feign.Client;
import feign.Feign;
import feign.InvocationHandlerFactory;
import feign.Logger;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.FormEncoder;
import feign.httpclient.ApacheHttpClient;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class DefaultApiServiceFactory
implements ApiServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultApiServiceFactory.class);
    private static final ThreadLocal<Long> threadAdvertiserId = ThreadLocal.withInitial(() -> 0L);
    private final SdkProperties sdkProperties;
    private final TokenProvider tokenProvider;

    @Override
    public <T extends ApiService> T create(Class<T> service) {
        HttpClientBuilder builder = this.createDefaultHttpBuilder();
        Annotation[] annotations = service.getAnnotations();
        V3Api v3Annotation = null;
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof V3Api)) continue;
            v3Annotation = (V3Api)annotation;
            break;
        }
        String targetUrl = v3Annotation != null ? v3Annotation.targetUrl() : this.sdkProperties.getApi();
        return (T)((ApiService)Feign.builder().client((Client)new ApacheHttpClient((HttpClient)builder.build())).invocationHandlerFactory(this.invocationHandlerFactory(false)).requestInterceptor(template -> {
            try {
                Long advertiserId = threadAdvertiserId.get();
                if (advertiserId > 0L) {
                    String token = this.tokenProvider.getToken(advertiserId);
                    template.header("Access-Token", new String[]{Objects.requireNonNull(token, Message.of((String)"cant get token. advertiserId: {}, provider: {}", (Object[])new Object[]{advertiserId, this.tokenProvider.getClass().getSimpleName()}))});
                }
                Collection tokenHeader = (Collection)template.headers().get("Access-Token");
                Assert.notEmpty((Collection)tokenHeader, (String)Message.of((String)"token is null. advertiserIds: {}, provider: {}", (Object[])new Object[]{advertiserId, this.tokenProvider.getClass().getSimpleName()}));
            }
            finally {
                threadAdvertiserId.remove();
            }
            if (this.sdkProperties.isXDebugMode()) {
                template.header("X-Debug-Mode", new String[]{"1"});
            }
        }).logger(new feign.Logger(){

            protected void log(String configKey, String format, Object ... args) {
                log.info("feign: {}, {}", (Object)format, (Object)args);
            }
        }).logLevel(this.sdkProperties.isFeignDebug() ? Logger.Level.FULL : Logger.Level.BASIC).decoder((Decoder)new JacksonDecoder()).encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder())).target(service, targetUrl));
    }

    @Override
    public <T extends ApiService> T createWithoutId(Class<T> service) {
        HttpClientBuilder builder = this.createDefaultHttpBuilder();
        return (T)((ApiService)Feign.builder().client((Client)new ApacheHttpClient((HttpClient)builder.build())).invocationHandlerFactory(this.invocationHandlerFactory(true)).logger(new feign.Logger(){

            protected void log(String configKey, String format, Object ... args) {
                log.info("feign: {}, {}", (Object)format, (Object)args);
            }
        }).logLevel(this.sdkProperties.isFeignDebug() ? Logger.Level.FULL : Logger.Level.BASIC).decoder((Decoder)new JacksonDecoder()).encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder())).target(service, this.sdkProperties.getApi()));
    }

    @Override
    public <T extends ApiService> T createOauthService(Class<T> service) {
        HttpClientBuilder builder = this.createDefaultHttpBuilder();
        return (T)((ApiService)Feign.builder().client((Client)new ApacheHttpClient((HttpClient)builder.build())).invocationHandlerFactory(this.invocationHandlerFactory(true)).requestInterceptor(template -> {
            if (this.sdkProperties.isXDebugMode()) {
                template.header("X-Debug-Mode", new String[]{"1"});
            }
        }).logger(new feign.Logger(){

            protected void log(String configKey, String format, Object ... args) {
                log.info("feign: {}, {}", (Object)format, (Object)args);
            }
        }).logLevel(this.sdkProperties.isFeignDebug() ? Logger.Level.FULL : Logger.Level.BASIC).decoder((Decoder)new JacksonDecoder()).encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder())).target(service, this.sdkProperties.getOauthApi()));
    }

    @Override
    public <T extends ApiService> T createSpecialService(Class<T> service) {
        HttpClientBuilder builder = this.createDefaultHttpBuilder();
        return (T)((ApiService)Feign.builder().client((Client)new ApacheHttpClient((HttpClient)builder.build())).logger(new feign.Logger(){

            protected void log(String configKey, String format, Object ... args) {
                log.info("feign: {}, {}", (Object)format, (Object)args);
            }
        }).logLevel(this.sdkProperties.isFeignDebug() ? Logger.Level.FULL : Logger.Level.BASIC).decoder((Decoder)new JacksonDecoder()).encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder())).target(service, SdkProperties.SERVER_URI_MAP.get(service)));
    }

    private HttpClientBuilder createDefaultHttpBuilder() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (this.sdkProperties.getProxy() != null && StringUtils.isNotBlank((CharSequence)this.sdkProperties.getProxy().getHost())) {
            HttpHost httpHost = new HttpHost(this.sdkProperties.getProxy().getHost(), this.sdkProperties.getProxy().getPort());
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(httpHost);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.sdkProperties.getProxy().getUsername(), this.sdkProperties.getProxy().getPassword()})) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(httpHost), (Credentials)new UsernamePasswordCredentials(this.sdkProperties.getProxy().getUsername(), this.sdkProperties.getProxy().getPassword()));
                builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            builder.setRoutePlanner((HttpRoutePlanner)routePlanner);
        }
        builder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(this.getSSLContext(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE));
        return builder;
    }

    private InvocationHandlerFactory invocationHandlerFactory(boolean isAuthRequest) {
        return (target, dispatch) -> (proxy, method, args) -> {
            if (method.getDeclaringClass().equals(Object.class)) {
                return method.invoke((Object)this, args);
            }
            if (!isAuthRequest) {
                Long ttAdvertiserId = this.getAdvertiserId(method, args);
                log.debug("invocationHandlerFactory get ttAdvertiserId {}, method: {}, args: {}", new Object[]{ttAdvertiserId, method, args});
                if (this.sdkProperties.getBanTtAdvertiserIds().contains(ttAdvertiserId)) {
                    throw new BusinessException(Message.of((String)"{} \u8d26\u6237\u4e3a\u7981\u7528\u8d26\u6237.", (Object[])new Object[]{ttAdvertiserId}), new Object[0]);
                }
                threadAdvertiserId.set(ttAdvertiserId);
            }
            if (this.sdkProperties.isEnableQpsLimit()) {
                this.qpsLimit(method);
            }
            return ((InvocationHandlerFactory.MethodHandler)dispatch.get(method)).invoke(args);
        };
    }

    private void qpsLimit(Method method) {
        double acquire;
        RateLimiter limiter = QpsLimiter.get(method);
        if (Objects.nonNull(limiter) && (acquire = limiter.acquire()) > 0.0) {
            log.warn("\u63a5\u53e3\u9700\u8981\u8fdb\u884c\u9650\u6d41 {}, qps = {}", (Object)method, (Object)acquire);
        }
    }

    private Long getAdvertiserId(Method method, Object[] args) {
        Long returnId = 0L;
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        int i = 0;
        try {
            Annotation[][] annotationArray = parameterAnnotations;
            int n = annotationArray.length;
            for (int j = 0; j < n; ++j) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = annotationArray[j]) {
                    log.debug("i: {} an: {}", (Object)i, (Object)annotation);
                    if (!(annotation instanceof AdvertiserId)) continue;
                    AdvertiserId advIdAnnotation = (AdvertiserId)annotation;
                    if (args.length < i) {
                        throw new SdkInitException(Message.of((String)"api \u65b9\u6cd5\u9519\u8bef: {}, {}", (Object[])new Object[]{method, args}), new Object[0]);
                    }
                    returnId = this.getObjectAdvertiserId(method, i, args[i], advIdAnnotation.value());
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Assert.isTrue((returnId != null && returnId > 0L ? 1 : 0) != 0, (String)Message.of((String)"cant get AdvertiserId from {}, {}", (Object[])new Object[]{method, args}));
        return returnId;
    }

    private Long getObjectAdvertiserId(Method method, int parameterIndex, Object obj, String fieldName) {
        Assert.notNull((Object)obj, (String)Message.of((String)"get AdvertiserId error! obj is null. method: {}, field: {}", (Object[])new Object[]{method, fieldName}));
        if (obj instanceof Long) {
            return NumberUtils.toLong((String)obj.toString(), (long)0L);
        }
        if (obj instanceof Long[]) {
            Long[] advertiserIds = (Long[])obj;
            if (advertiserIds.length == 0) {
                throw new NullPointerException("\u53c2\u6570advertiserIds\u4e0d\u80fd\u4e3a\u7a7a");
            }
            return advertiserIds[0];
        }
        if (obj instanceof RequestData) {
            return ((RequestData)obj).getTtAdvertiserId();
        }
        if (StringUtils.isNotBlank((CharSequence)fieldName)) {
            Class<?> clz = method.getParameterTypes()[parameterIndex];
            Field field = ReflectionUtils.findField(clz, (String)fieldName);
            ReflectionUtils.makeAccessible((Field)Objects.requireNonNull(field));
            return NumberUtils.toLong((String)Optional.ofNullable(ReflectionUtils.getField((Field)field, (Object)obj)).orElse("0").toString(), (long)0L);
        }
        return 0L;
    }

    private SSLContext getSSLContext() {
        try {
            return SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustAllStrategy()).build();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected SdkProperties getSdkProperties() {
        return this.sdkProperties;
    }

    protected TokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    public DefaultApiServiceFactory(SdkProperties sdkProperties, TokenProvider tokenProvider) {
        this.sdkProperties = sdkProperties;
        this.tokenProvider = tokenProvider;
    }
}

