/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.toutiao.sdk.service;

import cn.insmart.mp.toutiao.common.enums.GroupBy;
import cn.insmart.mp.toutiao.common.enums.StatTimeGranularity;
import cn.insmart.mp.toutiao.common.expander.JsonExpander;
import cn.insmart.mp.toutiao.sdk.annotation.AdvertiserId;
import cn.insmart.mp.toutiao.sdk.filter.AdReportFilter;
import cn.insmart.mp.toutiao.sdk.filter.CampaignReportFilter;
import cn.insmart.mp.toutiao.sdk.filter.CreativeReportFilter;
import cn.insmart.mp.toutiao.sdk.response.bo.AdReportData;
import cn.insmart.mp.toutiao.sdk.response.bo.AdvertiserReportData;
import cn.insmart.mp.toutiao.sdk.response.bo.CampaignReportData;
import cn.insmart.mp.toutiao.sdk.response.bo.CreativeReportData;
import cn.insmart.mp.toutiao.sdk.response.bo.ResponseBO;
import cn.insmart.mp.toutiao.sdk.service.ApiService;
import feign.Param;
import feign.RequestLine;
import java.time.LocalDate;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public interface ReportService
extends ApiService {
    public static final String GET_ADVERTISER_REPORT = "/report/advertiser/get/";
    public static final String GET_CAMPAIGN_REPORT = "/report/campaign/get/";
    public static final String GET_AD_REPORT = "/report/ad/get/";
    public static final String GET_CREATIVE_REPORT = "/report/creative/get/";
    public static final String[] DEFAULT_REPORT_FIELDS = new String[]{"cost", "show", "avg_show_cost", "click", "avg_click_cost", "ctr", "convert", "convert_cost", "convert_rate"};
    public static final GroupBy[] DEFAULT_REPORT_GROUP_BY = new GroupBy[]{GroupBy.STAT_GROUP_BY_FIELD_ID, GroupBy.STAT_GROUP_BY_FIELD_STAT_TIME};
    public static final int DEFAULT_ADVERTISER_REPORT_PAGE_SIZE = 1000;
    public static final int DEFAULT_CAMPAIGN_REPORT_PAGE_SIZE = 1000;
    public static final int DEFAULT_AD_REPORT_PAGE_SIZE = 1000;
    public static final int DEFAULT_CREATIVE_REPORT_PAGE_SIZE = 1000;
    public static final int DEFAULT_PAGE_ID_SIZE = 100;

    @RequestLine(value="GET /report/advertiser/get/?advertiser_id={advertiserId}&page={page}&page_size={pageSize}&fields={fields}&start_date={startDate}&end_date={endDate}&group_by={groupBy}&time_granularity={timeGranularity}")
    public ResponseBO<AdvertiserReportData> getAdvertiserReport(@NotNull @Param(value="advertiserId") @AdvertiserId Long var1, @Param(value="startDate", expander=JsonExpander.class) LocalDate var2, @Param(value="endDate", expander=JsonExpander.class) LocalDate var3, @Param(value="groupBy", expander=JsonExpander.class) GroupBy[] var4, @Param(value="timeGranularity") StatTimeGranularity var5, @Param(value="fields", expander=JsonExpander.class) String[] var6, @Param(value="page") Integer var7, @Param(value="pageSize") @Min(value=1L) @Max(value=1000L) @Min(value=1L) @Max(value=1000L) Integer var8);

    @Deprecated
    @RequestLine(value="GET /report/campaign/get/?advertiser_id={advertiserId}&page={page}&page_size={pageSize}&fields={fields}&start_date={startDate}&end_date={endDate}&group_by={groupBy}&time_granularity={timeGranularity}&filtering={filtering}")
    public ResponseBO<CampaignReportData> getCampaignReport(@NotNull @Param(value="advertiserId") @AdvertiserId Long var1, @Param(value="startDate", expander=JsonExpander.class) LocalDate var2, @Param(value="endDate", expander=JsonExpander.class) LocalDate var3, @Param(value="groupBy", expander=JsonExpander.class) GroupBy[] var4, @Param(value="timeGranularity") StatTimeGranularity var5, @Param(value="fields", expander=JsonExpander.class) String[] var6, @Param(value="filtering", expander=JsonExpander.class) CampaignReportFilter var7, @Param(value="page") Integer var8, @Param(value="pageSize") @Min(value=1L) @Max(value=1000L) @Min(value=1L) @Max(value=1000L) Integer var9);

    @Deprecated
    @RequestLine(value="GET /report/ad/get/?advertiser_id={advertiserId}&page={page}&page_size={pageSize}&fields={fields}&start_date={startDate}&end_date={endDate}&group_by={groupBy}&time_granularity={timeGranularity}&filtering={filtering}")
    public ResponseBO<AdReportData> getAdReport(@NotNull @Param(value="advertiserId") @AdvertiserId Long var1, @Param(value="startDate", expander=JsonExpander.class) LocalDate var2, @Param(value="endDate", expander=JsonExpander.class) LocalDate var3, @Param(value="groupBy", expander=JsonExpander.class) GroupBy[] var4, @Param(value="timeGranularity") StatTimeGranularity var5, @Param(value="fields", expander=JsonExpander.class) String[] var6, @Param(value="filtering", expander=JsonExpander.class) AdReportFilter var7, @Param(value="page") Integer var8, @Param(value="pageSize") @Min(value=1L) @Max(value=1000L) @Min(value=1L) @Max(value=1000L) Integer var9);

    @RequestLine(value="GET /report/creative/get/?advertiser_id={advertiserId}&page={page}&page_size={pageSize}&fields={fields}&start_date={startDate}&end_date={endDate}&group_by={groupBy}&time_granularity={timeGranularity}&filtering={filtering}")
    public ResponseBO<CreativeReportData> getCreativeReport(@NotNull @Param(value="advertiserId") @AdvertiserId Long var1, @Param(value="startDate", expander=JsonExpander.class) LocalDate var2, @Param(value="endDate", expander=JsonExpander.class) LocalDate var3, @Param(value="groupBy", expander=JsonExpander.class) GroupBy[] var4, @Param(value="timeGranularity") StatTimeGranularity var5, @Param(value="fields", expander=JsonExpander.class) String[] var6, @Param(value="filtering", expander=JsonExpander.class) CreativeReportFilter var7, @Param(value="page") Integer var8, @Param(value="pageSize") @Min(value=1L) @Max(value=1000L) @Min(value=1L) @Max(value=1000L) Integer var9);
}

