/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.toutiao.sdk.configuration;

import cn.insmart.mp.toutiao.common.constants.AccountConstants;
import cn.insmart.mp.toutiao.sdk.service.ApiService;
import cn.insmart.mp.toutiao.sdk.service.EventConvertService;
import cn.insmart.mp.toutiao.sdk.support.properties.AdvertiserProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

@ConfigurationProperties(value="mp.toutiao.sdk.config")
public class SdkProperties {
    private static final Logger log = LoggerFactory.getLogger(SdkProperties.class);
    private String api = "https://api.oceanengine.com/open_api/2/";
    private String v3Api = "https://api.oceanengine.com/open_api/v3.0/";
    private String oauthApi = "https://ad.oceanengine.com/open_api/";
    public static final Map<Class<? extends ApiService>, String> SERVER_URI_MAP = Map.ofEntries(Map.entry(EventConvertService.class, "https://analytics.oceanengine.com/api/v2/"));
    private boolean cacheApiService = true;
    private boolean xDebugMode = false;
    private boolean enableQpsLimit = false;
    private Set<Long> banTtAdvertiserIds = AccountConstants.DEFAULT_BAN_TT_ADVERTISER_IDS;
    private DefaultAdvertiserProperties defaultAdvertiser;
    private Map<Long, DefaultAdvertiserProperties> advertisers;
    private DataSourceProperties dataSource;
    private ProxyProperties proxy;
    private Boolean debug;

    public Map<Long, DefaultAdvertiserProperties> getAdvertiserMap() {
        if (Objects.nonNull(this.defaultAdvertiser)) {
            HashMap<Long, DefaultAdvertiserProperties> map = new HashMap<Long, DefaultAdvertiserProperties>();
            map.put(null, this.defaultAdvertiser);
            return map;
        }
        return this.advertisers;
    }

    public boolean isFeignDebug() {
        return Boolean.TRUE.equals(this.debug);
    }

    public String getApi() {
        return this.api;
    }

    public String getV3Api() {
        return this.v3Api;
    }

    public String getOauthApi() {
        return this.oauthApi;
    }

    public boolean isCacheApiService() {
        return this.cacheApiService;
    }

    public boolean isXDebugMode() {
        return this.xDebugMode;
    }

    public boolean isEnableQpsLimit() {
        return this.enableQpsLimit;
    }

    public Set<Long> getBanTtAdvertiserIds() {
        return this.banTtAdvertiserIds;
    }

    public DefaultAdvertiserProperties getDefaultAdvertiser() {
        return this.defaultAdvertiser;
    }

    public Map<Long, DefaultAdvertiserProperties> getAdvertisers() {
        return this.advertisers;
    }

    public DataSourceProperties getDataSource() {
        return this.dataSource;
    }

    public ProxyProperties getProxy() {
        return this.proxy;
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public void setV3Api(String v3Api) {
        this.v3Api = v3Api;
    }

    public void setOauthApi(String oauthApi) {
        this.oauthApi = oauthApi;
    }

    public void setCacheApiService(boolean cacheApiService) {
        this.cacheApiService = cacheApiService;
    }

    public void setXDebugMode(boolean xDebugMode) {
        this.xDebugMode = xDebugMode;
    }

    public void setEnableQpsLimit(boolean enableQpsLimit) {
        this.enableQpsLimit = enableQpsLimit;
    }

    public void setBanTtAdvertiserIds(Set<Long> banTtAdvertiserIds) {
        this.banTtAdvertiserIds = banTtAdvertiserIds;
    }

    public void setDefaultAdvertiser(DefaultAdvertiserProperties defaultAdvertiser) {
        this.defaultAdvertiser = defaultAdvertiser;
    }

    public void setAdvertisers(Map<Long, DefaultAdvertiserProperties> advertisers) {
        this.advertisers = advertisers;
    }

    public void setDataSource(DataSourceProperties dataSource) {
        this.dataSource = dataSource;
    }

    public void setProxy(ProxyProperties proxy) {
        this.proxy = proxy;
    }

    public void setDebug(Boolean debug) {
        this.debug = debug;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SdkProperties)) {
            return false;
        }
        SdkProperties other = (SdkProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCacheApiService() != other.isCacheApiService()) {
            return false;
        }
        if (this.isXDebugMode() != other.isXDebugMode()) {
            return false;
        }
        if (this.isEnableQpsLimit() != other.isEnableQpsLimit()) {
            return false;
        }
        Boolean this$debug = this.getDebug();
        Boolean other$debug = other.getDebug();
        if (this$debug == null ? other$debug != null : !((Object)this$debug).equals(other$debug)) {
            return false;
        }
        String this$api = this.getApi();
        String other$api = other.getApi();
        if (this$api == null ? other$api != null : !this$api.equals(other$api)) {
            return false;
        }
        String this$v3Api = this.getV3Api();
        String other$v3Api = other.getV3Api();
        if (this$v3Api == null ? other$v3Api != null : !this$v3Api.equals(other$v3Api)) {
            return false;
        }
        String this$oauthApi = this.getOauthApi();
        String other$oauthApi = other.getOauthApi();
        if (this$oauthApi == null ? other$oauthApi != null : !this$oauthApi.equals(other$oauthApi)) {
            return false;
        }
        Set<Long> this$banTtAdvertiserIds = this.getBanTtAdvertiserIds();
        Set<Long> other$banTtAdvertiserIds = other.getBanTtAdvertiserIds();
        if (this$banTtAdvertiserIds == null ? other$banTtAdvertiserIds != null : !((Object)this$banTtAdvertiserIds).equals(other$banTtAdvertiserIds)) {
            return false;
        }
        DefaultAdvertiserProperties this$defaultAdvertiser = this.getDefaultAdvertiser();
        DefaultAdvertiserProperties other$defaultAdvertiser = other.getDefaultAdvertiser();
        if (this$defaultAdvertiser == null ? other$defaultAdvertiser != null : !((Object)this$defaultAdvertiser).equals(other$defaultAdvertiser)) {
            return false;
        }
        Map<Long, DefaultAdvertiserProperties> this$advertisers = this.getAdvertisers();
        Map<Long, DefaultAdvertiserProperties> other$advertisers = other.getAdvertisers();
        if (this$advertisers == null ? other$advertisers != null : !((Object)this$advertisers).equals(other$advertisers)) {
            return false;
        }
        DataSourceProperties this$dataSource = this.getDataSource();
        DataSourceProperties other$dataSource = other.getDataSource();
        if (this$dataSource == null ? other$dataSource != null : !((Object)this$dataSource).equals(other$dataSource)) {
            return false;
        }
        ProxyProperties this$proxy = this.getProxy();
        ProxyProperties other$proxy = other.getProxy();
        return !(this$proxy == null ? other$proxy != null : !((Object)this$proxy).equals(other$proxy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SdkProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCacheApiService() ? 79 : 97);
        result = result * 59 + (this.isXDebugMode() ? 79 : 97);
        result = result * 59 + (this.isEnableQpsLimit() ? 79 : 97);
        Boolean $debug = this.getDebug();
        result = result * 59 + ($debug == null ? 43 : ((Object)$debug).hashCode());
        String $api = this.getApi();
        result = result * 59 + ($api == null ? 43 : $api.hashCode());
        String $v3Api = this.getV3Api();
        result = result * 59 + ($v3Api == null ? 43 : $v3Api.hashCode());
        String $oauthApi = this.getOauthApi();
        result = result * 59 + ($oauthApi == null ? 43 : $oauthApi.hashCode());
        Set<Long> $banTtAdvertiserIds = this.getBanTtAdvertiserIds();
        result = result * 59 + ($banTtAdvertiserIds == null ? 43 : ((Object)$banTtAdvertiserIds).hashCode());
        DefaultAdvertiserProperties $defaultAdvertiser = this.getDefaultAdvertiser();
        result = result * 59 + ($defaultAdvertiser == null ? 43 : ((Object)$defaultAdvertiser).hashCode());
        Map<Long, DefaultAdvertiserProperties> $advertisers = this.getAdvertisers();
        result = result * 59 + ($advertisers == null ? 43 : ((Object)$advertisers).hashCode());
        DataSourceProperties $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : ((Object)$dataSource).hashCode());
        ProxyProperties $proxy = this.getProxy();
        result = result * 59 + ($proxy == null ? 43 : ((Object)$proxy).hashCode());
        return result;
    }

    public String toString() {
        return "SdkProperties(api=" + this.getApi() + ", v3Api=" + this.getV3Api() + ", oauthApi=" + this.getOauthApi() + ", cacheApiService=" + this.isCacheApiService() + ", xDebugMode=" + this.isXDebugMode() + ", enableQpsLimit=" + this.isEnableQpsLimit() + ", banTtAdvertiserIds=" + this.getBanTtAdvertiserIds() + ", defaultAdvertiser=" + this.getDefaultAdvertiser() + ", advertisers=" + this.getAdvertisers() + ", dataSource=" + this.getDataSource() + ", proxy=" + this.getProxy() + ", debug=" + this.getDebug() + ")";
    }

    public static class DataSourceProperties {
        private Class<? extends DataSource> type = DriverManagerDataSource.class;
        private String driverClassName = "com.mysql.cj.jdbc.Driver";
        private String username;
        private String password;
        private String url = "jdbc:mysql://127.0.0.1:3306/token";
        private String sql = "select accessToken as token from genactivity_toutiao_token where ttAdvertiserId=?";

        public Class<? extends DataSource> getType() {
            return this.type;
        }

        public String getDriverClassName() {
            return this.driverClassName;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getUrl() {
            return this.url;
        }

        public String getSql() {
            return this.sql;
        }

        public void setType(Class<? extends DataSource> type) {
            this.type = type;
        }

        public void setDriverClassName(String driverClassName) {
            this.driverClassName = driverClassName;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataSourceProperties)) {
                return false;
            }
            DataSourceProperties other = (DataSourceProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<? extends DataSource> this$type = this.getType();
            Class<? extends DataSource> other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$driverClassName = this.getDriverClassName();
            String other$driverClassName = other.getDriverClassName();
            if (this$driverClassName == null ? other$driverClassName != null : !this$driverClassName.equals(other$driverClassName)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$sql = this.getSql();
            String other$sql = other.getSql();
            return !(this$sql == null ? other$sql != null : !this$sql.equals(other$sql));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DataSourceProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<? extends DataSource> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $driverClassName = this.getDriverClassName();
            result = result * 59 + ($driverClassName == null ? 43 : $driverClassName.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $sql = this.getSql();
            result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
            return result;
        }

        public String toString() {
            return "SdkProperties.DataSourceProperties(type=" + this.getType() + ", driverClassName=" + this.getDriverClassName() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", url=" + this.getUrl() + ", sql=" + this.getSql() + ")";
        }
    }

    public static class ProxyProperties {
        private int port;
        private String host;
        private String username;
        private String password;

        public int getPort() {
            return this.port;
        }

        public String getHost() {
            return this.host;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProxyProperties)) {
                return false;
            }
            ProxyProperties other = (ProxyProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProxyProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPort();
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }

        public String toString() {
            return "SdkProperties.ProxyProperties(port=" + this.getPort() + ", host=" + this.getHost() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
        }
    }

    public static class DefaultAdvertiserProperties
    implements AdvertiserProperties {
        private Long advertiserId;
        private Long managerId;
        private String accessToken;
        private String name;

        @Override
        public Long getAdvertiserId() {
            return this.advertiserId;
        }

        @Override
        public Long getManagerId() {
            return this.managerId;
        }

        @Override
        public String getAccessToken() {
            return this.accessToken;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setAdvertiserId(Long advertiserId) {
            this.advertiserId = advertiserId;
        }

        public void setManagerId(Long managerId) {
            this.managerId = managerId;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DefaultAdvertiserProperties)) {
                return false;
            }
            DefaultAdvertiserProperties other = (DefaultAdvertiserProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$advertiserId = this.getAdvertiserId();
            Long other$advertiserId = other.getAdvertiserId();
            if (this$advertiserId == null ? other$advertiserId != null : !((Object)this$advertiserId).equals(other$advertiserId)) {
                return false;
            }
            Long this$managerId = this.getManagerId();
            Long other$managerId = other.getManagerId();
            if (this$managerId == null ? other$managerId != null : !((Object)this$managerId).equals(other$managerId)) {
                return false;
            }
            String this$accessToken = this.getAccessToken();
            String other$accessToken = other.getAccessToken();
            if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DefaultAdvertiserProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $advertiserId = this.getAdvertiserId();
            result = result * 59 + ($advertiserId == null ? 43 : ((Object)$advertiserId).hashCode());
            Long $managerId = this.getManagerId();
            result = result * 59 + ($managerId == null ? 43 : ((Object)$managerId).hashCode());
            String $accessToken = this.getAccessToken();
            result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "SdkProperties.DefaultAdvertiserProperties(advertiserId=" + this.getAdvertiserId() + ", managerId=" + this.getManagerId() + ", accessToken=" + this.getAccessToken() + ", name=" + this.getName() + ")";
        }
    }
}

