/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.toutiao.sdk.support;

import cn.insmart.mp.toutiao.sdk.configuration.SdkProperties;
import cn.insmart.mp.toutiao.sdk.service.ApiService;
import cn.insmart.mp.toutiao.sdk.support.ApiServiceFactory;
import cn.insmart.mp.toutiao.sdk.support.DefaultApiServiceFactory;
import cn.insmart.mp.toutiao.sdk.support.TokenProvider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheApiServiceFactory
extends DefaultApiServiceFactory
implements ApiServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(CacheApiServiceFactory.class);
    private final Map<Class<? extends ApiService>, ApiService> cache = new ConcurrentHashMap<Class<? extends ApiService>, ApiService>();
    private final Map<Class<? extends ApiService>, ApiService> oauthCache = new ConcurrentHashMap<Class<? extends ApiService>, ApiService>();

    public CacheApiServiceFactory(SdkProperties sdkProperties, TokenProvider tokenProvider) {
        super(sdkProperties, tokenProvider);
    }

    @Override
    public <T extends ApiService> T create(Class<T> service) {
        return (T)((ApiService)service.cast(this.cache.computeIfAbsent(service, x$0 -> super.create(x$0))));
    }

    @Override
    public <T extends ApiService> T createWithoutId(Class<T> service) {
        return (T)((ApiService)service.cast(this.cache.computeIfAbsent(service, x$0 -> super.createWithoutId(x$0))));
    }

    @Override
    public <T extends ApiService> T createOauthService(Class<T> service) {
        return (T)((ApiService)service.cast(this.oauthCache.computeIfAbsent(service, x$0 -> super.createOauthService(x$0))));
    }

    @Override
    public <T extends ApiService> T createSpecialService(Class<T> service) {
        return (T)((ApiService)service.cast(this.oauthCache.computeIfAbsent(service, x$0 -> super.createSpecialService(x$0))));
    }
}

