/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.uc.sdk.support;

import cn.insmart.fx.common.lang.util.StringUtils;
import cn.insmart.mp.uc.sdk.Api;
import cn.insmart.mp.uc.sdk.ApiFactory;
import cn.insmart.mp.uc.sdk.ApiV2;
import cn.insmart.mp.uc.sdk.coder.JacksonDecoder;
import cn.insmart.mp.uc.sdk.coder.JacksonEncoder;
import cn.insmart.mp.uc.sdk.config.SdkProperties;
import cn.insmart.mp.uc.sdk.dto.Header;
import cn.insmart.mp.uc.sdk.dto.Request;
import cn.insmart.mp.uc.sdk.exception.RetryAgainException;
import cn.insmart.mp.uc.sdk.support.MccProperties;
import cn.insmart.mp.uc.sdk.support.ObjectMappers;
import cn.insmart.mp.uc.sdk.support.QpsLimiter;
import cn.insmart.mp.uc.sdk.support.SdkChecker;
import feign.Client;
import feign.Feign;
import feign.FeignException;
import feign.InvocationHandlerFactory;
import feign.Logger;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.FormEncoder;
import feign.httpclient.ApacheHttpClient;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApiFactory
implements ApiFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultApiFactory.class);
    private final SdkProperties sdkProperties;
    private final MccProperties mccProperties;

    public DefaultApiFactory(SdkProperties sdkProperties, MccProperties mccProperties) {
        this.sdkProperties = sdkProperties;
        this.mccProperties = mccProperties;
    }

    @Override
    public <T extends Api> T create(Class<T> service, String targetAccount) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (this.sdkProperties.getProxy() != null && StringUtils.isNotBlank((CharSequence)this.sdkProperties.getProxy().getHost())) {
            HttpHost httpHost = new HttpHost(this.sdkProperties.getProxy().getHost(), this.sdkProperties.getProxy().getPort());
            builder.setProxy(httpHost);
        }
        builder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(this.getSSLContext(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE));
        return (T)((Api)Feign.builder().invocationHandlerFactory(this.invocationHandlerFactory(targetAccount)).encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder(ObjectMappers.getMapper()))).decoder((Decoder)new JacksonDecoder()).client((Client)new ApacheHttpClient((HttpClient)builder.build())).target(service, this.sdkProperties.getApi()));
    }

    @Override
    public <T extends Api> T createWithoutId(Class<T> service) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (this.sdkProperties.getProxy() != null && StringUtils.isNotBlank((CharSequence)this.sdkProperties.getProxy().getHost())) {
            HttpHost httpHost = new HttpHost(this.sdkProperties.getProxy().getHost(), this.sdkProperties.getProxy().getPort());
            builder.setProxy(httpHost);
        }
        builder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(this.getSSLContext(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE));
        return (T)((Api)Feign.builder().invocationHandlerFactory(this.invocationHandlerFactory(null)).encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder(ObjectMappers.getMapper()))).decoder((Decoder)new JacksonDecoder()).client((Client)new ApacheHttpClient((HttpClient)builder.build())).target(service, this.sdkProperties.getApi()));
    }

    @Override
    public <T extends ApiV2> T createV2(Class<T> service, String targetAccount) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (this.sdkProperties.getProxy() != null && StringUtils.isNotBlank((CharSequence)this.sdkProperties.getProxy().getHost())) {
            HttpHost httpHost = new HttpHost(this.sdkProperties.getProxy().getHost(), this.sdkProperties.getProxy().getPort());
            builder.setProxy(httpHost);
        }
        builder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(this.getSSLContext(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE));
        return (T)((ApiV2)Feign.builder().invocationHandlerFactory(this.invocationHandlerFactory(targetAccount)).encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder(ObjectMappers.getMapper()))).decoder((Decoder)new JacksonDecoder()).client((Client)new ApacheHttpClient((HttpClient)builder.build())).logger(new feign.Logger(){

            protected void log(String configKey, String format, Object ... args) {
                log.info("feign: {}, {}", (Object)format, (Object)args);
            }
        }).logLevel(Logger.Level.FULL).target(service, this.sdkProperties.getApiV2()));
    }

    private InvocationHandlerFactory invocationHandlerFactory(String targetAccount) {
        return (target, dispatch) -> (proxy, method, args) -> {
            if (method.isDefault()) {
                Class<?> declaringClass = method.getDeclaringClass();
                MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(declaringClass, MethodHandles.lookup());
                MethodHandle special = lookup.findSpecial(declaringClass, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), declaringClass);
                return special.bindTo(proxy).invokeWithArguments(args);
            }
            if (method.getDeclaringClass().equals(Object.class)) {
                return method.invoke((Object)this, args);
            }
            Objects.requireNonNull(args, "\u63a5\u53e3\u65b9\u6cd5\u5fc5\u987b\u6709\u53c2\u6570\u5b9a\u4e49");
            Header header = new Header();
            header.setUsername(this.mccProperties.getUsername());
            header.setPassword(this.mccProperties.getPassword());
            header.setToken(this.mccProperties.getToken());
            if (StringUtils.isNotBlank((CharSequence)targetAccount)) {
                header.setTarget(targetAccount);
            }
            Request<Object[]> request = new Request<Object[]>(header, (Object[])(args.length == 1 ? args[0] : args));
            int i = 1;
            while (true) {
                try {
                    QpsLimiter.limit(method);
                    Object returnValue = ((InvocationHandlerFactory.MethodHandler)dispatch.get(method)).invoke(new Object[]{request});
                    SdkChecker.check(method, returnValue, request);
                    return returnValue;
                }
                catch (RetryAgainException | FeignException.GatewayTimeout | FeignException.InternalServerError e) {
                    log.warn("SDK \u91cd\u8bd5 {}({}): {}", new Object[]{i, this.sdkProperties.getTimeoutRetry(), e.getMessage()});
                    if (i > this.sdkProperties.getTimeoutRetry()) {
                        throw e;
                    }
                    TimeUnit.SECONDS.sleep(Math.min(i, 10));
                    ++i;
                    continue;
                }
                break;
            }
        };
    }

    private SSLContext getSSLContext() {
        try {
            return SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustAllStrategy()).build();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected SdkProperties getSdkProperties() {
        return this.sdkProperties;
    }

    protected MccProperties getMccProperties() {
        return this.mccProperties;
    }
}

