/*
 * Decompiled with CFR 0.152.
 */
package cn.insmart.mp.uc.sdk.support;

import cn.insmart.mp.uc.sdk.ApiFactory;
import cn.insmart.mp.uc.sdk.ApiFactoryManager;
import cn.insmart.mp.uc.sdk.config.SdkProperties;
import cn.insmart.mp.uc.sdk.support.DefaultApiFactory;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultApiFactoryManager
implements ApiFactoryManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultApiFactoryManager.class);
    private final SdkProperties sdkProperties;
    private final Map<String, ApiFactory> factoryMap = new ConcurrentHashMap<String, ApiFactory>();

    @Override
    public ApiFactory getServiceFactory(String username) {
        return this.factoryMap.computeIfAbsent(username, key -> {
            List<SdkProperties.DefaultMccProperties> mccProperties = this.sdkProperties.getMccProperties();
            Optional<SdkProperties.DefaultMccProperties> first = mccProperties.stream().filter(e -> Objects.equals(e.getUsername(), username)).findFirst();
            SdkProperties.DefaultMccProperties properties = first.orElseThrow(() -> new RuntimeException("\u627e\u4e0d\u5230\u7ba1\u5bb6\u8d26\u53f7: %s" + username));
            return new DefaultApiFactory(this.sdkProperties, properties);
        });
    }

    @Override
    public List<String> getUserNameList() {
        return this.sdkProperties.getMccProperties().stream().map(SdkProperties.DefaultMccProperties::getUsername).collect(Collectors.toList());
    }

    public DefaultApiFactoryManager(SdkProperties sdkProperties) {
        this.sdkProperties = Objects.requireNonNull(sdkProperties, "SdkProperties is null");
    }

    @Override
    public ApiFactory getApiFactory() {
        return new DefaultApiFactory(this.sdkProperties, null);
    }

    @Override
    public SdkProperties getSdkProperties() {
        return this.sdkProperties;
    }
}

