/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.activity.api.facade.v1;

import cn.pcauto.sem.activity.api.facade.v1.dto.ActivityAreaDTO;
import cn.pcauto.sem.activity.api.facade.v1.dto.ActivityDTO;
import cn.pcauto.sem.activity.api.facade.v1.dto.ActivityEventTypeAndBrandNameDTO;
import cn.pcauto.sem.activity.api.facade.v1.dto.ActivityExtendDTO;
import cn.pcauto.sem.activity.api.facade.v1.dto.ActivityUrlDTO;
import cn.pcauto.sem.activity.api.facade.v1.dto.EnrollCountDTO;
import cn.pcauto.sem.activity.api.facade.v1.dto.EventDTO;
import cn.pcauto.sem.activity.api.facade.v1.dto.TempDTO;
import cn.pcauto.sem.activity.api.facade.v1.enums.EnrollIdTypeEnum;
import cn.pcauto.sem.common.enums.ChannelEnum;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@FeignClient(name="is-sem-activity", path="/rpc/v1/activities", url="${service.direct-url.is-sem-activity:}", contextId="activity", primary=false)
public interface ActivityFacade {
    public static final String PATH = "/rpc/v1/activities";

    @ResponseBody
    @RequestMapping(value={"/updateActivity"})
    public Boolean updateActivityAdc(@RequestParam(value="id") Long var1, @RequestParam(value="userName") String var2, @RequestParam(value="status") Integer var3);

    @ResponseBody
    @RequestMapping(value={"/activityList"})
    public List<ActivityDTO> getActivityListWithTaskIdByIds(@RequestParam(value="ids") Collection<Long> var1);

    @ResponseBody
    @RequestMapping(value={""})
    public List<ActivityDTO> get(@RequestParam(value="channel") ChannelEnum var1);

    @ResponseBody
    @RequestMapping(value={"/getIdsForChannel"})
    public List<Long> getIdsForChannel(@RequestParam(value="channel") ChannelEnum var1);

    @ResponseBody
    @RequestMapping(value={"/getIdsByChannel"})
    public List<Long> getIdsByChannel(@RequestParam(value="channel") ChannelEnum var1);

    @ResponseBody
    @RequestMapping(value={"/canExtend"})
    public Boolean canExtend(@RequestParam(value="id") Long var1);

    @ResponseBody
    @RequestMapping(value={"/getAct"})
    public ActivityDTO getAct(@RequestParam(value="id") Long var1);

    @ResponseBody
    @RequestMapping(value={"/one"})
    public ActivityDTO getActivityById(@RequestParam(value="id") Long var1);

    @ResponseBody
    @RequestMapping(value={"/listAct"})
    public List<ActivityDTO> listAct(@RequestParam(value="ids") List<Long> var1);

    @ResponseBody
    @RequestMapping(value={"/getActEventTyp"})
    public ActivityEventTypeAndBrandNameDTO getActivityEventTypeAndBrandName(@RequestParam(value="id") Long var1);

    @ResponseBody
    @PostMapping(value={"/refresh"})
    public Boolean refresh(@RequestBody List<ActivityExtendDTO> var1);

    @ResponseBody
    @PostMapping(value={"/assignUrl"})
    public Boolean assignUrl(@RequestBody List<ActivityUrlDTO> var1);

    @ResponseBody
    @PostMapping(value={"/getEnrollCount/{date}"})
    public List<EnrollCountDTO> getEnrollCount(@RequestParam(value="channel") ChannelEnum var1, @PathVariable(value="date") @DateTimeFormat(pattern="yyyyMMdd") LocalDate var2, @RequestParam(value="enrollIdType") EnrollIdTypeEnum var3);

    @ResponseBody
    @PostMapping(value={"/saveShowAct"})
    public Long saveShowAct(@RequestBody Collection<ActivityDTO> var1);

    @ResponseBody
    @PatchMapping(value={"/{id}"})
    public void updateSerials(@NotNull @PathVariable(value="id") Long var1, @Nullable @RequestBody ActivityDTO var2);

    @ResponseBody
    @RequestMapping(value={"/getShowAct"})
    public ActivityDTO getShowAct(@RequestParam(value="channel") ChannelEnum var1, @RequestParam(value="roleId") Long var2, @RequestParam(value="areaCode") Long var3);

    @ResponseBody
    @RequestMapping(value={"/findTemp"})
    public TempDTO findTemp(@RequestParam(value="id") Long var1);

    @ResponseBody
    @PostMapping(value={"/saveAutoSync"})
    public Boolean saveAutoSync(@RequestBody ActivityDTO var1);

    @ResponseBody
    @PostMapping(value={"/saveIgnoreAutoSyncCitys"})
    public Boolean saveIgnoreAutoSyncCitys(@RequestBody ActivityDTO var1);

    @ResponseBody
    @PostMapping(value={"/refreshChannelStatus"})
    public Boolean refreshChannelStatus(@RequestBody List<ActivityDTO> var1);

    @ResponseBody
    @GetMapping(value={"/getIdsOfActivity"})
    public List<Long> getIdsOfActivity(@RequestParam Long var1);

    @ResponseBody
    @GetMapping(value={"/toutiaoConvertAdcPublishTime"})
    public void setToutiaoConvertAdcPublishTime(@RequestParam Long var1);

    @ResponseBody
    @GetMapping(value={"/getSingleSearial"})
    public List<Integer> getDistinctSerialId();

    @ResponseBody
    @GetMapping(value={"/getBaiduFeedsActivity"})
    public List<ActivityDTO> getBaiduFeedsActivity();

    @ResponseBody
    @GetMapping(value={"/getMidChannelAct"})
    public ActivityDTO getMidChannelAct(@RequestParam(value="manufacturerId") Long var1, @RequestParam(value="channelEnum") ChannelEnum var2);

    @ResponseBody
    @GetMapping(value={"/getAreaByActId"})
    public List<ActivityAreaDTO> getAreaByActId(@RequestParam(value="actId") Long var1);

    @ResponseBody
    @GetMapping(value={"/updateEcount"})
    public void updateEcount(@RequestParam(value="activityId") Long var1, @RequestParam(value="num") int var2);

    @ResponseBody
    @RequestMapping(value={"/updateChannelItems"})
    public int updateChannelItems(@RequestParam(value="actId") Long var1, @RequestParam(value="channelItems") String var2);

    @ResponseBody
    @RequestMapping(value={"/updateExtendStatus"})
    public int updateExtendStatus(@RequestParam(value="actId") Long var1, @RequestParam(value="extendStatus") Integer var2, @RequestParam(value="allSerialOpen") Boolean var3);

    @ResponseBody
    @RequestMapping(value={"/queryAccountInfo"})
    public Long queryAccountInfo(@RequestParam(value="roleId") Long var1, @RequestParam(value="channel") String var2);

    @ResponseBody
    @GetMapping(value={"/getEventById"})
    public EventDTO getEventById(@RequestParam(value="pid") Long var1);

    @ResponseBody
    @GetMapping(value={"/getSyncNotEntryIdConditions"})
    public List<Long> getSyncNotEntryIdConditions();

    @ResponseBody
    @PostMapping(value={"/updateSingleBrandSerials"})
    public void updateSingleBrandSerials(@NotNull @RequestParam(value="activityId") Long var1, @NotNull @RequestParam(value="serialIds") List<Long> var2);
}

