/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.activity.api.facade.v1;

import cn.pcauto.sem.activity.api.facade.v1.dto.AutoDTO;
import cn.pcauto.sem.activity.api.facade.v1.dto.AutoTreeNodeDTO;
import cn.pcauto.sem.activity.api.facade.v1.dto.BrandDTO;
import cn.pcauto.sem.activity.api.facade.v1.dto.HotSerialDTO;
import cn.pcauto.sem.activity.api.facade.v1.dto.ManufacturerDetailDTO;
import cn.pcauto.sem.activity.api.facade.v1.dto.SerialDetailDTO;
import java.util.List;
import java.util.Set;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@FeignClient(name="is-sem-activity", path="/rpc/v1/auto", url="${service.direct-url.is-sem-activity:}", contextId="autoSerial", primary=false)
public interface AutoSerialFacade {
    @Deprecated
    public static final String OPEN_PATH = "/open-rpc/v1/auto";
    public static final String PATH = "/rpc/v1/auto";

    @ResponseBody
    @RequestMapping(value={"serial/hots"})
    public List<HotSerialDTO> hots();

    @ResponseBody
    @RequestMapping(value={"manufacturers/{mid}/hots"})
    public List<SerialDetailDTO> hotSerialByManufacturer(@PathVariable(name="mid") Long var1, @RequestParam(name="limit", required=false) Integer var2);

    @ResponseBody
    @RequestMapping(value={"manufacturers/hotSerialByManufacturerInSerialIds"})
    public SerialDetailDTO hotSerialByManufacturerInSerialIds(@RequestParam(name="mid") Long var1, @RequestParam(name="openSerialIds") List<Long> var2);

    @ResponseBody
    @RequestMapping(value={"brands"})
    public List<BrandDTO> getBrandList();

    @ResponseBody
    @RequestMapping(value={"brands/{id}"})
    public BrandDTO getBrand(@PathVariable(value="id") Long var1);

    @ResponseBody
    @RequestMapping(value={"brands/names"})
    public List<BrandDTO> getBrandListByNames(@RequestParam(required=true, name="brandNames") Set<String> var1);

    @ResponseBody
    @RequestMapping(value={"brands/name/{brandName}"})
    public List<BrandDTO> getBrandByName(@PathVariable(value="brandName") String var1);

    @ResponseBody
    @RequestMapping(value={"manufacturers"})
    public List<ManufacturerDetailDTO> getManufacturerList(@RequestParam(required=false, name="brandIds") List<Long> var1);

    @ResponseBody
    @RequestMapping(value={"manufacturers/{id}"})
    public ManufacturerDetailDTO getManufacturer(@PathVariable(value="id") Long var1);

    @ResponseBody
    @RequestMapping(value={"manufacturers/names"})
    public List<ManufacturerDetailDTO> getManufacturerListByNames(@RequestParam(required=true, name="manufacturerNames") Set<String> var1);

    @ResponseBody
    @RequestMapping(value={"manufacturers/name/{manufacturerName}/{brandName}"})
    public List<ManufacturerDetailDTO> getManufacturerByName(@PathVariable(value="manufacturerName") String var1, @PathVariable(value="brandName") String var2);

    @ResponseBody
    @RequestMapping(value={"serials"})
    public List<SerialDetailDTO> getSerialList(@RequestParam(required=false, name="manufacturerIds") List<Long> var1);

    @ResponseBody
    @RequestMapping(value={"serials/{id}"})
    public SerialDetailDTO getSerial(@PathVariable(value="id") Long var1);

    @ResponseBody
    @RequestMapping(value={"serials/names/{serialNames}"})
    public List<SerialDetailDTO> getSerialListByNames(@RequestParam(required=true, name="serialNames") Set<String> var1);

    @ResponseBody
    @RequestMapping(value={"serials/hottest/{serialIds}"})
    public List<SerialDetailDTO> sortHottestSerial(@RequestParam(required=true, name="serialIds") Set<Long> var1);

    @ResponseBody
    @RequestMapping(value={"serials/compete/{serialId}"})
    public List<SerialDetailDTO> getCompeteSerial(@PathVariable(name="serialId") Long var1, @RequestParam(name="limit", required=false) Integer var2);

    @ResponseBody
    @RequestMapping(value={"/autos"})
    public AutoDTO selectAutoBySerialId();

    @ResponseBody
    @GetMapping(value={"/selectBySerialName"})
    public List<AutoDTO.Auto> selectBySerialName(@RequestParam(value="serialName") String var1);

    @ResponseBody
    @GetMapping(value={"/getOpenSerialPercentage"})
    public Long getOpenSerialPercentage(@RequestParam(value="manufacturerId") Long var1, @RequestParam(value="openSerialIds") List<Long> var2);

    @ResponseBody
    @GetMapping(value={"/tree"})
    public List<AutoTreeNodeDTO> getSerialTree();
}

