/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.activity.api.facade.v1.dto;

import cn.pcauto.sem.activity.api.facade.v1.dto.ReplaceDTO;
import cn.pcauto.sem.activity.api.facade.v1.support.ReplaceKey;
import cn.pcauto.sem.activity.api.facade.v1.util.ReplaceUtils;
import cn.pcauto.sem.common.enums.ChannelEnum;
import cn.pcauto.sem.common.enums.ReplacePositionEnum;
import java.beans.Transient;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ReplacePositionPacket
implements Serializable {
    private ChannelEnum channel;
    private ReplacePositionEnum position;
    private Set<ReplaceDTO> replaceSet;
    private transient Map<ReplaceKey, ReplaceDTO> map;

    public ReplacePositionPacket(ChannelEnum channel, ReplacePositionEnum position) {
        this.channel = channel;
        this.position = position;
    }

    @Transient
    public ReplaceDTO resolveReplace(ReplaceKey ... keys) {
        return ReplaceUtils.resolveReplace(this.getReplaceMap(), keys);
    }

    @Transient
    public ReplaceDTO resolveReplace(Long brandId, Long manufacturerId, Long serialId) {
        return this.resolveReplace(ReplaceUtils.keys(brandId, manufacturerId, serialId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transient
    public Map<ReplaceKey, ReplaceDTO> getReplaceMap() {
        if (this.map == null) {
            ReplacePositionPacket replacePositionPacket = this;
            synchronized (replacePositionPacket) {
                if (this.map == null) {
                    this.map = Objects.nonNull(this.replaceSet) ? this.replaceSet.stream().collect(Collectors.toMap(ReplaceKey::new, Function.identity())) : Collections.emptyMap();
                }
            }
        }
        return this.map;
    }

    public ReplacePositionPacket() {
    }

    public void setChannel(ChannelEnum channel) {
        this.channel = channel;
    }

    public ChannelEnum getChannel() {
        return this.channel;
    }

    public void setPosition(ReplacePositionEnum position) {
        this.position = position;
    }

    public ReplacePositionEnum getPosition() {
        return this.position;
    }

    public void setReplaceSet(Set<ReplaceDTO> replaceSet) {
        this.replaceSet = replaceSet;
    }

    public Set<ReplaceDTO> getReplaceSet() {
        return this.replaceSet;
    }
}

