/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.activity.api.facade.v1.util;

import cn.pcauto.sem.activity.api.facade.v1.dto.ReplaceConfigPacket;
import cn.pcauto.sem.activity.api.facade.v1.dto.ReplaceDTO;
import cn.pcauto.sem.activity.api.facade.v1.dto.ReplacePositionPacket;
import cn.pcauto.sem.activity.api.facade.v1.support.ReplaceKey;
import cn.pcauto.sem.common.enums.ReplacePositionEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ReplaceUtils {
    public static ReplaceKey[] keys(Long brandId) {
        return ReplaceUtils.keys(brandId, null);
    }

    public static ReplaceKey[] keys(Long brandId, Long manufacturerId) {
        return ReplaceUtils.keys(brandId, manufacturerId, null);
    }

    public static ReplaceKey[] keys(Long brandId, Long manufacturerId, Long serialId) {
        Objects.requireNonNull(brandId);
        LinkedHashSet<ReplaceKey> keySet = new LinkedHashSet<ReplaceKey>();
        keySet.add(ReplaceKey.newInstance(brandId, null, null));
        if (Objects.nonNull(manufacturerId)) {
            keySet.add(ReplaceKey.newInstance(brandId, manufacturerId, null));
            if (Objects.nonNull(serialId)) {
                keySet.add(ReplaceKey.newInstance(brandId, manufacturerId, serialId));
            }
        } else if (Objects.nonNull(serialId)) {
            throw new IllegalArgumentException("manufacturerId \u6ca1\u503c\u4f46\u662f serialId \u6709\u503c");
        }
        ArrayList replaceKeys = new ArrayList(keySet);
        Collections.reverse(replaceKeys);
        return replaceKeys.toArray(new ReplaceKey[0]);
    }

    public static ReplaceDTO resolveReplace(Map<ReplaceKey, ReplaceDTO> replaceDataMap, ReplaceKey ... keys) {
        for (ReplaceKey find : keys) {
            ReplaceDTO dto = replaceDataMap.get(find);
            if (!Objects.nonNull(dto)) continue;
            return dto;
        }
        return null;
    }

    public static ReplaceDTO resolveReplace(ReplaceConfigPacket replaceConfigPacket, ReplacePositionEnum position, ReplaceKey ... keys) {
        return Optional.ofNullable(replaceConfigPacket.getPositionReplaceMap()).map(map -> ReplaceUtils.resolveReplace((ReplacePositionPacket)map.get(position), keys)).orElse(null);
    }

    public static ReplaceDTO resolveReplace(ReplacePositionPacket replace4PositionDTO, ReplaceKey ... keys) {
        return Optional.ofNullable(replace4PositionDTO).map(replaceSetDTO -> ReplaceUtils.resolveReplace(replace4PositionDTO.getReplaceMap(), keys)).orElse(null);
    }
}

