/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.autoshow.enroll.sdk.haochi;

import cn.pcauto.sem.autoshow.enroll.sdk.exception.SdkException;
import cn.pcauto.sem.autoshow.enroll.sdk.haochi.HaoChiApiService;
import cn.pcauto.sem.autoshow.enroll.sdk.haochi.HaoChiApiServiceFactory;
import cn.pcauto.sem.autoshow.enroll.sdk.haochi.HaoChiSdkProperties;
import cn.pcauto.sem.autoshow.enroll.sdk.haochi.resp.HaoChiResp;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import feign.Feign;
import feign.InvocationHandlerFactory;
import feign.RequestTemplate;
import feign.codec.Decoder;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HaoChiApiServiceFactoryImpl
implements HaoChiApiServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(HaoChiApiServiceFactoryImpl.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private final HaoChiSdkProperties properties;

    @Override
    public <T extends HaoChiApiService> T create(Class<T> apiInterfaceClass) {
        return (T)((HaoChiApiService)Feign.builder().invocationHandlerFactory((target, dispatch) -> (proxy, method, args) -> {
            if (method.isDefault()) {
                Class<?> declaringClass = method.getDeclaringClass();
                MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(declaringClass, MethodHandles.lookup());
                MethodHandle special = lookup.findSpecial(declaringClass, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), declaringClass);
                return special.bindTo(proxy).invokeWithArguments(args);
            }
            return ((InvocationHandlerFactory.MethodHandler)dispatch.get(method)).invoke(new Object[]{args[0]});
        }).encoder(this::encode).decoder(this.decoder()).target(apiInterfaceClass, this.properties.getApi()));
    }

    public Decoder decoder() {
        return (resp, type) -> {
            Object data;
            byte[] bytes = resp.body().asInputStream().readAllBytes();
            if (this.properties.isDebug()) {
                log.info("\u54cd\u5e94\u6570\u636e: \n{}", (Object)mapper.readTree(bytes).toPrettyString());
            }
            if (!((data = mapper.readValue(bytes, mapper.constructType(type))) instanceof HaoChiResp)) {
                return data;
            }
            HaoChiResp response = (HaoChiResp)data;
            if (!response.success()) {
                log.info("HaoChiApi response businiess error,{}", (Object)JSON.toJSONString((Object)response));
            }
            return data;
        };
    }

    private void encode(Object object, Type bodyType, RequestTemplate template) {
        try {
            template.header("Content-Type", new String[]{this.properties.getContentType()});
            String request = mapper.writeValueAsString(object);
            template.body(request);
            if (this.properties.isDebug()) {
                log.info("\u8bf7\u6c42\u6570\u636e: \n{}", (Object)request);
            }
        }
        catch (JsonProcessingException e) {
            throw new SdkException("\u5e8f\u5217\u5316\u8bf7\u6c42\u4f53\u51fa\u9519", (Throwable)e, new Object[0]);
        }
    }

    public HaoChiApiServiceFactoryImpl(HaoChiSdkProperties properties) {
        this.properties = properties;
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        mapper.registerModule((Module)javaTimeModule);
    }
}

