/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.autoshow.enroll.sdk.sf.service.impl;

import cn.insmart.fx.common.lang.util.StringUtils;
import cn.pcauto.sem.autoshow.enroll.sdk.exception.SdkException;
import cn.pcauto.sem.autoshow.enroll.sdk.sf.SfApiService;
import cn.pcauto.sem.autoshow.enroll.sdk.sf.SfApiServiceFactory;
import cn.pcauto.sem.autoshow.enroll.sdk.sf.autoconfigure.SfProperties;
import cn.pcauto.sem.autoshow.enroll.sdk.sf.resp.SfResp;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.RequestTemplate;
import feign.codec.Decoder;
import feign.httpclient.ApacheHttpClient;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SfApiServiceFactoryImpl
implements SfApiServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(SfApiServiceFactoryImpl.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final SfProperties properties;

    @Override
    public <T extends SfApiService> T create(Class<T> apiInterfaceClass) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (StringUtils.isNotBlank((CharSequence)this.properties.getHost())) {
            HttpHost httpHost = new HttpHost(this.properties.getHost(), this.properties.getPort());
            builder.setProxy(httpHost);
        }
        return (T)((SfApiService)Feign.builder().client((Client)new ApacheHttpClient((HttpClient)builder.build())).logLevel(Logger.Level.FULL).logger(new feign.Logger(){

            protected void log(String configKey, String format, Object ... args) {
                log.debug("feign: {}, {}, {}", new Object[]{configKey, format, args});
            }
        }).encoder(this::encode).decoder(this.decoder()).target(apiInterfaceClass, this.properties.getApi()));
    }

    public Decoder decoder() {
        return (resp, type) -> {
            Object data;
            byte[] bytes = resp.body().asInputStream().readAllBytes();
            if (this.properties.isDebug()) {
                log.info("\u54cd\u5e94\u6570\u636e: \n{}", (Object)MAPPER.readTree(bytes).toPrettyString());
            }
            if (!((data = MAPPER.readValue(bytes, MAPPER.constructType(type))) instanceof SfResp)) {
                return data;
            }
            SfResp response = (SfResp)data;
            if (!response.success()) {
                log.info("sf response businiess error,{}", (Object)JSON.toJSONString((Object)response));
            }
            return data;
        };
    }

    private void encode(Object object, Type bodyType, RequestTemplate template) {
        try {
            String request = MAPPER.writeValueAsString(object);
            template.body(request);
            if (this.properties.isDebug()) {
                log.info("\u8bf7\u6c42\u6570\u636e: \n{}", (Object)request);
            }
        }
        catch (JsonProcessingException e) {
            throw new SdkException("\u5e8f\u5217\u5316\u8bf7\u6c42\u4f53\u51fa\u9519", (Throwable)e, new Object[0]);
        }
    }

    public SfApiServiceFactoryImpl(SfProperties properties) {
        this.properties = properties;
    }

    static {
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        MAPPER.configure(SerializationFeature.INDENT_OUTPUT, true);
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        MAPPER.registerModule((Module)javaTimeModule);
    }
}

