/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.autoshow.enroll.sdk.taojinyun.service.impl;

import cn.insmart.fx.common.lang.util.StringUtils;
import cn.pcauto.sem.autoshow.enroll.sdk.taojinyun.TaojinyunApiService;
import cn.pcauto.sem.autoshow.enroll.sdk.taojinyun.TaojinyunApiServiceFactory;
import cn.pcauto.sem.autoshow.enroll.sdk.taojinyun.autoconfigure.TaojinyunProperties;
import cn.pcauto.sem.autoshow.enroll.sdk.taojinyun.codec.JacksonDecoder;
import cn.pcauto.sem.autoshow.enroll.sdk.taojinyun.codec.JacksonEncoder;
import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.FormEncoder;
import feign.httpclient.ApacheHttpClient;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TaojinyunApiServiceFactoryImpl
implements TaojinyunApiServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(TaojinyunApiServiceFactoryImpl.class);
    private final TaojinyunProperties properties;

    @Override
    public <T extends TaojinyunApiService> T create(Class<T> apiInterfaceClass) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (StringUtils.isNotBlank((CharSequence)this.properties.getHost())) {
            HttpHost httpHost = new HttpHost(this.properties.getHost(), this.properties.getPort());
            builder.setProxy(httpHost);
        }
        return (T)((TaojinyunApiService)Feign.builder().client((Client)new ApacheHttpClient((HttpClient)builder.build())).logLevel(Logger.Level.FULL).logger(new feign.Logger(){

            protected void log(String configKey, String format, Object ... args) {
                log.debug("feign: {}, {}, {}", new Object[]{configKey, format, args});
            }
        }).encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder())).decoder((Decoder)new JacksonDecoder()).target(apiInterfaceClass, this.properties.getApi()));
    }

    public TaojinyunApiServiceFactoryImpl(TaojinyunProperties properties) {
        this.properties = properties;
    }
}

