/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.baidu.sdk.core.support;

import cn.pcauto.sem.baidu.sdk.core.ApiExecutor;
import cn.pcauto.sem.baidu.sdk.core.dto.Failure;
import cn.pcauto.sem.baidu.sdk.core.dto.ListBody;
import cn.pcauto.sem.baidu.sdk.core.dto.Response;
import cn.pcauto.sem.baidu.sdk.core.exception.FailureIndexNotFindException;
import cn.pcauto.sem.baidu.sdk.core.support.ResponseBinder;
import cn.pcauto.sem.baidu.sdk.core.support.ResultBinder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiExecuteDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiExecuteDelegate.class);

    public static <T, R> Response<ListBody<R>> execute(ApiExecutor<T, ListBody<R>> executor, T data) {
        return executor.execute(data);
    }

    public static <T, R> Response<ListBody<R>> execute(ApiExecutor<List<T>, ListBody<R>> executor, List<T> list) {
        return executor.execute(list);
    }

    public static <A, T, R> Response<ListBody<R>> execute(ApiExecutor<List<T>, ListBody<R>> executor, Function<A, T> mapper, List<A> data) {
        return executor.execute(data.stream().map(mapper).collect(Collectors.toList()));
    }

    public static <T, U, R> List<R> execute(ApiExecutor<List<U>, ListBody<U>> executor, List<T> list, Function<T, U> mapper, BiFunction<ResultBinder<T, U>, Response<ListBody<U>>, R> function) {
        if (Objects.isNull(list) || list.isEmpty()) {
            return Collections.emptyList();
        }
        Response response = executor.execute(list.stream().map(mapper).collect(Collectors.toList()));
        if (list.size() == 1) {
            return CollectionUtils.isEmpty(response.failures()) ? Collections.singletonList(function.apply(new ResultBinder(list.get(0), response.getBody().get(0).get()), response)) : Collections.singletonList(function.apply(new ResultBinder<T, List<Failure>>(list.get(0), response.failures()), response));
        }
        try {
            List<Failure> failures = response.getHeader().getFailures();
            List binds = ResponseBinder.bind(response, list);
            if (CollectionUtils.isEmpty(failures)) {
                LOGGER.info("luckily batch execute success. {} size {}", list.get(0).getClass(), (Object)list.size());
                return binds.stream().map(e -> Collections.singletonList(function.apply((ResultBinder)e, response))).flatMap(Collection::stream).collect(Collectors.toList());
            }
            return binds.parallelStream().map(bind -> {
                if (bind.isSuccess()) {
                    return Collections.singletonList(function.apply((ResultBinder)bind, response));
                }
                return ApiExecuteDelegate.execute(executor, Collections.singletonList(bind.getLocal()), mapper, function);
            }).flatMap(Collection::stream).collect(Collectors.toList());
        }
        catch (FailureIndexNotFindException ex) {
            LOGGER.warn("batch execute failure bind result error. one by one execute ");
            return ListUtils.partition(list, (int)2).stream().map(e -> ApiExecuteDelegate.execute(executor, e, mapper, function)).filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
        }
    }

    public static <T, U> void execute(ApiExecutor<List<U>, ListBody<U>> executor, List<T> list, Function<T, U> mapper, BiConsumer<ResultBinder<T, U>, Response<ListBody<U>>> consumer) {
        ApiExecuteDelegate.execute(executor, list, mapper, (ResultBinder<T, U> tuResultBinder, Response<ListBody<U>> listBodyResponse) -> {
            consumer.accept((ResultBinder)tuResultBinder, (Response)listBodyResponse);
            return null;
        });
    }
}

