/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.baidu.sdk.core.support;

import cn.pcauto.sem.baidu.sdk.configuration.SdkProperties;
import cn.pcauto.sem.baidu.sdk.core.support.TokenProvider;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.jdbc.DataSourceBuilder;

public class DataSourceTokenProvider
implements TokenProvider {
    private static final Logger log = LoggerFactory.getLogger(DataSourceTokenProvider.class);
    private final DataSource dataSource;
    private final SdkProperties.DataSourceProperties dataSourceProperties;

    public DataSourceTokenProvider(SdkProperties.DataSourceProperties dataSourceProperties) {
        this.dataSourceProperties = dataSourceProperties;
        DataSourceBuilder dataSourceBuilder = DataSourceBuilder.create();
        dataSourceBuilder.username(Objects.requireNonNull(dataSourceProperties.getUsername(), "\u6570\u636e\u5e93\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        dataSourceBuilder.password(Objects.requireNonNull(dataSourceProperties.getPassword(), "\u6570\u636e\u5e93\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        dataSourceBuilder.url(Objects.requireNonNull(dataSourceProperties.getUrl(), "\u6570\u636e\u5e93URL\u4e0d\u80fd\u4e3a\u7a7a"));
        if (Objects.nonNull(dataSourceProperties.getType())) {
            dataSourceBuilder.type(dataSourceProperties.getType());
        }
        if (Objects.nonNull(dataSourceProperties.getDriverClassName())) {
            dataSourceBuilder.driverClassName(dataSourceProperties.getDriverClassName());
        }
        this.dataSource = dataSourceBuilder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getToken(String feedAccount) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement ps = connection.prepareStatement(this.dataSourceProperties.getSql());){
            ps.setString(1, feedAccount);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) throw new RuntimeException("\u6ca1\u627e\u5230\u5e7f\u544a\u4e3b\u7684token, feedAccount = " + feedAccount);
                String string = rs.getString(1);
                return string;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

