/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.baidu.sdk.service.search;

import cn.pcauto.sem.baidu.sdk.core.ApiService;
import cn.pcauto.sem.baidu.sdk.core.annotation.QpsLimit;
import cn.pcauto.sem.baidu.sdk.core.dto.ListBody;
import cn.pcauto.sem.baidu.sdk.core.dto.ListBodyResponse;
import cn.pcauto.sem.baidu.sdk.core.dto.Response;
import cn.pcauto.sem.baidu.sdk.service.search.dto.CampaignType;
import com.fasterxml.jackson.annotation.JsonProperty;
import feign.RequestLine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public interface CampaignApiService
extends ApiService<CampaignType> {
    @QpsLimit
    @RequestLine(value="POST /json/sms/service/CampaignService/getCampaign")
    public ListBodyResponse<CampaignType> get(GetRequest var1);

    @QpsLimit(value=30)
    @RequestLine(value="POST /json/sms/service/CampaignService/addCampaign")
    public ListBodyResponse<CampaignType> add(Request var1);

    @QpsLimit(value=30)
    @RequestLine(value="POST /json/sms/service/CampaignService/updateCampaign")
    public ListBodyResponse<CampaignType> update(Request var1);

    @RequestLine(value="POST /json/sms/service/CampaignService/deleteCampaign")
    public ListBodyResponse<CampaignType> delete(IdsRequest var1);

    default public List<CampaignType> get(List<Long> ids, String ... fields) {
        return this.get(new GetRequest(ids, fields)).list();
    }

    default public List<CampaignType> get(String ... fields) {
        return this.get(Collections.emptyList(), fields);
    }

    default public Map<String, Long> getCampaignNameMap() {
        return this.toMap(this.get("campaignId", "campaignName"), CampaignType::getCampaignName, CampaignType::getCampaignId);
    }

    @Override
    default public Response<ListBody<CampaignType>> add(List<CampaignType> list) {
        return this.add(new Request(list));
    }

    @Override
    default public Response<ListBody<CampaignType>> update(List<CampaignType> list) {
        return this.update(new Request(list));
    }

    public static class GetRequest {
        public static final List<String> FIELDS = Arrays.asList("campaignId", "campaignName", "budget", "budgetOfflineTime", "campaignType", "device", "exactNegativeWords", "isDynamicCreative", "isDynamicTagSublink", "isDynamicTitle", "isDynamicHotRedirect", "regionTarget", "negativeWords", "pause", "priceRatio", "pcPriceRatio", "schedule", "showProb", "status", "bidPrefer");
        @JsonProperty(value="campaignFields")
        private List<String> fields = FIELDS;
        private List<Long> campaignIds = new ArrayList<Long>();
        private Integer mobileExtend = 1;

        GetRequest(List<Long> campaignIds, String ... fields) {
            this.fields = fields.length == 0 ? FIELDS : Arrays.asList(fields);
            this.campaignIds = campaignIds;
        }

        public List<String> getFields() {
            return this.fields;
        }

        public List<Long> getCampaignIds() {
            return this.campaignIds;
        }

        public Integer getMobileExtend() {
            return this.mobileExtend;
        }

        @JsonProperty(value="campaignFields")
        public void setFields(List<String> fields) {
            this.fields = fields;
        }

        public void setCampaignIds(List<Long> campaignIds) {
            this.campaignIds = campaignIds;
        }

        public void setMobileExtend(Integer mobileExtend) {
            this.mobileExtend = mobileExtend;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetRequest)) {
                return false;
            }
            GetRequest other = (GetRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$mobileExtend = this.getMobileExtend();
            Integer other$mobileExtend = other.getMobileExtend();
            if (this$mobileExtend == null ? other$mobileExtend != null : !((Object)this$mobileExtend).equals(other$mobileExtend)) {
                return false;
            }
            List<String> this$fields = this.getFields();
            List<String> other$fields = other.getFields();
            if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
                return false;
            }
            List<Long> this$campaignIds = this.getCampaignIds();
            List<Long> other$campaignIds = other.getCampaignIds();
            return !(this$campaignIds == null ? other$campaignIds != null : !((Object)this$campaignIds).equals(other$campaignIds));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GetRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $mobileExtend = this.getMobileExtend();
            result = result * 59 + ($mobileExtend == null ? 43 : ((Object)$mobileExtend).hashCode());
            List<String> $fields = this.getFields();
            result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
            List<Long> $campaignIds = this.getCampaignIds();
            result = result * 59 + ($campaignIds == null ? 43 : ((Object)$campaignIds).hashCode());
            return result;
        }

        public String toString() {
            return "CampaignApiService.GetRequest(fields=" + this.getFields() + ", campaignIds=" + this.getCampaignIds() + ", mobileExtend=" + this.getMobileExtend() + ")";
        }

        public GetRequest() {
        }
    }

    public static class IdsRequest {
        @JsonProperty(value="campaignIds")
        private List<Long> campaignIds;

        public List<Long> getCampaignIds() {
            return this.campaignIds;
        }

        @JsonProperty(value="campaignIds")
        public void setCampaignIds(List<Long> campaignIds) {
            this.campaignIds = campaignIds;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IdsRequest)) {
                return false;
            }
            IdsRequest other = (IdsRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Long> this$campaignIds = this.getCampaignIds();
            List<Long> other$campaignIds = other.getCampaignIds();
            return !(this$campaignIds == null ? other$campaignIds != null : !((Object)this$campaignIds).equals(other$campaignIds));
        }

        protected boolean canEqual(Object other) {
            return other instanceof IdsRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Long> $campaignIds = this.getCampaignIds();
            result = result * 59 + ($campaignIds == null ? 43 : ((Object)$campaignIds).hashCode());
            return result;
        }

        public String toString() {
            return "CampaignApiService.IdsRequest(campaignIds=" + this.getCampaignIds() + ")";
        }

        public IdsRequest(List<Long> campaignIds) {
            this.campaignIds = campaignIds;
        }

        public IdsRequest() {
        }
    }

    public static class Request {
        @JsonProperty(value="campaignTypes")
        final List<CampaignType> list;

        public Request(List<CampaignType> list) {
            this.list = list;
        }

        public List<CampaignType> getList() {
            return this.list;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request other = (Request)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<CampaignType> this$list = this.getList();
            List<CampaignType> other$list = other.getList();
            return !(this$list == null ? other$list != null : !((Object)this$list).equals(other$list));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Request;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<CampaignType> $list = this.getList();
            result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
            return result;
        }

        public String toString() {
            return "CampaignApiService.Request(list=" + this.getList() + ")";
        }
    }
}

