/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.baidu.sdk.service.search;

import cn.insmart.fx.common.lang.util.CollectionUtils;
import cn.pcauto.sem.baidu.sdk.core.ApiService;
import cn.pcauto.sem.baidu.sdk.core.annotation.QpsLimit;
import cn.pcauto.sem.baidu.sdk.core.dto.ListBody;
import cn.pcauto.sem.baidu.sdk.core.dto.Response;
import cn.pcauto.sem.baidu.sdk.service.search.dto.KeywordType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import feign.RequestLine;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public interface KeywordApiService
extends ApiService<KeywordType> {
    @QpsLimit(value=5)
    @RequestLine(value="POST /json/sms/service/KeywordService/getWord")
    public Response<ListBody<KeywordType>> get(GetRequest var1);

    @QpsLimit(value=5)
    @RequestLine(value="POST /json/sms/service/KeywordService/addWord")
    public Response<ListBody<KeywordType>> add(Request var1);

    @QpsLimit(value=20)
    @RequestLine(value="POST /json/sms/service/KeywordService/updateWord")
    public Response<ListBody<KeywordType>> update(Request var1);

    @QpsLimit(value=20)
    @RequestLine(value="POST /json/sms/service/KeywordService/deleteWord")
    public Response<ListBody<KeywordType>> delete(keywordIds var1);

    default public List<KeywordType> get(IdType type, List<Long> ids, String ... fields) {
        return this.get(new GetRequest(ids, type, fields)).list();
    }

    default public List<KeywordType> getWordById(Long id, String ... fields) {
        return this.getWordByIds(Collections.singletonList(id), fields);
    }

    default public List<KeywordType> getWordByIds(List<Long> ids, String ... fields) {
        return this.get(IdType.KEYWORD, ids, fields);
    }

    default public List<KeywordType> getWordByAdgroupId(Long adgroupId, String ... fields) {
        return this.get(IdType.ADGROUP, Collections.singletonList(adgroupId), fields);
    }

    default public Map<String, Long> getWordNameMapByAdgroupId(Long adgroupId) {
        return this.toMap(this.getWordByAdgroupId(adgroupId, "keywordId", "keyword"), KeywordType::getKeyword, KeywordType::getKeywordId);
    }

    @Override
    default public Response<ListBody<KeywordType>> add(List<KeywordType> list) {
        return this.add(new Request(list));
    }

    @Override
    default public Response<ListBody<KeywordType>> update(List<KeywordType> list) {
        return this.update(new Request(list));
    }

    public static class keywordIds {
        @JsonProperty(value="keywordIds")
        private final List<Long> ids;

        public keywordIds(List<Long> ids) {
            this.ids = ids;
        }

        public List<Long> getIds() {
            return this.ids;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof keywordIds)) {
                return false;
            }
            keywordIds other = (keywordIds)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Long> this$ids = this.getIds();
            List<Long> other$ids = other.getIds();
            return !(this$ids == null ? other$ids != null : !((Object)this$ids).equals(other$ids));
        }

        protected boolean canEqual(Object other) {
            return other instanceof keywordIds;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Long> $ids = this.getIds();
            result = result * 59 + ($ids == null ? 43 : ((Object)$ids).hashCode());
            return result;
        }

        public String toString() {
            return "KeywordApiService.keywordIds(ids=" + this.getIds() + ")";
        }
    }

    public static class Request {
        @JsonProperty(value="keywordTypes")
        private final List<KeywordType> list;

        public Request(List<KeywordType> list) {
            this.list = list;
        }

        public List<KeywordType> getList() {
            return this.list;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request other = (Request)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<KeywordType> this$list = this.getList();
            List<KeywordType> other$list = other.getList();
            return !(this$list == null ? other$list != null : !((Object)this$list).equals(other$list));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Request;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<KeywordType> $list = this.getList();
            result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
            return result;
        }

        public String toString() {
            return "KeywordApiService.Request(list=" + this.getList() + ")";
        }
    }

    public static class GetRequest {
        public static final List<String> FIELDS = Arrays.asList("keywordId", "campaignId", "adgroupId", "keyword", "price", "pause", "matchType", "phraseType", "status", "wmatchprefer", "pcDestinationUrl", "pcQuality", "pcScale", "mobileDestinationUrl", "mobileQuality", "mobileScale", "tabs", "leftPriceGuide", "mPriceGuide", "pcQualityFactor", "mobileQualityFactor", "miniProgramUrl", "offlineReasons", "strategyId");
        @JsonProperty(value="wordFields")
        private List<String> wordFields;
        private List<Long> ids;
        private IdType idType;
        private Integer getTemp = 0;

        public GetRequest(List<Long> ids, IdType idType, String ... wordFields) {
            this.wordFields = CollectionUtils.isEmpty(this.wordFields) ? FIELDS : Arrays.asList(wordFields);
            this.ids = ids;
            this.idType = idType;
        }

        public List<String> getWordFields() {
            return this.wordFields;
        }

        public List<Long> getIds() {
            return this.ids;
        }

        public IdType getIdType() {
            return this.idType;
        }

        public Integer getGetTemp() {
            return this.getTemp;
        }

        @JsonProperty(value="wordFields")
        public void setWordFields(List<String> wordFields) {
            this.wordFields = wordFields;
        }

        public void setIds(List<Long> ids) {
            this.ids = ids;
        }

        public void setIdType(IdType idType) {
            this.idType = idType;
        }

        public void setGetTemp(Integer getTemp) {
            this.getTemp = getTemp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetRequest)) {
                return false;
            }
            GetRequest other = (GetRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$getTemp = this.getGetTemp();
            Integer other$getTemp = other.getGetTemp();
            if (this$getTemp == null ? other$getTemp != null : !((Object)this$getTemp).equals(other$getTemp)) {
                return false;
            }
            List<String> this$wordFields = this.getWordFields();
            List<String> other$wordFields = other.getWordFields();
            if (this$wordFields == null ? other$wordFields != null : !((Object)this$wordFields).equals(other$wordFields)) {
                return false;
            }
            List<Long> this$ids = this.getIds();
            List<Long> other$ids = other.getIds();
            if (this$ids == null ? other$ids != null : !((Object)this$ids).equals(other$ids)) {
                return false;
            }
            IdType this$idType = this.getIdType();
            IdType other$idType = other.getIdType();
            return !(this$idType == null ? other$idType != null : !((Object)((Object)this$idType)).equals((Object)other$idType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GetRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $getTemp = this.getGetTemp();
            result = result * 59 + ($getTemp == null ? 43 : ((Object)$getTemp).hashCode());
            List<String> $wordFields = this.getWordFields();
            result = result * 59 + ($wordFields == null ? 43 : ((Object)$wordFields).hashCode());
            List<Long> $ids = this.getIds();
            result = result * 59 + ($ids == null ? 43 : ((Object)$ids).hashCode());
            IdType $idType = this.getIdType();
            result = result * 59 + ($idType == null ? 43 : ((Object)((Object)$idType)).hashCode());
            return result;
        }

        public String toString() {
            return "KeywordApiService.GetRequest(wordFields=" + this.getWordFields() + ", ids=" + this.getIds() + ", idType=" + this.getIdType() + ", getTemp=" + this.getGetTemp() + ")";
        }

        public GetRequest() {
        }

        public GetRequest(List<String> wordFields, List<Long> ids, IdType idType, Integer getTemp) {
            this.wordFields = wordFields;
            this.ids = ids;
            this.idType = idType;
            this.getTemp = getTemp;
        }
    }

    public static enum IdType {
        ADGROUP(5),
        KEYWORD(11);

        @JsonValue
        private final int value;

        private IdType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

