/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.baidu.sdk.service.search;

import cn.pcauto.sem.baidu.sdk.core.ApiService;
import cn.pcauto.sem.baidu.sdk.core.annotation.QpsLimit;
import cn.pcauto.sem.baidu.sdk.core.dto.ListBody;
import cn.pcauto.sem.baidu.sdk.core.dto.ListBodyResponse;
import cn.pcauto.sem.baidu.sdk.core.exception.SdkException;
import cn.pcauto.sem.baidu.sdk.service.search.dto.KeywordQueryReport;
import cn.pcauto.sem.baidu.sdk.service.search.dto.ProfessionalReportId;
import cn.pcauto.sem.baidu.sdk.service.search.dto.RealTimeRequestType;
import cn.pcauto.sem.baidu.sdk.service.search.dto.ReportFileUrl;
import cn.pcauto.sem.baidu.sdk.service.search.dto.ReportState;
import cn.pcauto.sem.baidu.sdk.service.search.dto.SearchReport;
import cn.pcauto.sem.baidu.sdk.service.search.enums.DeviceEnum;
import cn.pcauto.sem.baidu.sdk.service.search.enums.LevelOfDetailEnum;
import cn.pcauto.sem.baidu.sdk.service.search.enums.ReportTypeEnum;
import cn.pcauto.sem.baidu.sdk.service.search.enums.StatRangeEnum;
import cn.pcauto.sem.baidu.sdk.service.search.enums.UnitOfTimeEnum;
import feign.RequestLine;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public interface ReportService
extends ApiService {
    @QpsLimit(value=50)
    @RequestLine(value="POST  /json/sms/service/ReportService/getRealTimeData")
    public ListBodyResponse<SearchReport> getReport(Request var1);

    @QpsLimit(value=10)
    @RequestLine(value="POST /json/sms/service/ReportService/getRealTimeQueryData")
    public ListBodyResponse<KeywordQueryReport> getRealTimeQueryData(QueryRequest var1);

    @QpsLimit(value=10)
    @RequestLine(value="POST /json/sms/service/ReportService/getProfessionalReportId")
    public ListBodyResponse<ProfessionalReportId> getProfessionalReportId(ProfessionalReportRequest var1);

    @QpsLimit(value=10)
    @RequestLine(value="POST /json/sms/service/ReportService/getReportState")
    public ListBodyResponse<ReportState> getReportState(ProfessionalReportId var1);

    @QpsLimit(value=10)
    @RequestLine(value="POST /json/sms/service/ReportService/getReportFileUrl")
    public ListBodyResponse<ReportFileUrl> getReportFileUrl(ProfessionalReportId var1);

    @QpsLimit(value=10)
    @RequestLine(value="POST /json/sms/service/OpenApiReportService/getReportData")
    public ListBodyResponse<ReportData> getReportData(ReportDataRequest var1);

    default public URI getReportFileUrl(RealTimeRequestType request) {
        ListBodyResponse<ProfessionalReportId> response = this.getProfessionalReportId(new ProfessionalReportRequest(request));
        System.out.println(response);
        ProfessionalReportId professionalReportId = response.get(0);
        Consumer<Integer> sleep = time -> {
            try {
                Thread.sleep(time * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        };
        sleep.accept(1);
        ReportState reportState = null;
        for (int i = 1; i < 60; ++i) {
            ListBodyResponse<ReportState> stateResponse = this.getReportState(professionalReportId);
            System.out.println(stateResponse);
            reportState = stateResponse.get(0);
            Integer isGenerated = reportState.getIsGenerated();
            if (isGenerated == 3) {
                ListBodyResponse<ReportFileUrl> fileUrlResponse = this.getReportFileUrl(professionalReportId);
                ReportFileUrl reportFileUrl = fileUrlResponse.get(0);
                try {
                    return new URI(reportFileUrl.getReportFilePath());
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            sleep.accept(i);
        }
        throw new SdkException(Objects.toString(reportState), new Object[0]);
    }

    default public List<SearchReport> getReportList(RealTimeRequestType requestType) {
        return ((ListBodyResponse)this.getReport(new Request(requestType)).checkFailure()).list();
    }

    default public List<SearchReport> getAdgroupDayReport(LocalDate date, DeviceEnum deviceEnum) {
        RealTimeRequestType type = new RealTimeRequestType();
        type.addPerformance("cost", "cpc", "click", "impression", "ctr", "cpm", "conversion");
        type.setStartDate(date);
        type.setEndDate(date);
        type.setReportType(ReportTypeEnum.ADGROUP);
        type.setLevelOfDetails(LevelOfDetailEnum.ADGROUP);
        type.setUnitOfTime(UnitOfTimeEnum.DAY);
        type.setDevice(deviceEnum);
        ArrayList<SearchReport> list = new ArrayList<SearchReport>();
        int i = 1;
        while (true) {
            type.setPageIndex(i);
            type.setNumber(10000);
            ListBodyResponse<SearchReport> response = this.getReport(new Request(type));
            response.checkFailure();
            List data = ((ListBody)response.getBody()).getData();
            if (Objects.isNull(data) || data.isEmpty()) break;
            list.addAll(data);
            ++i;
        }
        return list;
    }

    default public List<SearchReport> getKeywordDayReport(LocalDate date, DeviceEnum deviceEnum) {
        RealTimeRequestType type = new RealTimeRequestType();
        type.addPerformance("cost", "cpc", "click", "impression", "ctr", "cpm", "conversion", "position", "ocpcConversionsDetail3");
        type.setStartDate(date);
        type.setEndDate(date);
        type.setReportType(ReportTypeEnum.KEYWORD);
        type.setLevelOfDetails(LevelOfDetailEnum.KEYWORD);
        type.setUnitOfTime(UnitOfTimeEnum.DAY);
        type.setStatRange(StatRangeEnum.ACCOUNT);
        type.setDevice(deviceEnum);
        ArrayList<SearchReport> list = new ArrayList<SearchReport>();
        int i = 1;
        while (true) {
            type.setPageIndex(i);
            type.setNumber(10000);
            ListBodyResponse<SearchReport> response = this.getReport(new Request(type));
            response.checkFailure();
            List data = ((ListBody)response.getBody()).getData();
            if (Objects.isNull(data) || data.isEmpty()) break;
            list.addAll(data);
            ++i;
        }
        return list;
    }

    default public List<KeywordQueryReport> getQueryKeywordDayReport(LocalDate date, DeviceEnum deviceEnum) {
        RealTimeRequestType type = new RealTimeRequestType();
        type.addPerformance("cost", "cpc", "click", "impression", "ctr", "trans", "bridgetrans", "querystatus");
        type.setStartDate(date);
        type.setEndDate(date);
        type.setReportType(ReportTypeEnum.QUERY_WORD);
        type.setLevelOfDetails(LevelOfDetailEnum.QUERY_KEYWORD_AND_CREATIVE);
        type.setUnitOfTime(UnitOfTimeEnum.DAY);
        type.setDevice(deviceEnum);
        type.setStatRange(StatRangeEnum.ACCOUNT);
        ArrayList<KeywordQueryReport> list = new ArrayList<KeywordQueryReport>();
        int i = 1;
        while (true) {
            type.setPageIndex(i);
            type.setNumber(1000);
            ListBodyResponse<KeywordQueryReport> response = this.getRealTimeQueryData(new QueryRequest(type));
            response.checkFailure();
            List data = ((ListBody)response.getBody()).getData();
            if (Objects.isNull(data) || data.isEmpty()) break;
            list.addAll(data);
            ++i;
        }
        return list;
    }

    default public List<KeywordQueryReport> getRealTimeQueryData(RealTimeRequestType requestType) {
        return ((ListBodyResponse)this.getRealTimeQueryData(new QueryRequest(requestType)).checkFailure()).list();
    }

    public static class ReportData {
        private List<Object> rows = null;
        private Object summary;
        private Integer rowCount;
        private Integer totalRowCount;
        private Map columnMetas;

        public List<Object> getRows() {
            return this.rows;
        }

        public Object getSummary() {
            return this.summary;
        }

        public Integer getRowCount() {
            return this.rowCount;
        }

        public Integer getTotalRowCount() {
            return this.totalRowCount;
        }

        public Map getColumnMetas() {
            return this.columnMetas;
        }

        public void setRows(List<Object> rows) {
            this.rows = rows;
        }

        public void setSummary(Object summary) {
            this.summary = summary;
        }

        public void setRowCount(Integer rowCount) {
            this.rowCount = rowCount;
        }

        public void setTotalRowCount(Integer totalRowCount) {
            this.totalRowCount = totalRowCount;
        }

        public void setColumnMetas(Map columnMetas) {
            this.columnMetas = columnMetas;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportData)) {
                return false;
            }
            ReportData other = (ReportData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$rowCount = this.getRowCount();
            Integer other$rowCount = other.getRowCount();
            if (this$rowCount == null ? other$rowCount != null : !((Object)this$rowCount).equals(other$rowCount)) {
                return false;
            }
            Integer this$totalRowCount = this.getTotalRowCount();
            Integer other$totalRowCount = other.getTotalRowCount();
            if (this$totalRowCount == null ? other$totalRowCount != null : !((Object)this$totalRowCount).equals(other$totalRowCount)) {
                return false;
            }
            List<Object> this$rows = this.getRows();
            List<Object> other$rows = other.getRows();
            if (this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows)) {
                return false;
            }
            Object this$summary = this.getSummary();
            Object other$summary = other.getSummary();
            if (this$summary == null ? other$summary != null : !this$summary.equals(other$summary)) {
                return false;
            }
            Map this$columnMetas = this.getColumnMetas();
            Map other$columnMetas = other.getColumnMetas();
            return !(this$columnMetas == null ? other$columnMetas != null : !((Object)this$columnMetas).equals(other$columnMetas));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ReportData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $rowCount = this.getRowCount();
            result = result * 59 + ($rowCount == null ? 43 : ((Object)$rowCount).hashCode());
            Integer $totalRowCount = this.getTotalRowCount();
            result = result * 59 + ($totalRowCount == null ? 43 : ((Object)$totalRowCount).hashCode());
            List<Object> $rows = this.getRows();
            result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
            Object $summary = this.getSummary();
            result = result * 59 + ($summary == null ? 43 : $summary.hashCode());
            Map $columnMetas = this.getColumnMetas();
            result = result * 59 + ($columnMetas == null ? 43 : ((Object)$columnMetas).hashCode());
            return result;
        }

        public String toString() {
            return "ReportService.ReportData(rows=" + this.getRows() + ", summary=" + this.getSummary() + ", rowCount=" + this.getRowCount() + ", totalRowCount=" + this.getTotalRowCount() + ", columnMetas=" + this.getColumnMetas() + ")";
        }
    }

    public static class ReportDataRequest {
        private Integer reportType;
        private List<Long> userIds = null;
        private String startDate;
        private String endDate;
        private String timeUnit;
        private List<String> columns = null;
        private List<Sort> sorts = null;
        private List<Filter> filters = null;
        private Integer startRow;
        private Integer rowCount;
        private Boolean needSum;
        private String splitColumn;
        private String compareStartDate;
        private Boolean needCache;
        private Boolean addZeroRows;
        private Boolean withColumnMeta;
        private String bloodlineTag;
        private String token;
        private String userName;
        private Long userId;

        public Integer getReportType() {
            return this.reportType;
        }

        public List<Long> getUserIds() {
            return this.userIds;
        }

        public String getStartDate() {
            return this.startDate;
        }

        public String getEndDate() {
            return this.endDate;
        }

        public String getTimeUnit() {
            return this.timeUnit;
        }

        public List<String> getColumns() {
            return this.columns;
        }

        public List<Sort> getSorts() {
            return this.sorts;
        }

        public List<Filter> getFilters() {
            return this.filters;
        }

        public Integer getStartRow() {
            return this.startRow;
        }

        public Integer getRowCount() {
            return this.rowCount;
        }

        public Boolean getNeedSum() {
            return this.needSum;
        }

        public String getSplitColumn() {
            return this.splitColumn;
        }

        public String getCompareStartDate() {
            return this.compareStartDate;
        }

        public Boolean getNeedCache() {
            return this.needCache;
        }

        public Boolean getAddZeroRows() {
            return this.addZeroRows;
        }

        public Boolean getWithColumnMeta() {
            return this.withColumnMeta;
        }

        public String getBloodlineTag() {
            return this.bloodlineTag;
        }

        public String getToken() {
            return this.token;
        }

        public String getUserName() {
            return this.userName;
        }

        public Long getUserId() {
            return this.userId;
        }

        public void setReportType(Integer reportType) {
            this.reportType = reportType;
        }

        public void setUserIds(List<Long> userIds) {
            this.userIds = userIds;
        }

        public void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        public void setEndDate(String endDate) {
            this.endDate = endDate;
        }

        public void setTimeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
        }

        public void setColumns(List<String> columns) {
            this.columns = columns;
        }

        public void setSorts(List<Sort> sorts) {
            this.sorts = sorts;
        }

        public void setFilters(List<Filter> filters) {
            this.filters = filters;
        }

        public void setStartRow(Integer startRow) {
            this.startRow = startRow;
        }

        public void setRowCount(Integer rowCount) {
            this.rowCount = rowCount;
        }

        public void setNeedSum(Boolean needSum) {
            this.needSum = needSum;
        }

        public void setSplitColumn(String splitColumn) {
            this.splitColumn = splitColumn;
        }

        public void setCompareStartDate(String compareStartDate) {
            this.compareStartDate = compareStartDate;
        }

        public void setNeedCache(Boolean needCache) {
            this.needCache = needCache;
        }

        public void setAddZeroRows(Boolean addZeroRows) {
            this.addZeroRows = addZeroRows;
        }

        public void setWithColumnMeta(Boolean withColumnMeta) {
            this.withColumnMeta = withColumnMeta;
        }

        public void setBloodlineTag(String bloodlineTag) {
            this.bloodlineTag = bloodlineTag;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public void setUserId(Long userId) {
            this.userId = userId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportDataRequest)) {
                return false;
            }
            ReportDataRequest other = (ReportDataRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$reportType = this.getReportType();
            Integer other$reportType = other.getReportType();
            if (this$reportType == null ? other$reportType != null : !((Object)this$reportType).equals(other$reportType)) {
                return false;
            }
            Integer this$startRow = this.getStartRow();
            Integer other$startRow = other.getStartRow();
            if (this$startRow == null ? other$startRow != null : !((Object)this$startRow).equals(other$startRow)) {
                return false;
            }
            Integer this$rowCount = this.getRowCount();
            Integer other$rowCount = other.getRowCount();
            if (this$rowCount == null ? other$rowCount != null : !((Object)this$rowCount).equals(other$rowCount)) {
                return false;
            }
            Boolean this$needSum = this.getNeedSum();
            Boolean other$needSum = other.getNeedSum();
            if (this$needSum == null ? other$needSum != null : !((Object)this$needSum).equals(other$needSum)) {
                return false;
            }
            Boolean this$needCache = this.getNeedCache();
            Boolean other$needCache = other.getNeedCache();
            if (this$needCache == null ? other$needCache != null : !((Object)this$needCache).equals(other$needCache)) {
                return false;
            }
            Boolean this$addZeroRows = this.getAddZeroRows();
            Boolean other$addZeroRows = other.getAddZeroRows();
            if (this$addZeroRows == null ? other$addZeroRows != null : !((Object)this$addZeroRows).equals(other$addZeroRows)) {
                return false;
            }
            Boolean this$withColumnMeta = this.getWithColumnMeta();
            Boolean other$withColumnMeta = other.getWithColumnMeta();
            if (this$withColumnMeta == null ? other$withColumnMeta != null : !((Object)this$withColumnMeta).equals(other$withColumnMeta)) {
                return false;
            }
            Long this$userId = this.getUserId();
            Long other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
                return false;
            }
            List<Long> this$userIds = this.getUserIds();
            List<Long> other$userIds = other.getUserIds();
            if (this$userIds == null ? other$userIds != null : !((Object)this$userIds).equals(other$userIds)) {
                return false;
            }
            String this$startDate = this.getStartDate();
            String other$startDate = other.getStartDate();
            if (this$startDate == null ? other$startDate != null : !this$startDate.equals(other$startDate)) {
                return false;
            }
            String this$endDate = this.getEndDate();
            String other$endDate = other.getEndDate();
            if (this$endDate == null ? other$endDate != null : !this$endDate.equals(other$endDate)) {
                return false;
            }
            String this$timeUnit = this.getTimeUnit();
            String other$timeUnit = other.getTimeUnit();
            if (this$timeUnit == null ? other$timeUnit != null : !this$timeUnit.equals(other$timeUnit)) {
                return false;
            }
            List<String> this$columns = this.getColumns();
            List<String> other$columns = other.getColumns();
            if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
                return false;
            }
            List<Sort> this$sorts = this.getSorts();
            List<Sort> other$sorts = other.getSorts();
            if (this$sorts == null ? other$sorts != null : !((Object)this$sorts).equals(other$sorts)) {
                return false;
            }
            List<Filter> this$filters = this.getFilters();
            List<Filter> other$filters = other.getFilters();
            if (this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters)) {
                return false;
            }
            String this$splitColumn = this.getSplitColumn();
            String other$splitColumn = other.getSplitColumn();
            if (this$splitColumn == null ? other$splitColumn != null : !this$splitColumn.equals(other$splitColumn)) {
                return false;
            }
            String this$compareStartDate = this.getCompareStartDate();
            String other$compareStartDate = other.getCompareStartDate();
            if (this$compareStartDate == null ? other$compareStartDate != null : !this$compareStartDate.equals(other$compareStartDate)) {
                return false;
            }
            String this$bloodlineTag = this.getBloodlineTag();
            String other$bloodlineTag = other.getBloodlineTag();
            if (this$bloodlineTag == null ? other$bloodlineTag != null : !this$bloodlineTag.equals(other$bloodlineTag)) {
                return false;
            }
            String this$token = this.getToken();
            String other$token = other.getToken();
            if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
                return false;
            }
            String this$userName = this.getUserName();
            String other$userName = other.getUserName();
            return !(this$userName == null ? other$userName != null : !this$userName.equals(other$userName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ReportDataRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $reportType = this.getReportType();
            result = result * 59 + ($reportType == null ? 43 : ((Object)$reportType).hashCode());
            Integer $startRow = this.getStartRow();
            result = result * 59 + ($startRow == null ? 43 : ((Object)$startRow).hashCode());
            Integer $rowCount = this.getRowCount();
            result = result * 59 + ($rowCount == null ? 43 : ((Object)$rowCount).hashCode());
            Boolean $needSum = this.getNeedSum();
            result = result * 59 + ($needSum == null ? 43 : ((Object)$needSum).hashCode());
            Boolean $needCache = this.getNeedCache();
            result = result * 59 + ($needCache == null ? 43 : ((Object)$needCache).hashCode());
            Boolean $addZeroRows = this.getAddZeroRows();
            result = result * 59 + ($addZeroRows == null ? 43 : ((Object)$addZeroRows).hashCode());
            Boolean $withColumnMeta = this.getWithColumnMeta();
            result = result * 59 + ($withColumnMeta == null ? 43 : ((Object)$withColumnMeta).hashCode());
            Long $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
            List<Long> $userIds = this.getUserIds();
            result = result * 59 + ($userIds == null ? 43 : ((Object)$userIds).hashCode());
            String $startDate = this.getStartDate();
            result = result * 59 + ($startDate == null ? 43 : $startDate.hashCode());
            String $endDate = this.getEndDate();
            result = result * 59 + ($endDate == null ? 43 : $endDate.hashCode());
            String $timeUnit = this.getTimeUnit();
            result = result * 59 + ($timeUnit == null ? 43 : $timeUnit.hashCode());
            List<String> $columns = this.getColumns();
            result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
            List<Sort> $sorts = this.getSorts();
            result = result * 59 + ($sorts == null ? 43 : ((Object)$sorts).hashCode());
            List<Filter> $filters = this.getFilters();
            result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
            String $splitColumn = this.getSplitColumn();
            result = result * 59 + ($splitColumn == null ? 43 : $splitColumn.hashCode());
            String $compareStartDate = this.getCompareStartDate();
            result = result * 59 + ($compareStartDate == null ? 43 : $compareStartDate.hashCode());
            String $bloodlineTag = this.getBloodlineTag();
            result = result * 59 + ($bloodlineTag == null ? 43 : $bloodlineTag.hashCode());
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            String $userName = this.getUserName();
            result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
            return result;
        }

        public String toString() {
            return "ReportService.ReportDataRequest(reportType=" + this.getReportType() + ", userIds=" + this.getUserIds() + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ", timeUnit=" + this.getTimeUnit() + ", columns=" + this.getColumns() + ", sorts=" + this.getSorts() + ", filters=" + this.getFilters() + ", startRow=" + this.getStartRow() + ", rowCount=" + this.getRowCount() + ", needSum=" + this.getNeedSum() + ", splitColumn=" + this.getSplitColumn() + ", compareStartDate=" + this.getCompareStartDate() + ", needCache=" + this.getNeedCache() + ", addZeroRows=" + this.getAddZeroRows() + ", withColumnMeta=" + this.getWithColumnMeta() + ", bloodlineTag=" + this.getBloodlineTag() + ", token=" + this.getToken() + ", userName=" + this.getUserName() + ", userId=" + this.getUserId() + ")";
        }

        public static class Filter {
            private String column;
            private String operator;
            private List<String> values = null;
            private String compareField;

            public String getColumn() {
                return this.column;
            }

            public String getOperator() {
                return this.operator;
            }

            public List<String> getValues() {
                return this.values;
            }

            public String getCompareField() {
                return this.compareField;
            }

            public void setColumn(String column) {
                this.column = column;
            }

            public void setOperator(String operator) {
                this.operator = operator;
            }

            public void setValues(List<String> values) {
                this.values = values;
            }

            public void setCompareField(String compareField) {
                this.compareField = compareField;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Filter)) {
                    return false;
                }
                Filter other = (Filter)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$column = this.getColumn();
                String other$column = other.getColumn();
                if (this$column == null ? other$column != null : !this$column.equals(other$column)) {
                    return false;
                }
                String this$operator = this.getOperator();
                String other$operator = other.getOperator();
                if (this$operator == null ? other$operator != null : !this$operator.equals(other$operator)) {
                    return false;
                }
                List<String> this$values = this.getValues();
                List<String> other$values = other.getValues();
                if (this$values == null ? other$values != null : !((Object)this$values).equals(other$values)) {
                    return false;
                }
                String this$compareField = this.getCompareField();
                String other$compareField = other.getCompareField();
                return !(this$compareField == null ? other$compareField != null : !this$compareField.equals(other$compareField));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Filter;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $column = this.getColumn();
                result = result * 59 + ($column == null ? 43 : $column.hashCode());
                String $operator = this.getOperator();
                result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
                List<String> $values = this.getValues();
                result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
                String $compareField = this.getCompareField();
                result = result * 59 + ($compareField == null ? 43 : $compareField.hashCode());
                return result;
            }

            public String toString() {
                return "ReportService.ReportDataRequest.Filter(column=" + this.getColumn() + ", operator=" + this.getOperator() + ", values=" + this.getValues() + ", compareField=" + this.getCompareField() + ")";
            }
        }

        public static class Sort {
            private String column;
            private String sortRule;
            private String compareField;

            public String getColumn() {
                return this.column;
            }

            public String getSortRule() {
                return this.sortRule;
            }

            public String getCompareField() {
                return this.compareField;
            }

            public void setColumn(String column) {
                this.column = column;
            }

            public void setSortRule(String sortRule) {
                this.sortRule = sortRule;
            }

            public void setCompareField(String compareField) {
                this.compareField = compareField;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Sort)) {
                    return false;
                }
                Sort other = (Sort)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$column = this.getColumn();
                String other$column = other.getColumn();
                if (this$column == null ? other$column != null : !this$column.equals(other$column)) {
                    return false;
                }
                String this$sortRule = this.getSortRule();
                String other$sortRule = other.getSortRule();
                if (this$sortRule == null ? other$sortRule != null : !this$sortRule.equals(other$sortRule)) {
                    return false;
                }
                String this$compareField = this.getCompareField();
                String other$compareField = other.getCompareField();
                return !(this$compareField == null ? other$compareField != null : !this$compareField.equals(other$compareField));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Sort;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $column = this.getColumn();
                result = result * 59 + ($column == null ? 43 : $column.hashCode());
                String $sortRule = this.getSortRule();
                result = result * 59 + ($sortRule == null ? 43 : $sortRule.hashCode());
                String $compareField = this.getCompareField();
                result = result * 59 + ($compareField == null ? 43 : $compareField.hashCode());
                return result;
            }

            public String toString() {
                return "ReportService.ReportDataRequest.Sort(column=" + this.getColumn() + ", sortRule=" + this.getSortRule() + ", compareField=" + this.getCompareField() + ")";
            }
        }
    }

    public static class ProfessionalReportRequest {
        private final RealTimeRequestType reportRequestType;

        public ProfessionalReportRequest(RealTimeRequestType reportRequestType) {
            this.reportRequestType = reportRequestType;
        }

        public RealTimeRequestType getReportRequestType() {
            return this.reportRequestType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProfessionalReportRequest)) {
                return false;
            }
            ProfessionalReportRequest other = (ProfessionalReportRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            RealTimeRequestType this$reportRequestType = this.getReportRequestType();
            RealTimeRequestType other$reportRequestType = other.getReportRequestType();
            return !(this$reportRequestType == null ? other$reportRequestType != null : !((Object)this$reportRequestType).equals(other$reportRequestType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProfessionalReportRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RealTimeRequestType $reportRequestType = this.getReportRequestType();
            result = result * 59 + ($reportRequestType == null ? 43 : ((Object)$reportRequestType).hashCode());
            return result;
        }

        public String toString() {
            return "ReportService.ProfessionalReportRequest(reportRequestType=" + this.getReportRequestType() + ")";
        }
    }

    public static class QueryRequest {
        public static final String[] PERFORMANCE = new String[]{"cost", "cpc", "click", "impression", "ctr", "trans", "bridgetrans", "querystatus"};
        private final RealTimeRequestType realTimeQueryRequestType;

        public QueryRequest(RealTimeRequestType realTimeQueryRequestType) {
            this.realTimeQueryRequestType = realTimeQueryRequestType;
        }

        public RealTimeRequestType getRealTimeQueryRequestType() {
            return this.realTimeQueryRequestType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueryRequest)) {
                return false;
            }
            QueryRequest other = (QueryRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            RealTimeRequestType this$realTimeQueryRequestType = this.getRealTimeQueryRequestType();
            RealTimeRequestType other$realTimeQueryRequestType = other.getRealTimeQueryRequestType();
            return !(this$realTimeQueryRequestType == null ? other$realTimeQueryRequestType != null : !((Object)this$realTimeQueryRequestType).equals(other$realTimeQueryRequestType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof QueryRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RealTimeRequestType $realTimeQueryRequestType = this.getRealTimeQueryRequestType();
            result = result * 59 + ($realTimeQueryRequestType == null ? 43 : ((Object)$realTimeQueryRequestType).hashCode());
            return result;
        }

        public String toString() {
            return "ReportService.QueryRequest(realTimeQueryRequestType=" + this.getRealTimeQueryRequestType() + ")";
        }
    }

    public static class Request {
        public static final String[] PERFORMANCE = new String[]{"cost", "cpc", "click", "impression", "ctr", "cpm", "conversion"};
        private final RealTimeRequestType realTimeRequestType;

        public Request(RealTimeRequestType realTimeRequestType) {
            this.realTimeRequestType = realTimeRequestType;
        }

        public RealTimeRequestType getRealTimeRequestType() {
            return this.realTimeRequestType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request other = (Request)o;
            if (!other.canEqual(this)) {
                return false;
            }
            RealTimeRequestType this$realTimeRequestType = this.getRealTimeRequestType();
            RealTimeRequestType other$realTimeRequestType = other.getRealTimeRequestType();
            return !(this$realTimeRequestType == null ? other$realTimeRequestType != null : !((Object)this$realTimeRequestType).equals(other$realTimeRequestType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Request;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RealTimeRequestType $realTimeRequestType = this.getRealTimeRequestType();
            result = result * 59 + ($realTimeRequestType == null ? 43 : ((Object)$realTimeRequestType).hashCode());
            return result;
        }

        public String toString() {
            return "ReportService.Request(realTimeRequestType=" + this.getRealTimeRequestType() + ")";
        }
    }
}

