/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.baidu.sdk.core.coder;

import cn.insmart.fx.common.lang.util.IOUtils;
import cn.pcauto.sem.baidu.sdk.configuration.SdkProperties;
import cn.pcauto.sem.baidu.sdk.core.coder.BigDecimalDeserializer;
import cn.pcauto.sem.baidu.sdk.core.dto.HttpResponseHeader;
import cn.pcauto.sem.baidu.sdk.core.exception.SdkException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import feign.FeignException;
import feign.RequestTemplate;
import feign.Response;
import feign.codec.Decoder;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Coder
implements Decoder,
Encoder {
    private static final Logger log = LoggerFactory.getLogger(Coder.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final ThreadLocal<String> THREAD_LOCAL = ThreadLocal.withInitial(() -> String.format("%s | %s", UUID.randomUUID().toString(), LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))));
    private final SdkProperties properties;

    public static String format(Object object) throws JsonProcessingException {
        if (object instanceof String) {
            return mapper.readTree((String)object).toPrettyString();
        }
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object decode(Response response, Type type) throws IOException, FeignException {
        try {
            Map headers;
            Object o;
            String text = IOUtils.toString((InputStream)response.body().asInputStream(), (Charset)StandardCharsets.UTF_8);
            if (this.properties.isLogger()) {
                log.info("\n\u54cd\u5e94\u6570\u636e[{}]:\n{}", (Object)THREAD_LOCAL.get(), (Object)Coder.format(text));
            }
            if ((o = mapper.readValue(text, mapper.constructType(type))) instanceof cn.pcauto.sem.baidu.sdk.core.dto.Response && Objects.nonNull(headers = response.headers())) {
                HttpResponseHeader header = new HttpResponseHeader();
                header.setXB3Spanid(this.getFirst((Collection)headers.get("x-b3-spanid")));
                header.setXB3Traceid(this.getFirst((Collection)headers.get("x-b3-traceid")));
                ((cn.pcauto.sem.baidu.sdk.core.dto.Response)cn.pcauto.sem.baidu.sdk.core.dto.Response.class.cast(o)).setHttpResponseHeader(header);
            }
            Object object = o;
            return object;
        }
        finally {
            THREAD_LOCAL.remove();
        }
    }

    public void encode(Object object, Type bodyType, RequestTemplate template) throws EncodeException {
        try {
            template.body(mapper.writeValueAsString(object));
            if (this.properties.isLogger()) {
                log.info("\n\u8bf7\u6c42\u6570\u636e[{}]:\n{}", (Object)THREAD_LOCAL.get(), (Object)Coder.format(object));
            }
        }
        catch (JsonProcessingException e) {
            throw new SdkException("\u5e8f\u5217\u5316\u8bf7\u6c42\u4f53\u51fa\u9519", (Throwable)e, new Object[0]);
        }
    }

    public static ObjectMapper getMapper() {
        return mapper;
    }

    private String getFirst(Collection<String> collection) {
        return CollectionUtils.isEmpty(collection) ? null : (String)IterableUtils.get(collection, (int)0);
    }

    public Coder(SdkProperties properties) {
        this.properties = properties;
    }

    public SdkProperties getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Coder)) {
            return false;
        }
        Coder other = (Coder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SdkProperties this$properties = this.getProperties();
        SdkProperties other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Coder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SdkProperties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "Coder(properties=" + this.getProperties() + ")";
    }

    static {
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        javaTimeModule.addDeserializer(BigDecimal.class, (JsonDeserializer)new BigDecimalDeserializer());
        mapper.registerModule((Module)javaTimeModule);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

