/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.baidu.sdk.core.support;

import cn.pcauto.sem.baidu.sdk.configuration.SdkProperties;
import cn.pcauto.sem.baidu.sdk.core.ApiService;
import cn.pcauto.sem.baidu.sdk.core.ApiServiceFactory;
import cn.pcauto.sem.baidu.sdk.core.support.DefaultApiServiceFactory;
import cn.pcauto.sem.baidu.sdk.core.support.MccProperties;
import cn.pcauto.sem.baidu.sdk.core.support.TokenProvider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheApiServiceFactory
extends DefaultApiServiceFactory
implements ApiServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(CacheApiServiceFactory.class);
    private final Map<Key, ApiService> cache = new ConcurrentHashMap<Key, ApiService>();

    public CacheApiServiceFactory(MccProperties mccProperties, SdkProperties sdkProperties, TokenProvider tokenProvider) {
        super(mccProperties, sdkProperties, tokenProvider);
    }

    @Override
    public <T extends ApiService> T create(Class<T> service, String target) {
        return (T)((ApiService)service.cast(this.cache.computeIfAbsent(this.key(service, target), key -> super.create(key.service, key.target))));
    }

    private Key key(Class<?> service, String targetAccount) {
        return new Key(service, this.getMccConfiguration().getUsername(), targetAccount);
    }

    private static class Key {
        private final Class service;
        private final String account;
        private final String target;

        public Key(Class service, String account, String target) {
            this.service = service;
            this.account = account;
            this.target = target;
        }

        public Class getService() {
            return this.service;
        }

        public String getAccount() {
            return this.account;
        }

        public String getTarget() {
            return this.target;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class this$service = this.getService();
            Class other$service = other.getService();
            if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
                return false;
            }
            String this$account = this.getAccount();
            String other$account = other.getAccount();
            if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
                return false;
            }
            String this$target = this.getTarget();
            String other$target = other.getTarget();
            return !(this$target == null ? other$target != null : !this$target.equals(other$target));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Key;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class $service = this.getService();
            result = result * 59 + ($service == null ? 43 : $service.hashCode());
            String $account = this.getAccount();
            result = result * 59 + ($account == null ? 43 : $account.hashCode());
            String $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : $target.hashCode());
            return result;
        }

        public String toString() {
            return "CacheApiServiceFactory.Key(service=" + this.getService() + ", account=" + this.getAccount() + ", target=" + this.getTarget() + ")";
        }
    }
}

