/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.baidu.sdk.core.support;

import cn.pcauto.sem.baidu.sdk.configuration.SdkProperties;
import cn.pcauto.sem.baidu.sdk.core.ApiService;
import cn.pcauto.sem.baidu.sdk.core.ApiServiceFactory;
import cn.pcauto.sem.baidu.sdk.core.coder.Coder;
import cn.pcauto.sem.baidu.sdk.core.dto.AuthRequest;
import cn.pcauto.sem.baidu.sdk.core.dto.NewAuthHeader;
import cn.pcauto.sem.baidu.sdk.core.exception.AccessTooFrequentException;
import cn.pcauto.sem.baidu.sdk.core.exception.FailureException;
import cn.pcauto.sem.baidu.sdk.core.exception.RetryAgainException;
import cn.pcauto.sem.baidu.sdk.core.support.MccProperties;
import cn.pcauto.sem.baidu.sdk.core.support.QpsLimiter;
import cn.pcauto.sem.baidu.sdk.core.support.SdkChecker;
import cn.pcauto.sem.baidu.sdk.core.support.TokenProvider;
import feign.Client;
import feign.Feign;
import feign.FeignException;
import feign.InvocationHandlerFactory;
import feign.Logger;
import feign.codec.Decoder;
import feign.codec.Encoder;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApiServiceFactory
implements ApiServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultApiServiceFactory.class);
    private final String getEnvironment = "getEnvironment";
    private final MccProperties mccProperties;
    private final SdkProperties sdkProperties;
    private final TokenProvider tokenProvider;

    public DefaultApiServiceFactory(MccProperties mccProperties, SdkProperties sdkProperties, TokenProvider tokenProvider) {
        this.mccProperties = mccProperties;
        this.sdkProperties = Objects.requireNonNull(sdkProperties);
        this.tokenProvider = tokenProvider;
        log.info("DefaultApiServiceFactory sdkProperties: {}, tokenProviderClass: {}. ", (Object)this.sdkProperties, (Object)this.tokenProvider.getClass().getSimpleName());
    }

    @Override
    public <T extends ApiService> T create(Class<T> service, String targetAccount) {
        Feign.Builder builder = Feign.builder().invocationHandlerFactory(this.invocationHandlerFactory(targetAccount)).decoder((Decoder)new Coder(this.sdkProperties)).encoder((Encoder)new Coder(this.sdkProperties)).logLevel(this.sdkProperties.isLogger() ? Logger.Level.FULL : Logger.Level.NONE).logger(new feign.Logger(){

            protected void log(String configKey, String format, Object ... args) {
                log.info("feign: {}, {}", (Object)format, (Object)args);
            }
        }).client(this.client(this.sdkProperties.getProxy()));
        return (T)((ApiService)builder.target(service, this.sdkProperties.getApi()));
    }

    private InvocationHandlerFactory invocationHandlerFactory(String targetAccount) {
        return (target, dispatch) -> (proxy, method, args) -> {
            if (method.isDefault()) {
                Class<?> declaringClass = method.getDeclaringClass();
                MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(declaringClass, MethodHandles.lookup());
                MethodHandle special = lookup.findSpecial(declaringClass, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), declaringClass);
                return special.bindTo(proxy).invokeWithArguments(args);
            }
            if (method.getDeclaringClass().equals(Object.class)) {
                return method.invoke((Object)this, args);
            }
            Objects.requireNonNull(args, "\u63a5\u53e3\u65b9\u6cd5\u5fc5\u987b\u6709\u53c2\u6570\u5b9a\u4e49");
            NewAuthHeader authHeader = new NewAuthHeader();
            authHeader.setUserName(targetAccount);
            authHeader.setAccessToken(this.tokenProvider.getToken(targetAccount));
            AuthRequest<Object[]> request = new AuthRequest<Object[]>(authHeader, (Object[])(args.length == 1 ? args[0] : args));
            int i = 1;
            while (true) {
                try {
                    QpsLimiter.limit(method);
                    Object returnValue = ((InvocationHandlerFactory.MethodHandler)dispatch.get(method)).invoke(new Object[]{request});
                    SdkChecker.checkAuth(method, returnValue, request);
                    return returnValue;
                }
                catch (AccessTooFrequentException | RetryAgainException | FeignException.GatewayTimeout | FeignException.InternalServerError e) {
                    log.warn("SDK \u91cd\u8bd5 {}({}): {}", new Object[]{i, this.sdkProperties.getTryTimes(), e.getMessage()});
                    if (i > this.sdkProperties.getTryTimes()) {
                        if (e instanceof FailureException) {
                            FailureException fe = (FailureException)e;
                            throw new FailureException(method, fe.getFailure(), fe.getRequest(), fe.getResponse(), String.format("sdk request error: %s", fe), new Object[0]);
                        }
                        throw e;
                    }
                    TimeUnit.SECONDS.sleep(Math.min(i, 10));
                    ++i;
                    continue;
                }
                break;
            }
        };
    }

    @Override
    public MccProperties getMccConfiguration() {
        return this.mccProperties;
    }

    private Client client(SdkProperties.ProxyProperties proxyConfiguration) {
        if (Objects.nonNull(proxyConfiguration)) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyConfiguration.getHost(), proxyConfiguration.getPort()));
            return new Client.Proxied(null, null, proxy);
        }
        return new Client.Default(null, null);
    }
}

