/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.baidu.sdk.core.dto;

import cn.pcauto.sem.baidu.sdk.core.exception.SdkException;
import java.beans.Transient;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;

public class ListBody<T> {
    private List<T> data = new ArrayList<T>();

    @Transient
    public Optional<List<T>> data() {
        return Optional.of(this.data);
    }

    public static <E> Supplier<ListBody<E>> empty() {
        return () -> new ListBody();
    }

    public <R> List<R> convert(Function<T, R> mapper) {
        return this.map(mapper).collect(Collectors.toList());
    }

    public <R> Stream<R> map(Function<T, R> mapper) {
        if (this.data == null) {
            return null;
        }
        return this.data.stream().map(mapper);
    }

    public Optional<T> get(int index) {
        if (CollectionUtils.isEmpty(this.data)) {
            throw new SdkException("data array is empty. ", new Object[0]);
        }
        return Optional.ofNullable(this.data.get(index));
    }

    public List<T> getData() {
        return this.data;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListBody)) {
            return false;
        }
        ListBody other = (ListBody)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<T> this$data = this.getData();
        List<T> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListBody;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<T> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "ListBody(data=" + this.getData() + ")";
    }

    public ListBody() {
    }

    public ListBody(List<T> data) {
        this.data = data;
    }
}

