/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.baidu.sdk.service.search;

import cn.pcauto.sem.baidu.sdk.core.ApiService;
import cn.pcauto.sem.baidu.sdk.core.ApiServiceEnvironment;
import cn.pcauto.sem.baidu.sdk.core.annotation.QpsLimit;
import cn.pcauto.sem.baidu.sdk.core.dto.ListBody;
import cn.pcauto.sem.baidu.sdk.core.dto.Response;
import cn.pcauto.sem.baidu.sdk.service.search.dto.KeywordType;
import cn.pcauto.sem.baidu.sdk.service.search.dto.TargetPackageType;
import com.fasterxml.jackson.annotation.JsonProperty;
import feign.RequestLine;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

public interface OcpcService
extends ApiService<KeywordType> {
    @QpsLimit
    @RequestLine(value="POST /json/sms/service/OcpcService/getTargetPackageList")
    public Response<ListBody<TargetPackageType>> getTargetPackageList(GetRequest var1);

    @QpsLimit
    @RequestLine(value="POST /json/sms/service/OcpcService/updateTargetPackage")
    public Response<ListBody<TargetPackageType>> updateTargetPackage(UpdateRequest var1);

    default public Response<ListBody<TargetPackageType>> updateTargetPackage(List<TargetPackageType> targetPackageTypeList) {
        return this.updateTargetPackage(new UpdateRequest(targetPackageTypeList));
    }

    default public List<TargetPackageType> getTargetPackageList(Long userId, String ... fields) {
        GetRequest request = new GetRequest();
        request.setIds(Collections.singletonList(userId));
        request.setLevel(1);
        if (ArrayUtils.isNotEmpty((Object[])fields)) {
            request.setTargetPackageTypeFields(Arrays.asList(fields));
        }
        Response<ListBody<TargetPackageType>> response = this.getTargetPackageList(request);
        response.checkFailure();
        return Optional.ofNullable(response.getBody().getData()).orElseGet(Collections::emptyList);
    }

    default public TargetPackageType findEquestTarget(Long userId, String ... fields) {
        List<TargetPackageType> targetPackageList = this.getTargetPackageList(userId, fields);
        if (CollectionUtils.isEmpty(targetPackageList)) {
            return null;
        }
        ApiServiceEnvironment environment = this.getEnvironment();
        for (TargetPackageType targetPackageType : targetPackageList) {
            if (!Objects.equals(environment.getTarget(), targetPackageType.getTargetPackageName())) continue;
            return targetPackageType;
        }
        return null;
    }

    public static class UpdateRequest {
        @JsonProperty(value="targetPackageType")
        List<TargetPackageType> targetPackageType;

        public List<TargetPackageType> getTargetPackageType() {
            return this.targetPackageType;
        }

        @JsonProperty(value="targetPackageType")
        public void setTargetPackageType(List<TargetPackageType> targetPackageType) {
            this.targetPackageType = targetPackageType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateRequest)) {
                return false;
            }
            UpdateRequest other = (UpdateRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<TargetPackageType> this$targetPackageType = this.getTargetPackageType();
            List<TargetPackageType> other$targetPackageType = other.getTargetPackageType();
            return !(this$targetPackageType == null ? other$targetPackageType != null : !((Object)this$targetPackageType).equals(other$targetPackageType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UpdateRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<TargetPackageType> $targetPackageType = this.getTargetPackageType();
            result = result * 59 + ($targetPackageType == null ? 43 : ((Object)$targetPackageType).hashCode());
            return result;
        }

        public String toString() {
            return "OcpcService.UpdateRequest(targetPackageType=" + this.getTargetPackageType() + ")";
        }

        public UpdateRequest() {
        }

        public UpdateRequest(List<TargetPackageType> targetPackageType) {
            this.targetPackageType = targetPackageType;
        }
    }

    public static class GetRequest {
        public static final String[] FIELDS = new String[]{"targetPackageId", "targetPackageName", "ocpcBid", "ocpcBidType", "ecpcMaxBidRatio", "ecpcMinBidRatio", "scope", "dataFlowData", "equipmentType", "ocpcStage", "assistTransTypes", "ocpcDeepCpa", "astat", "wiseAuditTime", "packageStatus", "deepTypeStat"};
        @JsonProperty(value="targetPackageTypeFields")
        List<String> targetPackageTypeFields = Arrays.asList(FIELDS);
        @JsonProperty(value="ids")
        List<Long> ids;
        @JsonProperty(value="level")
        Integer level;

        public List<String> getTargetPackageTypeFields() {
            return this.targetPackageTypeFields;
        }

        public List<Long> getIds() {
            return this.ids;
        }

        public Integer getLevel() {
            return this.level;
        }

        @JsonProperty(value="targetPackageTypeFields")
        public void setTargetPackageTypeFields(List<String> targetPackageTypeFields) {
            this.targetPackageTypeFields = targetPackageTypeFields;
        }

        @JsonProperty(value="ids")
        public void setIds(List<Long> ids) {
            this.ids = ids;
        }

        @JsonProperty(value="level")
        public void setLevel(Integer level) {
            this.level = level;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetRequest)) {
                return false;
            }
            GetRequest other = (GetRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$level = this.getLevel();
            Integer other$level = other.getLevel();
            if (this$level == null ? other$level != null : !((Object)this$level).equals(other$level)) {
                return false;
            }
            List<String> this$targetPackageTypeFields = this.getTargetPackageTypeFields();
            List<String> other$targetPackageTypeFields = other.getTargetPackageTypeFields();
            if (this$targetPackageTypeFields == null ? other$targetPackageTypeFields != null : !((Object)this$targetPackageTypeFields).equals(other$targetPackageTypeFields)) {
                return false;
            }
            List<Long> this$ids = this.getIds();
            List<Long> other$ids = other.getIds();
            return !(this$ids == null ? other$ids != null : !((Object)this$ids).equals(other$ids));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GetRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $level = this.getLevel();
            result = result * 59 + ($level == null ? 43 : ((Object)$level).hashCode());
            List<String> $targetPackageTypeFields = this.getTargetPackageTypeFields();
            result = result * 59 + ($targetPackageTypeFields == null ? 43 : ((Object)$targetPackageTypeFields).hashCode());
            List<Long> $ids = this.getIds();
            result = result * 59 + ($ids == null ? 43 : ((Object)$ids).hashCode());
            return result;
        }

        public String toString() {
            return "OcpcService.GetRequest(targetPackageTypeFields=" + this.getTargetPackageTypeFields() + ", ids=" + this.getIds() + ", level=" + this.getLevel() + ")";
        }

        public GetRequest() {
        }

        public GetRequest(List<String> targetPackageTypeFields, List<Long> ids, Integer level) {
            this.targetPackageTypeFields = targetPackageTypeFields;
            this.ids = ids;
            this.level = level;
        }
    }
}

