/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.baidu.sdk.core.support;

import cn.pcauto.sem.baidu.sdk.core.dto.Failure;
import cn.pcauto.sem.baidu.sdk.core.dto.ListBody;
import cn.pcauto.sem.baidu.sdk.core.dto.Response;
import cn.pcauto.sem.baidu.sdk.core.exception.FailureIndexNotFindException;
import cn.pcauto.sem.baidu.sdk.core.support.ResultBinder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResponseBinder {
    private static Pattern PATTERN = Pattern.compile("_params\\.\\w+\\[(\\d+)\\]");

    public static <T, E> List<ResultBinder<E, T>> bind(Response<ListBody<T>> response, E ... list) throws FailureIndexNotFindException {
        return ResponseBinder.bind(response, Arrays.asList(list));
    }

    public static <T, E> List<ResultBinder<E, T>> bind(Response<ListBody<T>> response, List<E> list) throws FailureIndexNotFindException {
        Map<Integer, List<Failure>> errorMap = ResponseBinder.mapError(response.getHeader().getFailures());
        ArrayList<ResultBinder<ResultBinder<E, List<Failure>>, T>> responseMapperList = new ArrayList<ResultBinder<ResultBinder<E, List<Failure>>, T>>();
        List<T> data = response.getBody().getData();
        if (Objects.nonNull(data) && list.size() < data.size()) {
            throw new RuntimeException(String.format("\u8fd4\u56de\u6570\u636e\u6bd4\u8bf7\u6c42\u6570\u636e\u591a\uff0c\u8bf7\u6c42\u6761\u6570\uff1a%s, \u8fd4\u56de\u6761\u6570: %s", list.size(), data.size()));
        }
        int dataIndex = 0;
        for (int index = 0; index < list.size(); ++index) {
            E req = Objects.requireNonNull(list.get(index), String.format("\u8bf7\u6c42\u6570\u636e\u4e0b\u6807 %s \u7684\u6570\u636e\u9879\u4e3a\u7a7a", index));
            if (errorMap.containsKey(index)) {
                responseMapperList.add(new ResultBinder<E, List<Failure>>(req, Objects.requireNonNull(errorMap.get(index))));
                continue;
            }
            responseMapperList.add(new ResultBinder<E, T>(req, Objects.requireNonNull(data.get(dataIndex))));
        }
        return responseMapperList;
    }

    public static Map<Integer, List<Failure>> mapError(List<Failure> failures) throws FailureIndexNotFindException {
        if (Objects.isNull(failures) || failures.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Integer, List<Failure>> indexMap = new HashMap<Integer, List<Failure>>(failures.size());
        for (Failure failure : failures) {
            Optional<Integer> positionIndex = ResponseBinder.resolvePositionIndex(failure.getPosition());
            Integer index = positionIndex.orElseThrow(() -> new FailureIndexNotFindException(failure));
            indexMap.computeIfAbsent(index, integer -> new ArrayList()).add(failure);
        }
        return indexMap;
    }

    public static Optional<Integer> resolvePositionIndex(String position) {
        Matcher matcher;
        if (Objects.nonNull(position) && (matcher = PATTERN.matcher(position)).find()) {
            return Optional.of(Integer.valueOf(matcher.group(1)));
        }
        return Optional.empty();
    }

    public static void main(String[] args) {
        System.out.println(ResponseBinder.resolvePositionIndex("_params.keywordTypes[0].keywordId"));
        System.out.println(ResponseBinder.resolvePositionIndex("_params.keywordTypes[10009].keywordId"));
        System.out.println(ResponseBinder.resolvePositionIndex("_params.keywordTypes[null].keywordId"));
        System.out.println(ResponseBinder.resolvePositionIndex("_params.keywordTypes[].keywordId"));
    }
}

