/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.baidu.sdk.core.utils;

import java.beans.Transient;
import java.math.BigDecimal;
import java.util.List;

public class Kpi {
    public static final String COST = "cost";
    public static final String CPC = "cpc";
    public static final String CLICK = "click";
    public static final String IMPRESSION = "impression";
    public static final String CTR = "ctr";
    public static final String CPM = "cpm";
    public static final String POSITION = "position";
    public static final String CONVERSION = "conversion";
    public static final String OCPCCONVERSIONSDETAIL3 = "ocpcConversionsDetail3";
    private final List<String> names;
    private final List<BigDecimal> values;

    public Kpi(List<String> names, List<BigDecimal> values) {
        if (names.size() != values.size()) {
            throw new RuntimeException(String.format("\u5927\u5c0f\u4e0d\u4e00\u81f4 %s\uff0c  %s", names.size(), values));
        }
        this.names = names;
        this.values = values;
    }

    public static Kpi of(List<String> name, List<BigDecimal> values) {
        return new Kpi(name, values);
    }

    public BigDecimal getValue(String name) {
        return this.values.get(this.names.indexOf(name));
    }

    public int intValue(String name) {
        return this.getValue(name).intValue();
    }

    public double doubleValue(String name) {
        return this.getValue(name).doubleValue();
    }

    public List<BigDecimal> getValues() {
        return this.values;
    }

    @Transient
    public BigDecimal getCost() {
        return this.getValue(COST);
    }

    @Transient
    public BigDecimal getCpc() {
        return this.getBigDecimal(CPC);
    }

    @Transient
    public Integer getClick() {
        return this.getInteger(CLICK);
    }

    @Transient
    public Integer getImpression() {
        return this.getInteger(IMPRESSION);
    }

    @Transient
    public BigDecimal getCtr() {
        return this.getBigDecimal(CTR);
    }

    @Transient
    public BigDecimal getCpm() {
        return this.getBigDecimal(CPM);
    }

    @Transient
    public BigDecimal getPosition() {
        return this.getBigDecimal(POSITION);
    }

    @Transient
    public Long getOcpcConversionsDetail3() {
        return Long.parseLong(this.getInteger(OCPCCONVERSIONSDETAIL3).toString());
    }

    @Transient
    public BigDecimal getConversion() {
        return this.getBigDecimal(CONVERSION);
    }

    @Transient
    public BigDecimal getBigDecimal(String name) {
        if (!this.names.contains(name)) {
            throw new IllegalArgumentException(String.format("\u6ca1\u6709\u8bf7\u6c42\u53c2\u6570 \u201d%s\u201c", name));
        }
        return this.getValue(name);
    }

    @Transient
    public Integer getInteger(String name) {
        return this.getBigDecimal(name).intValue();
    }
}

