/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.baidu.sdk.configuration;

import cn.pcauto.sem.baidu.sdk.configuration.SdkProperties;
import cn.pcauto.sem.baidu.sdk.core.AccountManager;
import cn.pcauto.sem.baidu.sdk.core.support.DataSourceTokenProvider;
import cn.pcauto.sem.baidu.sdk.core.support.DefaultAccountManager;
import cn.pcauto.sem.baidu.sdk.core.support.TokenProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SdkProperties.class})
public class BaiduSdkAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(BaiduSdkAutoConfiguration.class);

    @Bean(value={"baiduTokenProvider"})
    TokenProvider baiduTokenProvider(SdkProperties properties) {
        log.info("baidu SdkProperties {}", (Object)properties);
        SdkProperties.DataSourceProperties dataSourceProperties = properties.getDataSource();
        return new DataSourceTokenProvider(dataSourceProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    AccountManager accountManager(SdkProperties properties, @Qualifier(value="baiduTokenProvider") TokenProvider baiduTokenProvider) {
        return new DefaultAccountManager(properties, baiduTokenProvider);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaiduSdkAutoConfiguration)) {
            return false;
        }
        BaiduSdkAutoConfiguration other = (BaiduSdkAutoConfiguration)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaiduSdkAutoConfiguration;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "BaiduSdkAutoConfiguration()";
    }
}

