/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.baidu.sdk.core.exception;

import cn.pcauto.sem.baidu.sdk.core.dto.AuthRequest;
import cn.pcauto.sem.baidu.sdk.core.dto.Failure;
import cn.pcauto.sem.baidu.sdk.core.dto.Response;
import cn.pcauto.sem.baidu.sdk.core.exception.SdkException;
import java.lang.reflect.Method;

public class AuthFailureException
extends SdkException {
    private final Method method;
    private final AuthRequest request;
    private final Response response;
    private final Failure failure;
    private final String traceid;

    public AuthFailureException(Method method, Failure failure, AuthRequest request, Response response) {
        this(method, failure, request, response, response.getHeader().getTraceid(), String.format("%s.%s, error: %s", method.getDeclaringClass().getSimpleName(), method.getName(), failure.getMessage()), new Object[0]);
    }

    public AuthFailureException(Method method, Failure failure, AuthRequest request, Response response, String traceid, String message, Object ... args) {
        super(message, args);
        this.method = method;
        this.request = request;
        this.response = response;
        this.failure = failure;
        this.traceid = traceid;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("method: ").append(this.method);
        sb.append("failure: ").append(this.failure);
        sb.append("request: ").append(this.request);
        sb.append("traceid: ").append(this.traceid);
        sb.append("response: ").append(this.response);
        return sb.toString();
    }

    public Method getMethod() {
        return this.method;
    }

    public AuthRequest getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public Failure getFailure() {
        return this.failure;
    }

    public String getTraceid() {
        return this.traceid;
    }
}

