/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.baidu.sdk.core.support;

import cn.pcauto.sem.baidu.sdk.core.annotation.QpsLimit;
import com.google.common.util.concurrent.RateLimiter;
import feign.RequestLine;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QpsLimiter {
    private static final Logger LOGGER = LoggerFactory.getLogger(QpsLimiter.class);
    private static final Map<Method, RateLimiter> LIMITER_MAP = new ConcurrentHashMap<Method, RateLimiter>();

    public static RateLimiter get(Method method) {
        if (Objects.isNull(method.getAnnotation(RequestLine.class))) {
            return null;
        }
        QpsLimit qpsLimit = method.getAnnotation(QpsLimit.class);
        if (Objects.isNull(qpsLimit)) {
            return null;
        }
        return LIMITER_MAP.computeIfAbsent(method, m -> RateLimiter.create((double)qpsLimit.value()));
    }

    public static void limit(Method method) {
        double acquire;
        RateLimiter limiter = QpsLimiter.get(method);
        if (Objects.nonNull(limiter) && (acquire = limiter.acquire()) > 0.0) {
            LOGGER.warn("\u63a5\u53e3\u9700\u8981\u8fdb\u884c\u9650\u6d41 {}, sleep time = {}", (Object)method, (Object)acquire);
        }
    }
}

