/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.baidu.sdk.core.support;

import cn.pcauto.sem.baidu.sdk.configuration.SdkProperties;
import cn.pcauto.sem.baidu.sdk.core.AccountManager;
import cn.pcauto.sem.baidu.sdk.core.ApiServiceFactory;
import cn.pcauto.sem.baidu.sdk.core.exception.SdkConfigurationException;
import cn.pcauto.sem.baidu.sdk.core.support.DefaultApiServiceFactory;
import cn.pcauto.sem.baidu.sdk.core.support.TokenProvider;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAccountManager
implements AccountManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultAccountManager.class);
    private final Map<String, ApiServiceFactory> factoryMap = new ConcurrentHashMap<String, ApiServiceFactory>();
    private final SdkProperties sdkProperties;
    private final TokenProvider tokenProvider;

    public DefaultAccountManager(SdkProperties sdkProperties, TokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
        this.sdkProperties = sdkProperties;
    }

    @Override
    public ApiServiceFactory getServiceFactory(String username) {
        return this.factoryMap.computeIfAbsent(username, key -> {
            List<SdkProperties.DefaultMccProperties> mccProperties = this.sdkProperties.getMccProperties();
            Optional<SdkProperties.DefaultMccProperties> first = mccProperties.stream().filter(e -> Objects.equals(e.getUsername(), username)).findFirst();
            SdkProperties.DefaultMccProperties properties = first.orElseThrow(() -> new SdkConfigurationException("\u627e\u4e0d\u5230\u7ba1\u5bb6\u8d26\u53f7: %s", username));
            return new DefaultApiServiceFactory(properties, this.sdkProperties, this.tokenProvider);
        });
    }

    @Override
    public List<String> getUserNameList() {
        return this.sdkProperties.getMccProperties().stream().map(SdkProperties.DefaultMccProperties::getUsername).collect(Collectors.toList());
    }
}

