/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.baidu.sdk.core.support;

import cn.pcauto.sem.baidu.sdk.core.dto.Failure;
import java.util.List;
import java.util.Objects;

public class ResultBinder<T, R> {
    private final T local;
    private final R remote;
    private final List<Failure> failures;

    public ResultBinder(T local, List<Failure> failures) {
        this(local, null, failures);
    }

    public ResultBinder(T local, R remote) {
        this(local, remote, null);
    }

    public ResultBinder(T local, R remote, List<Failure> failures) {
        this.local = local;
        this.remote = remote;
        this.failures = failures;
    }

    public boolean isSuccess() {
        return !this.isFail();
    }

    public boolean isFail() {
        return Objects.nonNull(this.failures) && this.failures.size() > 0;
    }

    public T getLocal() {
        return this.local;
    }

    public R getRemote() {
        return this.remote;
    }

    public List<Failure> getFailures() {
        return this.failures;
    }
}

