/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.baidu.sdk.service.search;

import cn.pcauto.sem.baidu.sdk.core.ApiService;
import cn.pcauto.sem.baidu.sdk.core.annotation.QpsLimit;
import cn.pcauto.sem.baidu.sdk.core.dto.ListBody;
import cn.pcauto.sem.baidu.sdk.core.dto.ListBodyResponse;
import cn.pcauto.sem.baidu.sdk.core.dto.Response;
import cn.pcauto.sem.baidu.sdk.service.search.dto.AdgroupType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import feign.RequestLine;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;

public interface AdgroupApiService
extends ApiService<AdgroupType> {
    @QpsLimit(value=25)
    @RequestLine(value="POST /json/sms/service/AdgroupService/getAdgroup")
    public ListBodyResponse<AdgroupType> get(GetRequest var1);

    @QpsLimit(value=10)
    @RequestLine(value="POST /json/sms/service/AdgroupService/addAdgroup")
    public ListBodyResponse<AdgroupType> add(Request var1);

    @QpsLimit(value=10)
    @RequestLine(value="POST /json/sms/service/AdgroupService/updateAdgroup")
    public ListBodyResponse<AdgroupType> update(Request var1);

    @QpsLimit(value=25)
    @RequestLine(value="POST /json/sms/service/AdgroupService/deleteAdgroup")
    public ListBodyResponse<AdgroupType> delete(adgroupIds var1);

    default public List<AdgroupType> get(IdType type, List<Long> ids, String ... fields) {
        return this.get(new GetRequest(ids, type, fields)).list();
    }

    default public AdgroupType getById(Long id, String ... fields) {
        List<AdgroupType> list = this.getByIds(Collections.singletonList(id), fields);
        return CollectionUtils.isEmpty(list) ? null : list.get(0);
    }

    default public List<AdgroupType> getByIds(List<Long> id, String ... fields) {
        return this.get(IdType.ADGROUP, id, fields);
    }

    default public List<AdgroupType> getByCampaignId(Long campaignId, String ... fields) {
        return this.get(IdType.CAMPAIGN, Collections.singletonList(campaignId), fields);
    }

    default public Map<String, Long> getNameMapByCampaignId(Long campaignId) {
        return this.toMap(this.getByCampaignId(campaignId, "adgroupId", "adgroupName"), AdgroupType::getAdgroupName, AdgroupType::getAdgroupId);
    }

    @Override
    default public Response<ListBody<AdgroupType>> add(List<AdgroupType> list) {
        return this.add(new Request(list));
    }

    @Override
    default public Response<ListBody<AdgroupType>> update(List<AdgroupType> list) {
        return this.update(new Request(list));
    }

    public static class adgroupIds {
        @JsonProperty(value="adgroupIds")
        private final List<Long> ids;

        public adgroupIds(List<Long> ids) {
            this.ids = ids;
        }

        public List<Long> getIds() {
            return this.ids;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof adgroupIds)) {
                return false;
            }
            adgroupIds other = (adgroupIds)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Long> this$ids = this.getIds();
            List<Long> other$ids = other.getIds();
            return !(this$ids == null ? other$ids != null : !((Object)this$ids).equals(other$ids));
        }

        protected boolean canEqual(Object other) {
            return other instanceof adgroupIds;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Long> $ids = this.getIds();
            result = result * 59 + ($ids == null ? 43 : ((Object)$ids).hashCode());
            return result;
        }

        public String toString() {
            return "AdgroupApiService.adgroupIds(ids=" + this.getIds() + ")";
        }
    }

    public static enum IdType {
        CAMPAIGN(3),
        ADGROUP(5);

        @JsonValue
        private final int value;

        private IdType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class GetRequest {
        public static final List<String> FIELDS = Arrays.asList("adgroupId", "campaignId", "adgroupName", "pause", "maxPrice", "negativeWords", "exactNegativeWords", "status", "accuPriceFactor", "wordPriceFactor", "widePriceFactor", "matchPriceStatus", "priceRatio", "pcPriceRatio", "segmentRecommendStatus");
        @JsonProperty(value="adgroupFields")
        private List<String> fields;
        private List<Long> ids;
        private IdType idType;

        public GetRequest(List<Long> ids, IdType idType, String ... fields) {
            this(ids, idType, Arrays.asList(fields));
        }

        public GetRequest(List<Long> ids, IdType idType, List<String> fields) {
            this.fields = CollectionUtils.isEmpty(fields) ? FIELDS : fields;
            this.ids = ids;
            this.idType = idType;
        }

        public List<String> getFields() {
            return this.fields;
        }

        public List<Long> getIds() {
            return this.ids;
        }

        public IdType getIdType() {
            return this.idType;
        }

        @JsonProperty(value="adgroupFields")
        public void setFields(List<String> fields) {
            this.fields = fields;
        }

        public void setIds(List<Long> ids) {
            this.ids = ids;
        }

        public void setIdType(IdType idType) {
            this.idType = idType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetRequest)) {
                return false;
            }
            GetRequest other = (GetRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$fields = this.getFields();
            List<String> other$fields = other.getFields();
            if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
                return false;
            }
            List<Long> this$ids = this.getIds();
            List<Long> other$ids = other.getIds();
            if (this$ids == null ? other$ids != null : !((Object)this$ids).equals(other$ids)) {
                return false;
            }
            IdType this$idType = this.getIdType();
            IdType other$idType = other.getIdType();
            return !(this$idType == null ? other$idType != null : !((Object)((Object)this$idType)).equals((Object)other$idType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GetRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $fields = this.getFields();
            result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
            List<Long> $ids = this.getIds();
            result = result * 59 + ($ids == null ? 43 : ((Object)$ids).hashCode());
            IdType $idType = this.getIdType();
            result = result * 59 + ($idType == null ? 43 : ((Object)((Object)$idType)).hashCode());
            return result;
        }

        public String toString() {
            return "AdgroupApiService.GetRequest(fields=" + this.getFields() + ", ids=" + this.getIds() + ", idType=" + this.getIdType() + ")";
        }

        public GetRequest() {
        }
    }

    public static class Request {
        @JsonProperty(value="adgroupTypes")
        private final List<AdgroupType> list;

        public Request(List<AdgroupType> list) {
            this.list = list;
        }

        public List<AdgroupType> getList() {
            return this.list;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request other = (Request)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<AdgroupType> this$list = this.getList();
            List<AdgroupType> other$list = other.getList();
            return !(this$list == null ? other$list != null : !((Object)this$list).equals(other$list));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Request;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<AdgroupType> $list = this.getList();
            result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
            return result;
        }

        public String toString() {
            return "AdgroupApiService.Request(list=" + this.getList() + ")";
        }
    }
}

