/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.baidu.sdk.service.search;

import cn.pcauto.sem.baidu.sdk.core.ApiService;
import cn.pcauto.sem.baidu.sdk.core.annotation.QpsLimit;
import cn.pcauto.sem.baidu.sdk.core.dto.ListBody;
import cn.pcauto.sem.baidu.sdk.core.dto.ListBodyResponse;
import cn.pcauto.sem.baidu.sdk.core.dto.Response;
import cn.pcauto.sem.baidu.sdk.service.search.dto.CreativeType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import feign.Headers;
import feign.RequestLine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;

public interface CreativeApiService
extends ApiService<CreativeType> {
    @QpsLimit
    @RequestLine(value="POST /json/sms/service/CreativeService/getCreative")
    public ListBodyResponse<CreativeType> get(GetRequest var1);

    @QpsLimit(value=50)
    @Headers(value={"Content-Type: application/json"})
    @RequestLine(value="POST /json/sms/service/CreativeService/addCreative")
    public Response<ListBody<CreativeType>> add(Request var1);

    @QpsLimit
    @Headers(value={"Content-Type: application/json"})
    @RequestLine(value="POST /json/sms/service/CreativeService/updateCreative")
    public ListBodyResponse<CreativeType> update(Request var1);

    @QpsLimit
    @RequestLine(value="POST /json/sms/service/CreativeService/deleteCreative")
    public ListBodyResponse<CreativeType> deleteCreative(DeleteRequest var1);

    default public ListBodyResponse<CreativeType> deleteCreative(Collection<Long> creativeIds) {
        return this.deleteCreative(new DeleteRequest(new ArrayList<Long>(creativeIds)));
    }

    default public ListBodyResponse<CreativeType> deleteCreative(Long ... creativeIds) {
        return this.deleteCreative(new DeleteRequest(Arrays.asList(creativeIds)));
    }

    default public List<CreativeType> get(IdType type, List<Long> ids, String ... fields) {
        return this.get(new GetRequest(ids, type, fields)).list();
    }

    default public CreativeType getById(Long id, String ... fields) {
        List<CreativeType> list = this.getByIds(Collections.singletonList(id), fields);
        return CollectionUtils.isEmpty(list) ? null : list.get(0);
    }

    default public List<CreativeType> getByIds(List<Long> ids, String ... fields) {
        return this.get(IdType.CREATIVE, ids, fields);
    }

    default public List<CreativeType> getByAdgroupId(Long adgroupId, String ... fields) {
        return this.get(IdType.ADGROUP, Collections.singletonList(adgroupId), fields);
    }

    default public Map<String, Long> getNameMapByAdgroupId(Long adgroupId) {
        return this.toMap(this.getByAdgroupId(adgroupId, "creativeId", "title"), CreativeType::getTitle, CreativeType::getCreativeId);
    }

    @Override
    default public Response<ListBody<CreativeType>> add(List<CreativeType> list) {
        return this.add(new Request(list));
    }

    @Override
    default public Response<ListBody<CreativeType>> update(List<CreativeType> list) {
        return this.update(new Request(list));
    }

    public static enum IdType {
        ADGROUP(5),
        CREATIVE(7);

        @JsonValue
        private final int value;

        private IdType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class GetRequest {
        public static final List<String> FIELDS = Arrays.asList("creativeId", "adgroupId", "title", "pause", "status", "description1", "description2", "pcDestinationUrl", "pcDisplayUrl", "mobileDestinationUrl", "mobileDisplayUrl", "devicePreference", "tabs", "deeplink", "miniProgramUrl", "offlineReasons");
        private List<String> creativeFields = FIELDS;
        private List<Long> ids = new ArrayList<Long>();
        private IdType idType;

        GetRequest(List<Long> ids, IdType type, String ... fields) {
            this.ids = ids;
            this.idType = type;
            this.creativeFields = fields.length == 0 ? FIELDS : Arrays.asList(fields);
        }

        public void setCreativeFields(List<String> creativeFields) {
            this.creativeFields = creativeFields;
        }

        public void setIds(List<Long> ids) {
            this.ids = ids;
        }

        public void setIdType(IdType idType) {
            this.idType = idType;
        }

        public List<String> getCreativeFields() {
            return this.creativeFields;
        }

        public List<Long> getIds() {
            return this.ids;
        }

        public IdType getIdType() {
            return this.idType;
        }

        public GetRequest() {
        }

        public GetRequest(List<String> creativeFields, List<Long> ids, IdType idType) {
            this.creativeFields = creativeFields;
            this.ids = ids;
            this.idType = idType;
        }
    }

    public static class DeleteRequest {
        @JsonProperty(value="creativeIds")
        final List<Long> creativeIds;

        public DeleteRequest(List<Long> creativeIds) {
            this.creativeIds = creativeIds;
        }

        public List<Long> getCreativeIds() {
            return this.creativeIds;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeleteRequest)) {
                return false;
            }
            DeleteRequest other = (DeleteRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Long> this$creativeIds = this.getCreativeIds();
            List<Long> other$creativeIds = other.getCreativeIds();
            return !(this$creativeIds == null ? other$creativeIds != null : !((Object)this$creativeIds).equals(other$creativeIds));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DeleteRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Long> $creativeIds = this.getCreativeIds();
            result = result * 59 + ($creativeIds == null ? 43 : ((Object)$creativeIds).hashCode());
            return result;
        }

        public String toString() {
            return "CreativeApiService.DeleteRequest(creativeIds=" + this.getCreativeIds() + ")";
        }
    }

    public static class Request {
        final List<CreativeType> creativeTypes;

        public Request(List<CreativeType> creativeTypes) {
            this.creativeTypes = creativeTypes;
        }

        public List<CreativeType> getCreativeTypes() {
            return this.creativeTypes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request other = (Request)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<CreativeType> this$creativeTypes = this.getCreativeTypes();
            List<CreativeType> other$creativeTypes = other.getCreativeTypes();
            return !(this$creativeTypes == null ? other$creativeTypes != null : !((Object)this$creativeTypes).equals(other$creativeTypes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Request;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<CreativeType> $creativeTypes = this.getCreativeTypes();
            result = result * 59 + ($creativeTypes == null ? 43 : ((Object)$creativeTypes).hashCode());
            return result;
        }

        public String toString() {
            return "CreativeApiService.Request(creativeTypes=" + this.getCreativeTypes() + ")";
        }
    }
}

