/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.report.support;

import cn.pcauto.sem.report.IReport;
import cn.pcauto.sem.report.support.ShareStrategy;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ShareStrategys implements ShareStrategy
{
    FIXED{

        @Override
        public <E extends IReport> void sharing(List<E> list, IReport unassigned) {
            IReport.apply((IReport)list.get(0), ((IReport)list.get(0)).plus(unassigned));
        }
    }
    ,
    CYCLE{

        @Override
        public <E extends IReport> void sharing(List<E> list, IReport unassigned) {
            Iterator<IReport> iterator = unassigned.subtractStepIterator();
            int index = 0;
            while (iterator.hasNext()) {
                IReport.apply((IReport)list.get(index), ((IReport)list.get(index)).plus(iterator.next()));
                index %= list.size();
            }
        }
    }
    ,
    RANDOM{

        @Override
        public <E extends IReport> void sharing(List<E> list, IReport unassigned) {
            Iterator<IReport> iterator = unassigned.subtractStepIterator();
            boolean count = false;
            int size = list.size();
            IReport e = (IReport)list.get(RandomUtils.nextInt((int)0, (int)size));
            while (iterator.hasNext()) {
                IReport.apply(e, e.plus(iterator.next()));
                e = (IReport)list.get(RandomUtils.nextInt((int)0, (int)size));
            }
        }
    };

    private static final Logger LOGGER;

    static {
        LOGGER = LoggerFactory.getLogger(ShareStrategys.class);
    }
}

