/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.report;

import cn.pcauto.sem.report.support.BigDecimalUtils;
import cn.pcauto.sem.report.support.DefaultReport;
import cn.pcauto.sem.report.support.ShareStrategy;
import cn.pcauto.sem.report.support.ShareStrategys;
import java.beans.Transient;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public interface IReport
extends Cloneable {
    public static final Logger LOGGER = Logger.getLogger(IReport.class.getName());
    public static final BigDecimal ONE = BigDecimal.ONE;
    public static final BigDecimal ZERO = BigDecimal.ZERO;

    public BigDecimal getClick();

    public void setClick(BigDecimal var1);

    public BigDecimal getImpression();

    public void setImpression(BigDecimal var1);

    public BigDecimal getCost();

    public void setCost(BigDecimal var1);

    public IReport clone() throws CloneNotSupportedException;

    @Transient
    default public BigDecimal getCtr() {
        return this.getClick().divide(this.getImpression(), RoundingMode.HALF_UP);
    }

    @Transient
    default public BigDecimal getCpc() {
        return this.getCost().divide(this.getClick(), RoundingMode.HALF_UP);
    }

    @Transient
    default public boolean hasValue() {
        boolean hasValue = this.getClick().longValue() > 0L || this.getImpression().longValue() > 0L || this.getCost().doubleValue() > 0.0;
        return hasValue;
    }

    @Transient
    default public <E extends IReport> E plus(E report) {
        try {
            return (E)IReport.apply(this.clone(), IReport.sum(this, report));
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Transient
    default public void add(IReport report) {
        IReport.apply(this, IReport.sum(this, report));
    }

    default public Iterator<IReport> subtractStepIterator() {
        return new SubtractIterator(this);
    }

    @Transient
    default public <E extends IReport> E subtract(E subtrahend) {
        try {
            return (E)IReport.apply(this.clone(), IReport.subtract(this, subtrahend));
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Transient
    default public <E extends IReport> E divide(E divisor) {
        try {
            return (E)IReport.apply(this.clone(), IReport.divide(this, divisor));
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    default public <E extends IReport> void sharing(List<E> list) {
        this.sharing(list, ShareStrategys.RANDOM);
    }

    default public <E extends IReport> void sharing(List<E> list, ShareStrategy strategy) {
        strategy.sharing(list, this);
    }

    public static IReport subtract(IReport minute, IReport subtrahend) {
        DefaultReport subtract = new DefaultReport();
        subtract.setClick(minute.getClick().subtract(subtrahend.getClick()));
        subtract.setCost(minute.getCost().subtract(subtrahend.getCost()));
        subtract.setImpression(minute.getImpression().subtract(subtrahend.getImpression()));
        return subtract;
    }

    public static <E extends IReport> E sum(E a, E b) {
        DefaultReport sum = new DefaultReport();
        sum.setCost(a.getCost().add(b.getCost()));
        sum.setClick(a.getClick().add(b.getClick()));
        sum.setImpression(a.getImpression().add(b.getImpression()));
        return (E)sum;
    }

    public static <E extends IReport> E divide(E dividend, E divisor) {
        DefaultReport sum = new DefaultReport();
        if (!ZERO.equals(divisor.getCost())) {
            sum.setCost(dividend.getCost().divide(divisor.getCost()));
        }
        if (!ZERO.equals(divisor.getImpression())) {
            sum.setImpression(dividend.getImpression().divide(divisor.getImpression()));
        }
        if (!ZERO.equals(divisor.getClick())) {
            sum.setClick(dividend.getClick().divide(divisor.getClick()));
        }
        return (E)sum;
    }

    public static <E extends IReport> E apply(E target, IReport source) {
        target.setClick(source.getClick());
        target.setImpression(source.getImpression());
        target.setCost(source.getCost());
        return target;
    }

    public static class SubtractIterator
    implements Iterator<IReport> {
        private static final BigDecimal STEP = new BigDecimal("0.00001");
        private static final int SCALE = STEP.scale() - 1;
        private IReport total;
        private IReport subtrahend;

        public SubtractIterator(IReport total) {
            this(total, new DefaultReport(ONE, ONE, STEP.setScale(total.getCost().scale(), RoundingMode.UP)));
        }

        public SubtractIterator(IReport total, IReport subtrahend) {
            if (total.getCost().scale() > SCALE) {
                throw new RuntimeException(String.format("Cost \u524d\u652f\u6301\u6700\u5927\u7cbe\u5ea6%s\u4f4d\u6570\uff0c\u8bf7\u8bbe\u7f6e\u7cbe\u5ea6\uff0c cost = %s", SCALE, total));
            }
            if (total.getImpression().scale() > 0) {
                throw new RuntimeException(String.format("Impression \u53ea\u652f\u6301\u6574\u6570\uff0c\u8bf7\u8bbe\u7f6e\u7cbe\u5ea6\u4e3a0, value = %s", total));
            }
            if (total.getClick().scale() > 0) {
                throw new RuntimeException(String.format("Click \u53ea\u652f\u6301\u6574\u6570\uff0c\u8bf7\u8bbe\u7f6e\u7cbe\u5ea6\u4e3a0, value = %s", total));
            }
            IReport divide = total.divide(subtrahend);
            int max = BigDecimalUtils.max(divide.getCost(), divide.getImpression(), divide.getClick()).intValue();
            if (max > 10000) {
                LOGGER.warning("total\u592a\u5927\uff0c\u6216\u8005step\u592a\u5c0f\u90fd\u4f1a\u5bfc\u81f4\u5faa\u73af\u6b21\u6570\u8fc7\u591a\uff0c\u9700\u8981\u5faa\u73af\u6b21\u6570: " + max + ", total = " + total + ", step = " + subtrahend);
            }
            this.total = total;
            this.subtrahend = subtrahend;
        }

        @Override
        public boolean hasNext() {
            return this.total.getClick().compareTo(this.subtrahend.getClick()) >= 0 || this.total.getImpression().compareTo(this.subtrahend.getImpression()) >= 0 || this.total.getCost().compareTo(this.subtrahend.getCost()) >= 0;
        }

        @Override
        public IReport next() {
            try {
                IReport assign = this.subtrahend.clone();
                this.total = this.total.subtract(this.subtrahend);
                if (this.total.getCost().doubleValue() < 0.0) {
                    assign.setCost(ZERO);
                    this.total.setCost(ZERO);
                }
                if (this.total.getImpression().longValue() < 0L) {
                    assign.setImpression(ZERO);
                    this.total.setImpression(ZERO);
                }
                if (this.total.getClick().longValue() < 0L) {
                    assign.setClick(ZERO);
                    this.total.setClick(ZERO);
                }
                return assign;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public IReport getTotal() {
            return this.total;
        }

        public IReport getSubtrahend() {
            return this.subtrahend;
        }
    }
}

