/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.common.enums;

import cn.insmart.fx.common.lang.annotation.EnumDefinition;
import cn.insmart.fx.common.lang.annotation.EnumKey;
import cn.insmart.fx.common.lang.annotation.EnumLabel;
import cn.insmart.fx.common.lang.util.StringUtils;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnumDefinition
public enum DomainEnum {
    MAI_CHE_BANG("\u4e70\u8f66\u5e2e", "qicheshenghuo.com.cn", "qicheshenghuo", cn.insmart.mp.media.common.enums.DomainEnum.QI_CHE_SHENG_HUO),
    CHA_CHE_JIA("\u67e5\u8f66\u4ef7", "www.chachejia.cn", "chachejia", cn.insmart.mp.media.common.enums.DomainEnum.CHA_CHE_JIA),
    DI_SHANG_PAO("\u8f66\u95ea\u95ea", "dishangpao.com.cn", "dishangpao", cn.insmart.mp.media.common.enums.DomainEnum.DI_SHANG_PAO),
    LE_GOU_CHE("\u4e50\u56e2\u8f66", "in-smart.cn", "in-smart", cn.insmart.mp.media.common.enums.DomainEnum.IN_SMART),
    KAUI_TUAN_CHE("\u5feb\u56e2\u8f66", "gmaiche.com", "gmaiche", cn.insmart.mp.media.common.enums.DomainEnum.G_MAI_CHE),
    CHE_JIA_BAO("\u8f66\u95ea\u8d2d", "chejiabao.cn", "chejiabao", cn.insmart.mp.media.common.enums.DomainEnum.CHE_JIA_BAO),
    KOU_DAI_SHANG_CHENG("\u53e3\u888b\u8f66\u5546", "kdcheshang.com", "kdcheshang", cn.insmart.mp.media.common.enums.DomainEnum.BLANK),
    PC_AUTO("\u592a\u5e73\u6d0b\u6c7d\u8f66\u7f51", "pcauto.com.cn", "pcauto", cn.insmart.mp.media.common.enums.DomainEnum.PCAUTO),
    AUTO_LIVE("autolive", "autolive.com.cn", "autolive", cn.insmart.mp.media.common.enums.DomainEnum.AUTO_LIVE);

    private static final Logger log;
    @EnumLabel
    public final String description;
    @EnumKey
    public final String domain;
    public final String imageFolder;
    private final cn.insmart.mp.media.common.enums.DomainEnum mpDomain;
    static final DomainEnum[] SUPPORT_HTTPS_DOMAIN;

    public static DomainEnum get(String imageFolder) {
        for (DomainEnum o : DomainEnum.values()) {
            if (!o.imageFolder.equals(imageFolder)) continue;
            return o;
        }
        return null;
    }

    public static DomainEnum matches(URL url) {
        return DomainEnum.matches(url.getHost());
    }

    public static DomainEnum matches(String url) {
        for (DomainEnum domain : DomainEnum.values()) {
            try {
                if (!StringUtils.endsWith((CharSequence)url, (CharSequence)(CHA_CHE_JIA.equals((Object)domain) ? "chachejia.cn" : domain.getDomain()))) continue;
                return domain;
            }
            catch (Exception e) {
                log.info("matches domain error! {}", (Object)url);
            }
        }
        return null;
    }

    public static String matchTitle(String url) {
        if (url.matches("^(http|https)://.+?\\.pc.+?\\.com\\.cn.*")) {
            return "\u3010\u592a\u5e73\u6d0b\u6c7d\u8f66\u7f51\u3011";
        }
        if (StringUtils.contains((CharSequence)url, (CharSequence)PC_AUTO.getDomain())) {
            return "\u3010\u592a\u5e73\u6d0b\u6c7d\u8f66\u7f51\u3011";
        }
        if (StringUtils.contains((CharSequence)url, (CharSequence)KOU_DAI_SHANG_CHENG.getDomain())) {
            return "\u3010\u53e3\u888b\u871c\u8702\u3011";
        }
        if (StringUtils.contains((CharSequence)url, (CharSequence)KAUI_TUAN_CHE.getDomain())) {
            return "\u3010\u5feb\u56e2\u8f66\u3011";
        }
        if (StringUtils.contains((CharSequence)url, (CharSequence)LE_GOU_CHE.getDomain())) {
            return "\u3010\u4e50\u56e2\u8f66\u3011";
        }
        if (StringUtils.contains((CharSequence)url, (CharSequence)MAI_CHE_BANG.getDomain())) {
            return "\u3010\u4e70\u8f66\u5e2e\u3011";
        }
        if (StringUtils.contains((CharSequence)url, (CharSequence)AUTO_LIVE.getDomain())) {
            return "\u3010\u777f\u96c6\u5ba2\u3011";
        }
        if (StringUtils.contains((CharSequence)url, (CharSequence)DI_SHANG_PAO.getDomain())) {
            return "\u3010\u8f66\u95ea\u95ea\u3011";
        }
        if (StringUtils.contains((CharSequence)url, (CharSequence)CHE_JIA_BAO.getDomain())) {
            return "\u3010\u8f66\u95ea\u8d2d\u3011";
        }
        if (StringUtils.contains((CharSequence)url, (CharSequence)"chachejia.cn")) {
            return "\u3010\u67e5\u8f66\u4ef7\u3011";
        }
        return "\u3010\u4e70\u8f66\u5e2e\u3011";
    }

    public static boolean isValidateDomain(String url) {
        try {
            if (url == null || !url.matches("^https?://.*")) {
                return false;
            }
            return DomainEnum.isValidateDomain(new URL(url));
        }
        catch (Exception e) {
            log.error("isValidateDomain error! {}, {}", (Object)url, (Object)e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isValidateDomain(URL url) {
        return DomainEnum.matches(url) != null;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getImageFolder() {
        return this.imageFolder;
    }

    private DomainEnum(String description, String domain, String imageFolder, cn.insmart.mp.media.common.enums.DomainEnum mpDomain) {
        this.description = description;
        this.domain = domain;
        this.imageFolder = imageFolder;
        this.mpDomain = mpDomain;
    }

    public cn.insmart.mp.media.common.enums.DomainEnum getMpDomain() {
        return this.mpDomain;
    }

    static {
        log = LoggerFactory.getLogger(DomainEnum.class);
        SUPPORT_HTTPS_DOMAIN = new DomainEnum[]{KOU_DAI_SHANG_CHENG, PC_AUTO, LE_GOU_CHE, KAUI_TUAN_CHE, MAI_CHE_BANG, DI_SHANG_PAO, CHE_JIA_BAO};
    }
}

