/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.common.utils;

import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONObject;
import cn.insmart.fx.common.lang.util.StringUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyMailUtil {
    private static final Logger log = LoggerFactory.getLogger(MyMailUtil.class);
    private static String url = "https://www.j3code.cn/comm_pc/communication-support-mail/v1/mail/sendBatch";
    public static String target01 = "1491989462@qq.com";

    public static void sendMail(String title, Exception e) {
        MyMailUtil.sendMail(title, Collections.singletonList(e));
    }

    public static void sendMail(String title, List<Exception> exceptionList) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            for (Exception exception : exceptionList) {
                String error = MyMailUtil.parseStackTrace(exception);
                if (Objects.isNull(error) || StringUtils.contains((CharSequence)error, (CharSequence)"\u65e0\u6cd5\u6784\u5efaException") || StringUtils.contains((CharSequence)error, (CharSequence)"DeadlockLoserDataAccessException")) continue;
                stringBuffer.append(error).append("==============================================\r\n");
            }
            if (stringBuffer.length() <= 0) {
                return;
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.putOpt("addressList", List.of(target01));
            jsonObject.putOpt("title", (Object)title);
            jsonObject.putOpt("content", (Object)("<xmp>" + stringBuffer.toString() + "</xmp>"));
            jsonObject.putOpt("isHtml", (Object)true);
            HttpRequest.post((String)url).body(jsonObject.toString()).execute();
        }
        catch (Exception ex) {
            log.error("===============sendMail_error, {}", (Throwable)ex);
        }
    }

    public static String parseStackTrace(Exception ex) {
        StringWriter sw = null;
        PrintWriter pw = null;
        try {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            return sw.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void main(String[] args) {
        MyMailUtil.sendMail("\u6d4b\u8bd5\u53d1\u9001", new RuntimeException("\u6d4b\u8bd5"));
    }
}

