/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.common.utils;

import cn.insmart.fx.common.lang.util.ArrayUtils;
import cn.insmart.fx.common.lang.util.CollectionUtils;
import cn.insmart.fx.common.lang.util.StringUtils;
import cn.pcauto.sem.common.enums.ComparisonEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlUtil {
    private static final Logger log = LoggerFactory.getLogger(SqlUtil.class);

    public static List<ComparisonQuery> parseStringToList(String queryArrayString) {
        if (StringUtils.isNotBlank((CharSequence)queryArrayString)) {
            String[] queryArray = StringUtils.split((String)queryArrayString, (String)"_");
            return Arrays.stream(queryArray).map(s -> {
                try {
                    String[] qv = StringUtils.split((String)s, (String)"-");
                    if (qv == null || ArrayUtils.getLength((Object)qv) < 2) {
                        return null;
                    }
                    ComparisonEnum comparison = ComparisonEnum.getByName(qv[0]);
                    if (comparison == null) {
                        return null;
                    }
                    BigDecimal value = new BigDecimal(qv[1]);
                    return new ComparisonQuery(comparison, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<String> createComparisonSql(String columnName, boolean withAndStart, Collection<ComparisonQuery> queryList) {
        String sqlFormatString = withAndStart ? "and %s %s %s " : " %s %s %s ";
        return queryList.stream().map(comparisonQuery -> String.format(sqlFormatString, columnName, comparisonQuery.comparison.getSqlSymbol(), comparisonQuery.value)).collect(Collectors.toList());
    }

    private SqlUtil() {
    }

    public static class ComparisonQueryColumn {
        private String costQuery;
        private String conversionQuery;
        private String costPerConversionQuery;
        private String costColumnName;
        private String conversionColumnName;
        private String costPerConversionColumnName;

        public void initColumnName(String costColumnName, String conversionColumnName, String costPerConversionColumnName) {
            this.costColumnName = costColumnName;
            this.conversionColumnName = conversionColumnName;
            this.costPerConversionColumnName = costPerConversionColumnName;
        }

        public boolean containsQuery() {
            return !StringUtils.isAllBlank((CharSequence[])new CharSequence[]{this.costQuery, this.conversionQuery, this.costPerConversionQuery});
        }

        public List<String> getExtendColumnNameList() {
            ArrayList<String> list = new ArrayList<String>();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.costQuery, this.costColumnName})) {
                list.addAll(SqlUtil.createComparisonSql(this.costColumnName, true, SqlUtil.parseStringToList(this.costQuery)));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.conversionQuery, this.conversionColumnName})) {
                list.addAll(SqlUtil.createComparisonSql(this.conversionColumnName, true, SqlUtil.parseStringToList(this.conversionQuery)));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.costPerConversionQuery, this.costPerConversionColumnName})) {
                list.addAll(SqlUtil.createComparisonSql(this.costPerConversionColumnName, true, SqlUtil.parseStringToList(this.costPerConversionQuery)));
            }
            return list;
        }

        public String getHavingQueryString() {
            ArrayList<String> list = new ArrayList<String>();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.costQuery, this.costColumnName})) {
                list.addAll(SqlUtil.createComparisonSql(this.costColumnName, false, SqlUtil.parseStringToList(this.costQuery)));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.conversionQuery, this.conversionColumnName})) {
                list.addAll(SqlUtil.createComparisonSql(this.conversionColumnName, false, SqlUtil.parseStringToList(this.conversionQuery)));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.costPerConversionQuery, this.costPerConversionColumnName})) {
                list.addAll(SqlUtil.createComparisonSql(this.costPerConversionColumnName, false, SqlUtil.parseStringToList(this.costPerConversionQuery)));
            }
            if (CollectionUtils.isEmpty(list)) {
                return "";
            }
            return String.join((CharSequence)"and", list);
        }

        public String getCostQuery() {
            return this.costQuery;
        }

        public String getConversionQuery() {
            return this.conversionQuery;
        }

        public String getCostPerConversionQuery() {
            return this.costPerConversionQuery;
        }

        public String getCostColumnName() {
            return this.costColumnName;
        }

        public String getConversionColumnName() {
            return this.conversionColumnName;
        }

        public String getCostPerConversionColumnName() {
            return this.costPerConversionColumnName;
        }

        public String toString() {
            return "SqlUtil.ComparisonQueryColumn(costQuery=" + this.getCostQuery() + ", conversionQuery=" + this.getConversionQuery() + ", costPerConversionQuery=" + this.getCostPerConversionQuery() + ", costColumnName=" + this.getCostColumnName() + ", conversionColumnName=" + this.getConversionColumnName() + ", costPerConversionColumnName=" + this.getCostPerConversionColumnName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ComparisonQueryColumn)) {
                return false;
            }
            ComparisonQueryColumn other = (ComparisonQueryColumn)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$costQuery = this.getCostQuery();
            String other$costQuery = other.getCostQuery();
            if (this$costQuery == null ? other$costQuery != null : !this$costQuery.equals(other$costQuery)) {
                return false;
            }
            String this$conversionQuery = this.getConversionQuery();
            String other$conversionQuery = other.getConversionQuery();
            if (this$conversionQuery == null ? other$conversionQuery != null : !this$conversionQuery.equals(other$conversionQuery)) {
                return false;
            }
            String this$costPerConversionQuery = this.getCostPerConversionQuery();
            String other$costPerConversionQuery = other.getCostPerConversionQuery();
            if (this$costPerConversionQuery == null ? other$costPerConversionQuery != null : !this$costPerConversionQuery.equals(other$costPerConversionQuery)) {
                return false;
            }
            String this$costColumnName = this.getCostColumnName();
            String other$costColumnName = other.getCostColumnName();
            if (this$costColumnName == null ? other$costColumnName != null : !this$costColumnName.equals(other$costColumnName)) {
                return false;
            }
            String this$conversionColumnName = this.getConversionColumnName();
            String other$conversionColumnName = other.getConversionColumnName();
            if (this$conversionColumnName == null ? other$conversionColumnName != null : !this$conversionColumnName.equals(other$conversionColumnName)) {
                return false;
            }
            String this$costPerConversionColumnName = this.getCostPerConversionColumnName();
            String other$costPerConversionColumnName = other.getCostPerConversionColumnName();
            return !(this$costPerConversionColumnName == null ? other$costPerConversionColumnName != null : !this$costPerConversionColumnName.equals(other$costPerConversionColumnName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ComparisonQueryColumn;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $costQuery = this.getCostQuery();
            result = result * 59 + ($costQuery == null ? 43 : $costQuery.hashCode());
            String $conversionQuery = this.getConversionQuery();
            result = result * 59 + ($conversionQuery == null ? 43 : $conversionQuery.hashCode());
            String $costPerConversionQuery = this.getCostPerConversionQuery();
            result = result * 59 + ($costPerConversionQuery == null ? 43 : $costPerConversionQuery.hashCode());
            String $costColumnName = this.getCostColumnName();
            result = result * 59 + ($costColumnName == null ? 43 : $costColumnName.hashCode());
            String $conversionColumnName = this.getConversionColumnName();
            result = result * 59 + ($conversionColumnName == null ? 43 : $conversionColumnName.hashCode());
            String $costPerConversionColumnName = this.getCostPerConversionColumnName();
            result = result * 59 + ($costPerConversionColumnName == null ? 43 : $costPerConversionColumnName.hashCode());
            return result;
        }

        public void setCostQuery(String costQuery) {
            this.costQuery = costQuery;
        }

        public void setConversionQuery(String conversionQuery) {
            this.conversionQuery = conversionQuery;
        }

        public void setCostPerConversionQuery(String costPerConversionQuery) {
            this.costPerConversionQuery = costPerConversionQuery;
        }
    }

    private static class ComparisonQuery {
        ComparisonEnum comparison;
        BigDecimal value;

        public ComparisonEnum getComparison() {
            return this.comparison;
        }

        public BigDecimal getValue() {
            return this.value;
        }

        public void setComparison(ComparisonEnum comparison) {
            this.comparison = comparison;
        }

        public void setValue(BigDecimal value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ComparisonQuery)) {
                return false;
            }
            ComparisonQuery other = (ComparisonQuery)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ComparisonEnum this$comparison = this.getComparison();
            ComparisonEnum other$comparison = other.getComparison();
            if (this$comparison == null ? other$comparison != null : !((Object)((Object)this$comparison)).equals((Object)other$comparison)) {
                return false;
            }
            BigDecimal this$value = this.getValue();
            BigDecimal other$value = other.getValue();
            return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ComparisonQuery;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ComparisonEnum $comparison = this.getComparison();
            result = result * 59 + ($comparison == null ? 43 : ((Object)((Object)$comparison)).hashCode());
            BigDecimal $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            return result;
        }

        public String toString() {
            return "SqlUtil.ComparisonQuery(comparison=" + this.getComparison() + ", value=" + this.getValue() + ")";
        }

        public ComparisonQuery() {
        }

        public ComparisonQuery(ComparisonEnum comparison, BigDecimal value) {
            this.comparison = comparison;
            this.value = value;
        }
    }
}

