/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.enroll.sdk.service.impl;

import cn.insmart.fx.common.lang.util.StringUtils;
import cn.pcauto.sem.enroll.sdk.autoconfigure.EnrollDatongProperties;
import cn.pcauto.sem.enroll.sdk.autoconfigure.EnrollSdkProperties;
import cn.pcauto.sem.enroll.sdk.codec.JacksonDecoder;
import cn.pcauto.sem.enroll.sdk.codec.JacksonEncoder;
import cn.pcauto.sem.enroll.sdk.service.ApiFactoryService;
import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.httpclient.ApacheHttpClient;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ApiFactoryServiceImpl
implements ApiFactoryService {
    private static final Logger log = LoggerFactory.getLogger(ApiFactoryServiceImpl.class);
    private final EnrollSdkProperties properties;
    private final EnrollDatongProperties datongProperties;

    @Override
    public void test() {
        log.info("properties : {}", (Object)this.properties);
        log.info("datongProperties : {}", (Object)this.datongProperties);
    }

    @Override
    public <T> T createDatong(Class<T> apiClass) {
        return this.createPost(apiClass, this.datongProperties.getUrl());
    }

    @Override
    public <T> T createPost(Class<T> apiClass, String uri) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (StringUtils.isNotBlank((CharSequence)this.properties.getHost())) {
            HttpHost httpHost = new HttpHost(this.properties.getHost(), this.properties.getPort());
            builder.setProxy(httpHost);
        }
        return (T)Feign.builder().client((Client)new ApacheHttpClient((HttpClient)builder.build())).logLevel(Logger.Level.FULL).logger(new feign.Logger(){

            protected void log(String configKey, String format, Object ... args) {
                log.info("feign: {}, {}", (Object)format, (Object)args);
            }
        }).decoder((Decoder)new JacksonDecoder()).encoder((Encoder)new JacksonEncoder()).target(apiClass, uri);
    }

    public ApiFactoryServiceImpl(EnrollSdkProperties properties, EnrollDatongProperties datongProperties) {
        this.properties = properties;
        this.datongProperties = datongProperties;
    }
}

