/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.enroll.sdk.autoconfigure;

import cn.pcauto.sem.enroll.sdk.autoconfigure.EnrollDatongProperties;
import cn.pcauto.sem.enroll.sdk.autoconfigure.EnrollSdkProperties;
import cn.pcauto.sem.enroll.sdk.service.ApiFactoryService;
import cn.pcauto.sem.enroll.sdk.service.impl.ApiFactoryServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={EnrollSdkProperties.class, EnrollDatongProperties.class})
public class EnrollSdkAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EnrollSdkAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    ApiFactoryService serviceFactory(EnrollSdkProperties properties, EnrollDatongProperties datongProperties) {
        log.info("\u5b9e\u4f8b\u5316 ServiceFactory, properties: {}", (Object)properties);
        log.info("\u5b9e\u4f8b\u5316 ServiceFactory, datongProperties: {}", (Object)datongProperties);
        return new ApiFactoryServiceImpl(properties, datongProperties);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnrollSdkAutoConfiguration)) {
            return false;
        }
        EnrollSdkAutoConfiguration other = (EnrollSdkAutoConfiguration)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof EnrollSdkAutoConfiguration;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "EnrollSdkAutoConfiguration()";
    }
}

