/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.tencent.sdk.service.impl;

import cn.pcauto.sem.tencent.sdk.configuration.SdkProperties;
import cn.pcauto.sem.tencent.sdk.core.coder.Coder;
import cn.pcauto.sem.tencent.sdk.service.ApiService;
import cn.pcauto.sem.tencent.sdk.service.ApiServiceFactory;
import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.httpclient.ApacheHttpClient;
import java.util.Map;
import java.util.UUID;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ApiServiceFactoryImpl
implements ApiServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(ApiServiceFactoryImpl.class);
    private final SdkProperties properties;

    @Override
    public <T extends ApiService> T create(Class<T> apiInterfaceClass) {
        return (T)((ApiService)Feign.builder().requestInterceptor(template -> {
            String url = template.url();
            try {
                String accountIdBeginUrl = url.substring(url.indexOf("account_id"));
                long accountId = Long.parseLong(accountIdBeginUrl.substring("account_id=".length(), accountIdBeginUrl.contains("&") ? accountIdBeginUrl.indexOf("&") : accountIdBeginUrl.length()));
                Map<String, String> account = SdkProperties.ACCOUNTS.get(accountId);
                template.header("Content-Type", new String[]{"application/json"});
                template.query("access_token", new String[]{account.get("access_token")});
                template.query("timestamp", new String[]{String.valueOf(System.currentTimeMillis() / 1000L)});
                template.query("nonce", new String[]{UUID.randomUUID().toString().replace("-", "")});
            }
            catch (Exception e) {
                log.info("tencent set common params error url: {}", (Object)url);
            }
        }).client((Client)new ApacheHttpClient((HttpClient)HttpClientBuilder.create().build())).logLevel(Logger.Level.FULL).logger(new feign.Logger(){

            protected void log(String configKey, String format, Object ... args) {
                log.debug("feign: {}, {}, {}", new Object[]{configKey, format, args});
            }
        }).decoder((Decoder)new Coder(this.properties)).encoder((Encoder)new Coder(this.properties)).target(apiInterfaceClass, this.properties.getApi()));
    }

    public ApiServiceFactoryImpl(SdkProperties properties) {
        this.properties = properties;
    }
}

