/*
 * Decompiled with CFR 0.152.
 */
package cn.pcauto.sem.toutiao.common.util;

import cn.insmart.fx.common.lang.util.ArrayUtils;
import cn.insmart.fx.common.lang.util.IOUtils;
import cn.insmart.fx.common.lang.util.ResourceUtils;
import cn.insmart.fx.common.lang.util.StringUtils;
import cn.pcauto.sem.toutiao.common.dto.AreaDTO;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ToutiaoAreaUtils {
    private static final Logger log = LoggerFactory.getLogger(ToutiaoAreaUtils.class);
    public static final long[] TOUTIAO_SPECIAL_CITY_TOUTIAO_ID = new long[]{31L, 50L, 12L, 11L};
    public static final long[] TOUTIAO_EXCLUDE_PROVINCE_ID = new long[]{71L, 82L, 81L};
    private static final Province[] SPECIAL_CITY = new Province[]{Province.Beijin, Province.Shanghai, Province.Tianjin, Province.Chongqing, Province.Hongkong, Province.Aomen};
    private static JSONObject json = null;
    private static Map<String, Long> hmPro = new HashMap<String, Long>();
    private static Map<String, Long> hmCity = new HashMap<String, Long>();
    private static AreaDTO areaDTO;

    public static boolean isSemAreaCountry(String semArea) {
        return StringUtils.containsAny((CharSequence)semArea, (CharSequence[])new CharSequence[]{"\u5168\u56fd", "\u5168\u90e8"});
    }

    public static boolean isToutiaoIdProvince(Long toutiaoId) {
        Assert.notNull((Object)toutiaoId, (String)"isToutiaoIdProvince(): toutiaoId is null");
        return toutiaoId < 100L && !ArrayUtils.contains((long[])TOUTIAO_SPECIAL_CITY_TOUTIAO_ID, (long)toutiaoId);
    }

    public static Long getCodeByArea(String area) {
        Map<Long, String> result = ToutiaoAreaUtils.format(area);
        if (result == null || result.size() > 1) {
            return 0L;
        }
        Long returnCode = 0L;
        for (Long code : result.keySet()) {
            returnCode = code < 100L ? code * 10000L : code;
        }
        return returnCode;
    }

    public static Map<Long, String> format(String semArea) {
        HashMap<Long, String> rt = new HashMap<Long, String>();
        if (json == null || semArea == null) {
            return rt;
        }
        if (ToutiaoAreaUtils.isSemAreaCountry(semArea)) {
            for (Map.Entry<String, Long> pro : hmPro.entrySet()) {
                if (ArrayUtils.contains((long[])TOUTIAO_EXCLUDE_PROVINCE_ID, (long)pro.getValue())) continue;
                rt.put(pro.getValue(), pro.getKey());
            }
            return rt;
        }
        AreaDetail detail = null;
        detail = StringUtils.equals((CharSequence)semArea, (CharSequence)"\u5409\u6797\u5e02") ? ToutiaoAreaUtils.formatQuietly("\u5409\u6797\u5409\u6797") : (StringUtils.equals((CharSequence)semArea, (CharSequence)"\u6e58\u897f\u571f\u5bb6\u65cf\u82d7\u65cf\u81ea\u6cbb\u5dde") ? ToutiaoAreaUtils.formatQuietly("\u6e58\u897f") : (StringUtils.equals((CharSequence)semArea, (CharSequence)"\u5ef6\u8fb9\u671d\u9c9c\u65cf\u81ea\u6cbb\u5dde") ? ToutiaoAreaUtils.formatQuietly("\u5ef6\u8fb9") : ToutiaoAreaUtils.formatQuietly(semArea)));
        if (detail == null) {
            if (semArea.contains("\u76f4\u8f96")) {
                rt.put(hmPro.get("\u5317\u4eac"), "\u5317\u4eac");
                rt.put(hmPro.get("\u4e0a\u6d77"), "\u4e0a\u6d77");
                rt.put(hmPro.get("\u5929\u6d25"), "\u5929\u6d25");
                rt.put(hmPro.get("\u91cd\u5e86"), "\u91cd\u5e86");
            } else {
                System.out.println(semArea + " detail is null");
            }
            return rt;
        }
        if (StringUtils.isNotBlank((CharSequence)detail.getCity())) {
            String city = detail.getSimpleName();
            if (StringUtils.containsAny((CharSequence)city, (CharSequence[])new CharSequence[]{"\u5317\u4eac", "\u4e0a\u6d77", "\u5929\u6d25", "\u91cd\u5e86"})) {
                if (hmPro.containsKey(detail.getSimpleCity())) {
                    rt.put(hmPro.get(detail.getSimpleCity()), detail.getSimpleCity());
                }
            } else if (hmCity.containsKey(city)) {
                rt.put(hmCity.get(city), city);
            }
        } else if (hmPro.containsKey(detail.getSimpleProvince())) {
            rt.put(hmPro.get(detail.getSimpleProvince()), detail.getSimpleProvince());
        }
        return rt;
    }

    public static AreaDetail formatQuietly(String src) throws AreaNameFormatException {
        try {
            return ToutiaoAreaUtils.formatAreaDetail(src);
        }
        catch (AreaNameFormatException e) {
            return null;
        }
    }

    public static AreaDetail formatAreaDetail(String province, String city) throws AreaNameFormatException {
        return ToutiaoAreaUtils.formatAreaDetail((String)StringUtils.defaultIfBlank((CharSequence)province, (CharSequence)"") + (String)StringUtils.defaultIfBlank((CharSequence)city, (CharSequence)""));
    }

    public static AreaDetail formatAreaDetail(String src) throws AreaNameFormatException {
        AreaDetail detail;
        block14: {
            if (StringUtils.isBlank((CharSequence)src)) {
                throw new AreaNameFormatException("\u9700\u8981\u683c\u5f0f\u5730\u533a\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String areaName = RegExUtils.replaceAll((String)src, (String)"\\s*", (String)"");
            if (ToutiaoAreaUtils.isCountry(src)) {
                return new AreaDetail(null, null);
            }
            Province province = Province.of(areaName);
            if (province == null) {
                if (StringUtils.endsWith((CharSequence)areaName, (CharSequence)"\u5e02")) {
                    province = Province.of(StringUtils.removeEnd((String)areaName, (String)"\u5e02"));
                }
                if (province == null) {
                    throw new AreaNameFormatException("\u5730\u533a\u683c\u5f0f\u4e0d\u6b63\u786e " + src);
                }
            }
            if (ArrayUtils.contains((Object[])SPECIAL_CITY, (Object)province)) {
                detail = new AreaDetail(province, new City(province.getName()));
            } else {
                City city = null;
                Object residue = RegExUtils.replaceAll((String)areaName, (String)province.regx, (String)"");
                if (StringUtils.isNotBlank((CharSequence)residue)) {
                    residue = (String)residue + (((String)residue).endsWith("\u5e02") ? "" : "\u5e02");
                    city = new City((String)residue, null);
                }
                detail = new AreaDetail(province, city);
            }
            try {
                if (ArrayUtils.contains((Object[])SPECIAL_CITY, (Object)detail.getProvinceObject())) {
                    AreaDTO.Province pp = Objects.requireNonNull(areaDTO.getProvince(AreaDTO.Province.DIRECTLY_CITY), "\u63a5\u53e3\u76f4\u8f96\u5e02\u4e3a\u7a7a");
                    for (AreaDTO.City c : pp.getCityList()) {
                        if (!StringUtils.contains((CharSequence)c.getName(), (CharSequence)detail.city.name) && !StringUtils.contains((CharSequence)detail.city.name, (CharSequence)c.getName())) continue;
                        detail.city.id = c.getCityId();
                        detail.province.id = 999L;
                        break block14;
                    }
                    break block14;
                }
                Map<Long, AreaDTO.Province> map = areaDTO.getProvinceMap();
                for (Long id : map.keySet()) {
                    AreaDTO.Province pp = map.get(id);
                    if (!StringUtils.contains((CharSequence)pp.getName(), (CharSequence)detail.province.simple) && !StringUtils.contains((CharSequence)detail.province.simple, (CharSequence)pp.getName())) continue;
                    detail.province.id = id;
                    if (detail.city == null) break;
                    for (AreaDTO.City c : pp.getCityList()) {
                        if (!StringUtils.contains((CharSequence)c.getName(), (CharSequence)detail.city.name) && !StringUtils.contains((CharSequence)detail.city.name, (CharSequence)c.getName())) continue;
                        detail.city.id = c.getCityId();
                        break block14;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return detail;
    }

    public static boolean isCountry(String src) {
        return StringUtils.isBlank((CharSequence)src) || ToutiaoAreaUtils.matcher("\u5168\u56fd|\u4e2d\u56fd|\u5168\u90e8\u533a\u57df|\u5168\u90e8", src);
    }

    public static boolean isProvince(String province) {
        if (StringUtils.isBlank((CharSequence)province)) {
            return false;
        }
        for (Province p : Province.values()) {
            if (!province.matches(p.regx) || ToutiaoAreaUtils.isSpecialCity(province)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSpecialCity(String area) {
        for (Province s : SPECIAL_CITY) {
            if (!area.contains(s.regx)) continue;
            return true;
        }
        return false;
    }

    private static boolean matcher(String regex, String area) {
        Pattern p = Pattern.compile(regex);
        return p.matcher(area).find();
    }

    public static JSONArray parseToToutiaoAreaJson(Collection<Long> collection) {
        JSONArray jsonArray = new JSONArray();
        for (Long id : collection) {
            jsonArray.add((Object)id);
        }
        return jsonArray;
    }

    public static JSONArray parseToToutiaoAreaJson(Integer cityCode) {
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)cityCode);
        return jsonArray;
    }

    public static Map<String, Long> getHmPro() {
        return hmPro;
    }

    public static void setHmPro(Map<String, Long> hmPro) {
        ToutiaoAreaUtils.hmPro = hmPro;
    }

    public static void main(String[] args) {
        System.out.println(hmPro);
        System.out.println(hmPro.size());
        System.out.println(hmCity);
        log.info("areaDTO {}", (Object)areaDTO);
        for (Map.Entry<String, Long> stringLongEntry : hmPro.entrySet()) {
            if (stringLongEntry.getValue() <= 100L) continue;
            System.out.println(stringLongEntry.getKey() + ", " + stringLongEntry.getValue());
        }
        System.out.println(ToutiaoAreaUtils.format("\u5ef6\u8fb9\u671d\u9c9c\u65cf\u81ea\u6cbb\u5dde"));
        System.out.println(ToutiaoAreaUtils.format("\u5409\u6797\u5409\u6797"));
        System.out.println(ToutiaoAreaUtils.format("\u5168\u56fd"));
        System.out.println(ToutiaoAreaUtils.format("\u5e7f\u4e1c"));
        System.out.println(ToutiaoAreaUtils.format("\u5e7f\u5dde"));
        System.out.println(ToutiaoAreaUtils.format("\u53f0\u6e7e"));
        System.out.println(ToutiaoAreaUtils.format("\u82b1\u83b2"));
    }

    static {
        try {
            JSONObject object;
            ObjectMapper objectMapper = new ObjectMapper();
            areaDTO = Objects.requireNonNull((AreaDTO)objectMapper.readValue(ResourceUtils.getResourceAsStream((String)"areaFile/auto-area.json"), AreaDTO.class), "AreaDTO \u4e3a\u7a7a");
            json = JSONObject.parseObject((String)IOUtils.toString((InputStream)ResourceUtils.getResourceAsStream((String)"areaFile/toutiao-cities.json"), (String)"UTF-8"));
            HashMap<Long, JSONObject> hmCityJson = new HashMap<Long, JSONObject>();
            for (String key : json.keySet()) {
                object = json.getJSONObject(key);
                if (object.getInteger("level") != 2) continue;
                hmCityJson.put(Long.parseLong(key), object);
            }
            for (String key : json.keySet()) {
                object = json.getJSONObject(key);
                if (object.getInteger("level") != 1) continue;
                String pro = object.getString("name");
                AreaDetail detail = ToutiaoAreaUtils.formatAreaDetail(pro);
                if (detail == null) {
                    throw new RuntimeException(pro + " can't format");
                }
                hmPro.put(detail.getSimpleProvince(), Long.parseLong(key));
                for (Object child : object.getJSONArray("children")) {
                    Long cityId = Long.parseLong(child.toString());
                    JSONObject cityJson = (JSONObject)hmCityJson.get(cityId);
                    if (cityJson == null) continue;
                    String city = cityJson.getString("name");
                    detail = ToutiaoAreaUtils.formatAreaDetail(pro, city);
                    if (detail == null) {
                        throw new RuntimeException(pro + city + " can't format");
                    }
                    hmCity.put(detail.getSimpleProvince() + detail.getSimpleCity(), cityId);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static interface AreaName {
        public Long getId();

        public String getName();

        public String getApiOutName();
    }

    public static enum Province implements AreaName
    {
        Hongkong("\u9999\u6e2f", "\u9999\u6e2f"),
        Aomen("\u6fb3\u95e8", "\u6fb3\u95e8"),
        Beijin("\u5317\u4eac\u5e02", "\u5317\u4eac"),
        Shanghai("\u4e0a\u6d77\u5e02", "\u4e0a\u6d77"),
        Tianjin("\u5929\u6d25\u5e02", "\u5929\u6d25"),
        Chongqing("\u91cd\u5e86\u5e02", "\u91cd\u5e86"),
        Guangdong("\u5e7f\u4e1c\u7701", "^\u5e7f\u4e1c\u7701?"),
        Shandong("\u5c71\u4e1c\u7701", "^\u5c71\u4e1c\u7701?"),
        Jiangsu("\u6c5f\u82cf\u7701", "^\u6c5f\u82cf\u7701?"),
        Henan("\u6cb3\u5357\u7701", "^\u6cb3\u5357\u7701?"),
        Hebei("\u6cb3\u5317\u7701", "^\u6cb3\u5317\u7701?"),
        Zhejiang("\u6d59\u6c5f\u7701", "^\u6d59\u6c5f\u7701?"),
        Shaanxi("\u9655\u897f\u7701", "^\u9655\u897f\u7701?"),
        Hunan("\u6e56\u5357\u7701", "^\u6e56\u5357\u7701?"),
        Fujian("\u798f\u5efa\u7701", "^\u798f\u5efa\u7701?"),
        Yunnan("\u4e91\u5357\u7701", "^\u4e91\u5357\u7701?"),
        Sichuan("\u56db\u5ddd\u7701", "^\u56db\u5ddd\u7701?"),
        Anhui("\u5b89\u5fbd\u7701", "^\u5b89\u5fbd\u7701?"),
        Hainan("\u6d77\u5357\u7701", "^\u6d77\u5357\u7701?"),
        Jianxi("\u6c5f\u897f\u7701", "^\u6c5f\u897f\u7701?"),
        Hubie("\u6e56\u5317\u7701", "^\u6e56\u5317\u7701?"),
        Shanxi("\u5c71\u897f\u7701", "^\u5c71\u897f\u7701?"),
        Liaoning("\u8fbd\u5b81\u7701", "^\u8fbd\u5b81\u7701?"),
        Taiwan("\u53f0\u6e7e\u7701", "^\u53f0\u6e7e\u7701?"),
        Guizhou("\u8d35\u5dde\u7701", "^\u8d35\u5dde\u7701?"),
        Gansu("\u7518\u8083\u7701", "^\u7518\u8083\u7701?"),
        Qinghai("\u9752\u6d77\u7701", "^\u9752\u6d77\u7701?"),
        Jilin("\u5409\u6797\u7701", "^\u5409\u6797\u7701?"),
        Heilongjiang("\u9ed1\u9f99\u6c5f\u7701", "^\u9ed1\u9f99\u6c5f\u7701?"),
        Guangxi("\u5e7f\u897f", "^\u5e7f\u897f(\u7701)?(\u58ee\u65cf)?(\u81ea\u6cbb\u533a)?"),
        Sinkiang("\u65b0\u7586", "^\u65b0\u7586(\u7701)?(\u7ef4\u543e\u5c14)?(\u81ea\u6cbb\u533a)?"),
        Xizang("\u897f\u85cf", "^\u897f\u85cf(\u7701)?(\u533a)?(\u81ea\u6cbb\u533a)?"),
        Ningxia("\u5b81\u590f", "^\u5b81\u590f(\u7701)?(\u56de\u65cf)?(\u81ea\u6cbb\u533a)?"),
        InnerMongolia("\u5185\u8499\u53e4", "^\u5185\u8499(\u53e4)?(\u7701)?(\u81ea\u6cbb\u533a)?");

        private Long id;
        private final String name;
        private final String simple;
        private final String regx;

        private Province(String name, String regx) {
            this.regx = regx;
            this.name = name;
            this.simple = name.replaceAll("(\u7701|\u5e02)$", "");
        }

        public static Province of(String name) {
            if (StringUtils.isNotBlank((CharSequence)name)) {
                for (Province province : Province.values()) {
                    if (!ToutiaoAreaUtils.matcher(province.regx, name)) continue;
                    return province;
                }
            }
            return Province.ofCity(name);
        }

        private static Province ofCity(String name) {
            for (AreaDTO.Province province : areaDTO.getProvinceList()) {
                for (AreaDTO.City city : province.getCityList()) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)city.getName(), (CharSequence)name)) continue;
                    return Province.of(province.getName());
                }
            }
            return null;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getApiOutName() {
            return this.simple;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public Long getId() {
            return this.id;
        }
    }

    public static final class City
    implements AreaName {
        private Long id;
        private final String regx;
        private final String name;
        private final String apiOutName;

        private City(String name) {
            this(name, name.replaceAll("(\u5e02|\u5730\u533a|\u5730\u533a\u5e02)$", ""), name);
        }

        private City(String name, String regex) {
            this(name, null, regex);
        }

        private City(String name, String apiOutName, String regx) {
            Objects.requireNonNull(name, "city parameter is null");
            this.name = name;
            this.regx = regx;
            this.apiOutName = apiOutName;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getApiOutName() {
            if (StringUtils.isNotBlank((CharSequence)this.apiOutName)) {
                return this.apiOutName;
            }
            return this.name != null ? this.name.replaceAll("(\u5e02|\u5730\u533a|\u5730\u533a\u5e02)$", "") : null;
        }

        public boolean equals(Object obj) {
            return obj instanceof City && new EqualsBuilder().append((Object)this.name, (Object)((City)obj).name).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.name).toHashCode();
        }

        public String toString() {
            return this.name;
        }

        @Override
        public Long getId() {
            return this.id;
        }
    }

    public static class AreaDetail
    implements Comparable<AreaDetail> {
        public static final String CHINA = "\u5168\u56fd";
        private final City city;
        private final Province province;

        private AreaDetail(Province province, City city) {
            this.city = city;
            this.province = province;
        }

        public Province getProvinceObject() {
            return this.province;
        }

        public City getCityObject() {
            return this.city;
        }

        public String getProvince() {
            return String.valueOf(this.province);
        }

        public String getCity() {
            return this.city == null ? "" : String.valueOf(this.city);
        }

        public String getSimpleProvince() {
            return this.province == null ? null : this.province.getApiOutName();
        }

        public String getName() {
            if (this.province == null) {
                return CHINA;
            }
            return StringUtils.defaultString((String)this.getProvince(), (String)"") + StringUtils.defaultString((String)this.getCity(), (String)"");
        }

        public String getSimpleName() {
            if (this.province == null) {
                return CHINA;
            }
            return StringUtils.defaultString((String)this.getSimpleProvince(), (String)"") + StringUtils.defaultString((String)this.getSimpleCity(), (String)"");
        }

        public String getSimpleCity() {
            return this.city == null ? null : this.city.getApiOutName();
        }

        public boolean isNation() {
            return ToutiaoAreaUtils.isCountry(this.toString());
        }

        public boolean isProvince() {
            return ToutiaoAreaUtils.isProvince(this.toString());
        }

        public boolean isCity() {
            return !this.isNation() && !this.isProvince();
        }

        public boolean isDirectlyCity() {
            return this.city != null && ToutiaoAreaUtils.isSpecialCity(this.city.name);
        }

        @Override
        public int compareTo(AreaDetail detail) {
            return detail == null ? 0 : this.toString().compareTo(detail.toString());
        }

        public String toString() {
            return this.getName();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.province).append((Object)this.city).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof AreaDetail) {
                AreaDetail detail = (AreaDetail)obj;
                return new EqualsBuilder().append((Object)this.province, (Object)detail.province).append((Object)this.city, (Object)detail.city).isEquals();
            }
            return false;
        }

        public long getCityId() {
            try {
                return (Long)ObjectUtils.defaultIfNull((Object)(this.city == null ? 0L : this.city.id), (Object)0L);
            }
            catch (Exception e) {
                throw new RuntimeException("\u4e0d\u80fd\u83b7\u53d6\u57ce\u5e02ID," + this.toString());
            }
        }

        public long getProvinceId() {
            return (Long)ObjectUtils.defaultIfNull((Object)(this.province == null ? 0L : this.province.id), (Object)0L);
        }

        public Long getDirectlyCityProvinceId() {
            return this.isDirectlyCity() ? 999L : this.province.getId();
        }
    }

    public static class AreaNameFormatException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        public AreaNameFormatException(String s) {
            super(s);
        }
    }
}

