package cn.pconline.search.common.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class Cn2Spell
{

    private static Properties config = Config.config();

    private static Properties pinyinCheck = new Properties();

    private static HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
    static
    {
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        String pyCheckFileName = config.getProperty("pinyin.simple.check.file");
        if (pyCheckFileName != null)
        {
            try
            {
                File file = new File(pyCheckFileName);
                FileReader reader = new FileReader(file);
                pinyinCheck.load(reader);
            }
            catch (FileNotFoundException e)
            {
                e.printStackTrace();
            }
            catch (IOException e)
            {
                e.printStackTrace();
            }
        }
    }

    /**
     * 查找拼音检查的词典，如果词典中的有词出现在chinese中，则用该词的拼音部分代替chinese。
     * 如词典文件有"长城=changcheng;cc"
     * ，则check("万里长城",0)=万里changcheng，check("万里长城",1)=万里cc
     * 
     * @param chinese
     * @return
     */
    private static String check(String chinese, int i)
    {
        for (Object obj : pinyinCheck.keySet())
        {
            String key = (String) obj;
            String value = (String) pinyinCheck.get(key);
            String[] ss = value.split(";");
            if (ss != null)
            {
                if (i < ss.length)
                {
                    chinese = chinese.replace(key, ss[i]);
                }
            }
        }
        return chinese;
    }

    /**
     * 获取拼音首字
     * 
     * @param chinese
     * @return
     */
    public static String getFirstAlphaOfSpell(String chinese)
    {
        chinese = check(chinese, 1);
        StringBuffer pinyinName = new StringBuffer();
        char[] nameChar = chinese.toCharArray();
        for (int i = 0; i < nameChar.length; i++)
        {
            if (nameChar[i] > 128)
            {
                try
                {
                    String[] strs = PinyinHelper.toHanyuPinyinStringArray(
                            nameChar[i], defaultFormat);
                    if (strs != null)
                    {
                        pinyinName.append(strs[0].charAt(0));
                    }
                }
                catch (BadHanyuPinyinOutputFormatCombination e)
                {
                    e.printStackTrace();
                }
            }
            else
            {
                pinyinName.append(nameChar[i]);
            }
        }
        return pinyinName.toString();
    }

    /**
     * 获取全拼音，无分割符
     * 
     * @param chinese
     * @return
     */
    public static String getFullSpell(String chinese)
    {
        return getFullSpell(chinese, null);
    }

    /**
     * 获取全拼音，带分割符join
     * 
     * @param chinese
     * @param join
     * @return
     */
    public static String getFullSpell(String chinese, String join)
    {
        chinese = check(chinese, 0);
        StringBuffer pinyinName = new StringBuffer();
        char[] nameChar = chinese.toCharArray();

        for (int i = 0; i < nameChar.length; i++)
        {
            if (nameChar[i] > 128)
            {
                try
                {
                    String[] strs = PinyinHelper.toHanyuPinyinStringArray(
                            nameChar[i], defaultFormat);
                    if (join != null)
                    {
                        pinyinName.append(join);
                    }
                    if (strs != null)
                    {
                        pinyinName.append(strs[0]);
                    }
                }
                catch (BadHanyuPinyinOutputFormatCombination e)
                {
                    e.printStackTrace();
                }
            }
            else
            {
                pinyinName.append(nameChar[i]);
            }
        }
        return pinyinName.toString();
    }
}
