package cn.pconline.search.common.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil
{

    public static final String PATTERNS = "[^0-9]*([0-9]+\\.?[0-9]*)[^0-9]*";

    private static final String NUMPATTERN = "(\\d+\\.*\\d*)";

    private static final Pattern pattern = Pattern.compile("(\\d+元以(上|下))",
            Pattern.DOTALL);

    private static final String PICSIZE = "_100x50";

    /**
     * 获得字符串的中最前面的数字
     * 
     * @param str
     * @return String
     * @author kelly 2011-5-21
     */
    public static String getFirstNumber(String str)
    {
        StringBuilder ret = new StringBuilder();
        if (str != null)
        {
            for (int i = 0; i < str.length(); i++)
            {
                char c = str.charAt(i);
                if ((c >= '0' && c <= '9') || c == '.')
                {
                    ret.append(c);
                }
                else
                {
                    break;
                }
            }
        }
        return ret.toString();
    }

    /**
     * 获取品牌图片
     * 
     * @param bpic
     * @return
     */
    public static String returnBrandPic(String bpic)
    {
        if (bpic == null || bpic.isEmpty())
        {
            return "";
        }

        int index = bpic.lastIndexOf(".");
        String substrstart = bpic.substring(0, index);
        String subend = bpic.substring(index, bpic.length());

        StringBuffer sb = new StringBuffer();
        sb.append(substrstart);
        sb.append(PICSIZE);
        sb.append(subend);

        return sb.toString();
    }

    /**
     * @author Hackin 2010-10-12
     * @param url
     * @return
     */
    public static String encodeClusterQuery(String url)
    {
        String encodedUrl = "";
        if (url != null)
        {

            url = StringUtil.changeDomainToSlash(url);

            String[] urlParts = url.split("clusterQuery=");

            if (urlParts != null)
            {
                encodedUrl = urlParts[0] + "clusterQuery=";
                if (urlParts.length == 2)
                {
                    String[] urlParts2 = urlParts[1].split("&");
                    if (urlParts2 != null)
                    {
                        try
                        {
                            if (urlParts2.length == 1)
                            {
                                encodedUrl += URLEncoder.encode(urlParts2[0],
                                        "gbk");
                            }
                            else if (urlParts2.length > 1)
                            {
                                for (int i = 0; i < urlParts2.length; i++)
                                {
                                    encodedUrl = encodedUrl
                                            + (i == 0 ? "" : "&")
                                            + (i == 0 ? URLEncoder.encode(
                                                    urlParts2[i], "gbk")
                                                    : urlParts2[i]);
                                }
                            }
                        }
                        catch (UnsupportedEncodingException e)
                        {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        return encodedUrl;
    }

    /**
     * 将【以http://开头的url的域名】替换成【/】
     * 
     * @param str
     * @return
     * @author Hackin 2010-10-12
     */
    public static String changeDomainToSlash(String str)
    {
        return (str != null && str.length() > 0) ? str.replaceAll(
                "http:\\/\\/[^\\/]+\\/", "/") : str;
    }

    /**
     * 如果cluster_price的结果是如：200以下，则转换成200元以下。 统一聚类统计的显示形式
     * 
     * @author liuziheng
     * @param cluster_price
     * @return
     */
    public static String changeCLusterPrice(String cluster_price)
    {
        if (cluster_price == null || cluster_price.isEmpty())
        {
            return cluster_price;
        }

        if (cluster_price.contains("-"))
        {
            return cluster_price;
        }

        Matcher matcher = pattern.matcher(cluster_price);
        if (!matcher.find())
        {
            String cn = cluster_price.replaceAll("\\d+", "");
            String num = cluster_price.replaceAll("[^\\d+]", "");
            return num + "元" + cn;
        }

        return cluster_price;
    }

    /**
     * 过滤掉括号以及它里面的内容
     * 
     * @param dtr
     * @return String
     * @author kelly 2009-6-8
     */
    public static String filterBracketContent(String content)
    {
        if (content != null && content.trim().length() > 0)
        {
            content = content.replaceAll("(\\(.*\\))", "");
        }
        return content;
    }

    /**
     * 将双引号转换为html的&quot,将单引号转换为&#39;
     * 
     * @return String
     * @author kelly 2009-12-21
     */
    public static String formatHtmlGuote(String kw)
    {
        return kw != null && kw.trim().length() > 0 ? kw.replaceAll("\"",
                "&quot;").replaceAll("'", "&#39;") : kw;
    }

    /**
     * 屏蔽脚本注入
     * 
     * @param input
     * @return String
     * @author kelly 2009-4-24
     */
    public static String stripHtmlTags(String input)
    {
        String regExp = "<[^>]+>|&[a-zA-Z]{2,6};";
        String spaceRegExp = "\\s+";
        input = input.replaceAll(regExp, " ");
        input = input.trim();
        input = input.replaceAll(spaceRegExp, " ");
        return input;
    }

    /**
     * 字符串是否是“+XXX”，“-XXX”格式，用于判断，是否是高级语法搜索
     */
    public static boolean isSyntax(String key)
    {
        Pattern p = Pattern
                .compile("([^\\+\\-]*(\\+|\\-)[^\\p{Space}\\+\\-]+[^\\+\\-]*)+|.*[A-Za-z]+\\s*:.+.*|.*\".*\".*|.*\\|.*");//
        Matcher m = p.matcher(key);
        return m.matches();
    }

    public static String format(String value)
    {
        // return value != null ? value.replaceAll("&", "") : "";
        return value == null ? "" : value;
    }

    /**
     * 去掉正则的转义字符
     * 
     * @param value
     * @return String
     * @author kelly 2009-12-15
     */
    public static String formatRegex(String value)
    {
        return value != null ? value
                .replaceAll(
                        "[\\(|\\)|\\[|\\]|\\{|\\}|\\\\|\\*|\\?|\\!|\\^|\\-|\\.|\\+|\\,|\\=|\\$]",
                        "")
                : "";
    }

    /**
     * 将value中的prefix和postfix用大写形式的refix和postfix代替
     * 
     * @param value
     * @param prefix
     * @param postfix
     * @return String
     * @author kelly 2009-4-23
     */
    public static String formatContent(String value, String prefix,
            String postfix)
    {
        return value.replaceAll(prefix, prefix.toUpperCase()).replaceAll(
                postfix, postfix.toUpperCase());
    }

    /**
     * 从字符串中获取第一个连续的数字
     * 
     * @param Str
     * @return long
     * @author kelly 2009-3-30
     */
    public static double getNumber(String str)
    {
        if (str == null)
        {
            return -1;
        }
        if (str.contains("以下"))
        {
            return 0;
        }
        Pattern p = Pattern.compile(PATTERNS);
        Matcher m = p.matcher(str);
        String number = null;
        while (m.find())
        {
            number = m.group(1);
            break;
        }
        if (number != null)
        {
            return Double.parseDouble(number);
        }
        else
        {
            return -1;
        }

    }

    public static double getNumber2(String str)
    {
        if (str == null)
        {
            return -1;
        }
        boolean isDown = false;
        if (str.contains("以下"))
        {
            isDown = true;
        }

        Pattern p = Pattern.compile(NUMPATTERN);
        Matcher m = p.matcher(str);
        String number = null;
        while (m.find())
        {
            number = m.group(1);

            break;
        }

        if (number != null)
        {
            double res = Double.parseDouble(number);
            if (isDown)
            {
                return --res;
            }
            return res;
        }
        else
        {
            return -1;
        }
    }

    /**
     * 半角转全角
     * 
     * @param input
     * @return String
     * @author kelly 2009-6-8
     */
    public static String ToSBC(String input)
    {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; i++)
        {
            if (c[i] == 32)
            {
                c[i] = (char) 12288;
                continue;
            }
            if (c[i] < 127) c[i] = (char) (c[i] + 65248);
        }
        return new String(c);
    }

    /**
     * 全角转半角
     * 
     * @param input
     * @return String
     * @author kelly 2009-6-8
     */
    public static String ToDBC(String input)
    {
        if (input == null || "".equals(input))
        {
            return input;
        }
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; i++)
        {
            if (c[i] == 12288)
            {
                c[i] = (char) 32;
                continue;
            }
            if (c[i] > 65280 && c[i] < 65375) c[i] = (char) (c[i] - 65248);
        }
        return new String(c);
    }

    /**
     * 
     * @param input
     * @return
     * @author Hackin
     */
    public static String delHtmlTag(String input)
    {
        if (input == null || input.trim().equals(""))
        {
            return "";
        }
        // 去掉所有html元素,
        String str = input.replaceAll("\\&[a-zA-Z]{1,10};", "").replaceAll(
                "<[^>]*>", "");
        str = str.replaceAll("[(/>)<]", "");
        return str;
    }

    public static String insertSizeInPicUrl(String url, String size)
    {
        if (url == null)
        {
            return "";
        }
        if (url.trim().length() == 0)
        {
            return "";
        }
        int lastDotIndex = url.lastIndexOf(".");
        String left = url.substring(0, lastDotIndex);
        String right = url.substring(lastDotIndex, url.length());
        url = left + size + right;
        return url;
    }

    /**
     * 比如join("abc","-")，那么输出a-b-c，original不能为null
     * 
     * @param original
     * @param joinStr
     * @return
     */
    public static String join(String original, String joinStr)
    {
        StringBuilder target = new StringBuilder();
        char[] cs = original.toCharArray();
        for (int i = 0; i < cs.length; i++)
        {
            target.append(cs[i]);
            if (i != cs.length - 1)
            {
                target.append(joinStr);
            }
        }
        return target.toString();
    }

    /**
     * 移除页面标签
     * 
     * @param text
     * @return
     */
    public static String removePageTags(String text)
    {
        if (text != null)
        {
            String scriptTag = "<\\s*script[^>]*?\\s*>[^<]*<\\s*/script\\s*>";
            String styleTag = "<\\s*style[^>]*?\\s*>[^<]*<\\s*/style\\s*>";
            String xmlTag = "<\\s*xml[^>]*?\\s*>[^<]*<\\s*/xml\\s*>";
            String otherTag = "<[^>]+>";
            String symbol = "&[a-zA-Z0-9]+;";
            Pattern pattern = Pattern.compile("\\s+" + "|" + symbol + "|"
                    + otherTag + "|" + scriptTag + "|" + styleTag + "|"
                    + xmlTag);
            Matcher matcher = pattern.matcher(text);
            while (matcher.find())
            {
                text = matcher.replaceAll("");
            }
        }
        return text;
    }
}
