/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common;

import cn.pconline.search.common.SearchException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.SolrParams;

public class SolrSearcher {
    private SolrServer server;

    private SolrSearcher(String solrBaseUrl) {
        this.server = new HttpSolrServer(solrBaseUrl);
    }

    public static SolrSearcher getSolrSearcher() {
        return null;
    }

    public QueryResponse search(String index, SolrQuery q) {
        QueryRequest req = new QueryRequest((SolrParams)q);
        req.setPath(index);
        try {
            return req.process(this.server);
        }
        catch (SolrServerException e) {
            throw new SearchException(e);
        }
    }

    public static void processHighLightResult(SolrDocument doc, QueryResponse rsp, Map<String, Object> destMap, String keyField, String hField, int size) {
        if (rsp.getResults().getNumFound() <= 0L) {
            return;
        }
        Map hMap = rsp.getHighlighting();
        Object key = doc.get((Object)keyField);
        Map hStrMap = (Map)hMap.get(key);
        List strList = (List)hStrMap.get(hField);
        hStrMap = (Map)hMap.get(key);
        if (CollectionUtils.isEmpty((Collection)strList)) {
            String v = SolrSearcher.castToString(doc.get((Object)hField));
            if (StringUtils.isEmpty((String)v)) {
                return;
            }
            if (v.length() > size) {
                destMap.put(hField, v.subSequence(0, size));
            } else {
                destMap.put(hField, v);
            }
        } else {
            StringBuilder builder = new StringBuilder();
            for (String s : strList) {
                builder.append(s);
            }
            destMap.put(hField, builder.toString());
        }
    }

    private static String castToString(Object source) {
        if (source == null) {
            return null;
        }
        return source.toString();
    }
}

