/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.tools.homonym;

import cn.pconline.search.common.util.CNToSpell;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Homonyms {
    private static Map<String, String> dataMap = null;
    private static Set<String> set = null;

    private Homonyms() {
    }

    public static String getHomonyms(String str) {
        if (dataMap == null) {
            return null;
        }
        String ret = dataMap.get(CNToSpell.getFullSpell(str));
        return ret == null ? "" : ret;
    }

    public static boolean isDomain(String src) {
        String regx = "([\\w-]+\\.)+[\\w-]+(/[\\w-\\.?%=]*)*";
        return src.matches(regx);
    }

    public static void init(String fileNamesStr) {
        dataMap = new HashMap<String, String>();
        set = new HashSet<String>();
        if (fileNamesStr != null) {
            String[] fileNames = fileNamesStr.split(";");
            int i = 0;
            while (i < fileNames.length) {
                Homonyms.loadFromFile(fileNames[i]);
                ++i;
            }
        }
        set = null;
    }

    private static void loadFromFile(String fileName) {
        BufferedReader reader = null;
        try {
            try {
                File file = new File(fileName);
                if (file.exists()) {
                    reader = new BufferedReader(new FileReader(file));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        if (set.contains(line)) continue;
                        set.add(line);
                        String spell = CNToSpell.getFullSpell(line);
                        String str = dataMap.get(spell);
                        str = str != null ? String.valueOf(str) + ";" + line : line;
                        dataMap.put(spell, str);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("\u8bfb\u53d6\u6587\u4ef6" + fileName + "\u53d1\u751f\u5f02\u5e38\uff01", e);
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] args) {
        Homonyms.getHomonyms("\u5ff5\u8c61");
    }
}

