/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.tools.segment;

import cn.pconline.search.common.tools.segment.SegGraph;
import cn.pconline.search.common.tools.segment.bean.Atom;
import cn.pconline.search.common.tools.segment.bean.Dictionary;
import cn.pconline.search.common.tools.segment.bean.SegNode;
import cn.pconline.search.common.tools.segment.bean.WordItem;
import cn.pconline.search.common.tools.segment.utility.Utility;
import java.util.ArrayList;

public class GraphGenerate {
    public static SegGraph generate(ArrayList<Atom> atoms, Dictionary dict) {
        SegGraph segGraph = null;
        SegNode sn = null;
        Atom atom = null;
        if (atoms != null && atoms.size() > 0 && dict != null) {
            segGraph = new SegGraph(true);
            int i = 0;
            while (i < atoms.size()) {
                atom = atoms.get(i);
                String word = atom.getWord();
                if (atom.getPos() == 7) {
                    sn = new SegNode(i, i + 1, 0, 0.0, atom.getWord());
                } else {
                    double value = 2079997.0;
                    int pos = 0;
                    switch (atom.getPos()) {
                        case 9: 
                        case 10: {
                            pos = -27904;
                            word = "\u672a##\u6570";
                            value = 0.0;
                            break;
                        }
                        case 6: {
                            pos = 30464;
                            break;
                        }
                        case 8: {
                            pos = -28280;
                            value = 0.0;
                            word = "\u672a##\u4e32";
                            break;
                        }
                        case 5: {
                            if (Utility.getCharCount("+-1234567890", atom.getWord()) == atom.getLen()) {
                                pos = -27904;
                                word = "\u672a##\u6570";
                            } else {
                                pos = -28280;
                                word = "\u672a##\u4e32";
                            }
                            value = 0.0;
                            break;
                        }
                        default: {
                            pos = atom.getPos();
                        }
                    }
                    sn = new SegNode(i, i + 1, pos, value, word);
                }
                sn.setSrcWord(atom.getWord());
                segGraph.insert(sn);
                ++i;
            }
            String word = null;
            int i2 = 0;
            while (i2 < atoms.size()) {
                int j = i2 + 1;
                word = atoms.get(i2).getWord();
                boolean flag = false;
                if (j < atoms.size()) {
                    Atom a2 = atoms.get(j);
                    if ("\u6708".equals(word) && "\u4efd".equals(a2.getWord())) {
                        segGraph.delete(i2, j);
                        segGraph.delete(i2 + 1, j + 1);
                        word = String.valueOf(word) + a2.getWord();
                        flag = true;
                        ++j;
                    }
                }
                while (j <= atoms.size()) {
                    int totalFreq = 0;
                    ArrayList<WordItem> wis = dict.getHandle(word);
                    if (wis == null) break;
                    if (wis.size() > 0) {
                        SegNode g2;
                        for (WordItem w : wis) {
                            totalFreq += w.getFreq();
                        }
                        if (word.length() == 2 && segGraph.getSize() > 0 && (Utility.isAllNum((g2 = segGraph.getLast()).getWord()) || Utility.isAllChinese(g2.getWord()) && (g2.getWord().indexOf("\u5e74") == 0 || g2.getWord().indexOf("\u6708") == 0)) && "\u672b\u5185\u4e2d\u5e95\u524d\u95f4\u521d".indexOf(word.substring(1)) != -1) break;
                        SegNode sg = null;
                        sg = wis.size() == 1 ? new SegNode(i2, j, wis.get(0).getHandle(), totalFreq, word) : new SegNode(i2, j, 0, totalFreq, word);
                        segGraph.insert(sg);
                    }
                    if (j >= atoms.size()) break;
                    String word2 = atoms.get(j).getWord();
                    word = String.valueOf(word) + word2;
                    ++j;
                }
                if (flag) {
                    ++i2;
                }
                ++i2;
            }
        }
        return segGraph;
    }

    public static SegGraph biGenerate(SegGraph seg, Dictionary dict, Dictionary biDict) {
        SegGraph segGraph = null;
        double smoothParam = 0.1;
        if (seg != null && dict != null && biDict != null) {
            segGraph = new SegGraph(false);
            ArrayList<SegNode> sgs = seg.getSnList();
            SegGraph.NextElementIndex nextEleIndex = new SegGraph.NextElementIndex(seg);
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (sgs != null && i < sgs.size()) {
                SegNode sg = sgs.get(i);
                double curFreq = sg.getPos() >= 0 ? sg.getValue() : (double)dict.getFreq(sg.getWord(), 2);
                ArrayList<SegNode> nextSgs = nextEleIndex.getNextElements(i);
                for (SegNode graph : nextSgs) {
                    buffer.setLength(0);
                    buffer.append(sg.getWord());
                    buffer.append("@");
                    buffer.append(graph.getWord());
                    String twoWords = buffer.toString();
                    int twoFreq = biDict.getFreq(twoWords, 3);
                    double temp = 4.807699241873907E-7;
                    double value = 0.1 * (1.0 + curFreq) / 2159997.0;
                    value += 0.9 * ((1.0 - temp) * (double)twoFreq / (1.0 + curFreq) + temp);
                    value = -Math.log(value);
                    if (value < 0.0) {
                        value += sg.getValue();
                    }
                    SegNode sg2 = new SegNode();
                    sg2.setRow(sgs.indexOf(sg));
                    sg2.setCol(sgs.indexOf(graph));
                    sg2.setWord(twoWords);
                    sg2.setPos(sg.getPos());
                    sg2.setValue(value);
                    segGraph.insert(sg2);
                }
                ++i;
            }
        }
        return segGraph;
    }
}

