/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.tools.segment.utility;

import cn.pconline.search.common.tools.segment.PosTagger;
import cn.pconline.search.common.tools.segment.bean.Dictionary;
import cn.pconline.search.common.tools.segment.bean.PersonName;
import cn.pconline.search.common.tools.segment.utility.GFCommon;
import cn.pconline.search.common.tools.segment.utility.GFString;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class Utility {
    public static final int CC_NUM = 6768;
    public static final int WORD_MAXLENGTH = 100;
    public static final int WT_DELIMITER = 0;
    public static final int WT_CHINESE = 1;
    public static final int WT_OTHER = 2;
    public static final int CT_SENTENCE_BEGIN = 1;
    public static final int CT_SENTENCE_END = 4;
    public static final int CT_SINGLE = 5;
    public static final int CT_DELIMITER = 6;
    public static final int CT_CHINESE = 7;
    public static final int CT_LETTER = 8;
    public static final int CT_NUM = 9;
    public static final int CT_INDEX = 10;
    public static final int CT_OTHER = 17;
    public static final int MAX_WORDS = 650;
    public static final int MAX_SEGMENT_NUM = 10;
    public static final String POSTFIX_SINGLE = "\u575d\u90a6\u5821\u676f\u57ce\u6c60\u6751\u5355\u5c9b\u9053\u5824\u5e97\u6d1e\u6e21\u961f\u6cd5\u5cf0\u5e9c\u5188\u6e2f\u9601\u5bab\u6c9f\u56fd\u6d77\u53f7\u6cb3\u6e56\u73af\u96c6\u6c5f\u5956\u7901\u89d2\u8857\u4e95\u90e1\u5751\u53e3\u77ff\u91cc\u5cad\u697c\u8def\u95e8\u76df\u5e99\u5f04\u724c\u6d3e\u5761\u94fa\u65d7\u6865\u533a\u6e20\u6cc9\u4eba\u5c71\u7701\u5e02\u6c34\u5bfa\u5854\u53f0\u6ee9\u575b\u5802\u5385\u4ead\u5c6f\u6e7e\u6587\u5c4b\u6eaa\u5ce1\u53bf\u7ebf\u4e61\u5df7\u578b\u6d0b\u7a91\u8425\u5c7f\u8bed\u56ed\u82d1\u9662\u95f8\u5be8\u7ad9\u9547\u5dde\u5e84\u65cf\u9642\u5eb5\u753a";
    public static final String[] POSTFIX_MUTIPLE = new String[]{"\u534a\u5c9b", "\u8349\u539f", "\u57ce\u5e02", "\u5927\u5824", "\u5927\u516c\u56fd", "\u5927\u6865", "\u5730\u533a", "\u5e1d\u56fd", "\u6e21\u69fd", "\u6e2f\u53e3", "\u9ad8\u901f\u516c\u8def", "\u9ad8\u539f", "\u516c\u8def", "\u516c\u56ed", "\u5171\u548c\u56fd", "\u8c37\u5730", "\u5e7f\u573a", "\u56fd\u9053", "\u6d77\u5ce1", "\u80e1\u540c", "\u673a\u573a", "\u96c6\u9547", "\u6559\u533a", "\u8857\u9053", "\u53e3\u5cb8", "\u7801\u5934", "\u7164\u77ff", "\u7267\u573a", "\u519c\u573a", "\u76c6\u5730", "\u5e73\u539f", "\u4e18\u9675", "\u7fa4\u5c9b", "\u6c99\u6f20", "\u6c99\u6d32", "\u5c71\u8109", "\u5c71\u4e18", "\u6c34\u5e93", "\u96a7\u9053", "\u7279\u533a", "\u94c1\u8def", "\u65b0\u6751", "\u96ea\u5cf0", "\u76d0\u573a", "\u76d0\u6e56", "\u6e14\u573a", "\u76f4\u8f96\u5e02", "\u81ea\u6cbb\u533a", "\u81ea\u6cbb\u53bf", "\u81ea\u6cbb\u5dde", ""};
    public static final String TRANS_ENGLISH = "\u00b7\u2014\u963f\u57c3\u827e\u7231\u5b89\u6602\u6556\u5965\u6fb3\u7b06\u82ad\u5df4\u767d\u62dc\u73ed\u90a6\u4fdd\u5821\u9c8d\u5317\u8d1d\u672c\u6bd4\u6bd5\u5f7c\u522b\u6ce2\u73bb\u535a\u52c3\u4f2f\u6cca\u535c\u5e03\u624d\u91c7\u4ed3\u67e5\u5dee\u67f4\u5f7b\u5ddd\u8328\u6148\u6b21\u8fbe\u5927\u6234\u4ee3\u4e39\u65e6\u4f46\u5f53\u9053\u5fb7\u5f97\u7684\u767b\u8fea\u72c4\u8482\u5e1d\u4e01\u4e1c\u675c\u6566\u591a\u989d\u4fc4\u5384\u9102\u6069\u5c14\u4f10\u6cd5\u8303\u83f2\u82ac\u8d39\u4f5b\u592b\u798f\u5f17\u752b\u5676\u76d6\u5e72\u5188\u54e5\u6208\u9769\u845b\u683c\u5404\u6839\u53e4\u74dc\u54c8\u6d77\u7f55\u7ff0\u6c57\u6c49\u8c6a\u5408\u6cb3\u8d6b\u4ea8\u4faf\u547c\u80e1\u534e\u970d\u57fa\u5409\u53ca\u52a0\u8d3e\u575a\u7b80\u6770\u91d1\u4eac\u4e45\u5c45\u541b\u5580\u5361\u51ef\u574e\u5eb7\u8003\u67ef\u79d1\u53ef\u514b\u80af\u5e93\u594e\u62c9\u5587\u83b1\u6765\u5170\u90ce\u6717\u52b3\u52d2\u96f7\u7d2f\u695e\u9ece\u7406\u674e\u91cc\u8389\u4e3d\u5386\u5229\u7acb\u529b\u8fde\u5ec9\u826f\u5217\u70c8\u6797\u9686\u5362\u864f\u9c81\u8def\u4f26\u4ed1\u7f57\u6d1b\u739b\u9a6c\u4e70\u9ea6\u8fc8\u66fc\u8305\u8302\u6885\u95e8\u8499\u76df\u7c73\u871c\u5bc6\u654f\u660e\u6469\u83ab\u58a8\u9ed8\u59c6\u6728\u7a46\u90a3\u5a1c\u7eb3\u4e43\u5948\u5357\u5185\u5c3c\u5e74\u6d85\u5b81\u7ebd\u52aa\u8bfa\u6b27\u5e15\u6f58\u7554\u5e9e\u57f9\u4f69\u5f6d\u76ae\u5e73\u6cfc\u666e\u5176\u5951\u6070\u5f3a\u4e54\u5207\u94a6\u6c81\u6cc9\u8ba9\u70ed\u8363\u8089\u5112\u745e\u82e5\u8428\u585e\u8d5b\u6851\u745f\u68ee\u838e\u6c99\u5c71\u5584\u7ecd\u820d\u5723\u65bd\u8bd7\u77f3\u4ec0\u53f2\u58eb\u5b88\u65af\u53f8\u4e1d\u82cf\u7d20\u7d22\u5854\u6cf0\u5766\u6c64\u5510\u9676\u7279\u63d0\u6c40\u56fe\u571f\u5410\u6258\u9640\u74e6\u4e07\u738b\u65fa\u5a01\u97e6\u7ef4\u9b4f\u6e29\u6587\u7fc1\u6c83\u4e4c\u543e\u6b66\u4f0d\u897f\u9521\u5e0c\u559c\u590f\u76f8\u9999\u6b47\u8c22\u8f9b\u65b0\u7259\u96c5\u4e9a\u5f66\u5c27\u53f6\u4f9d\u4f0a\u8863\u5b9c\u4e49\u56e0\u97f3\u82f1\u96cd\u5c24\u4e8e\u7ea6\u5bb0\u6cfd\u589e\u8a79\u73cd\u6cbb\u4e2d\u4ef2\u6731\u8bf8\u5353\u5b5c\u7956\u4f50\u4f3d\u5a05\u5c15\u8153\u6ed5\u6d4e\u5609\u6d25\u8d56\u83b2\u7433\u5f8b\u7565\u6155\u59ae\u8042\u88f4\u6d66\u5947\u9f50\u7434\u8339\u73ca\u536b\u6b23\u900a\u672d\u54f2\u667a\u5179\u8299\u6c76\u8fe6\u73c0\u742a\u68b5\u6590\u80e5\u9edb";
    public static final String TRANS_RUSSIAN = "\u00b7\u963f\u5b89\u5965\u5df4\u6bd4\u5f7c\u6ce2\u5e03\u5bdf\u8328\u5927\u5fb7\u5f97\u4e01\u675c\u5c14\u6cd5\u592b\u4f0f\u752b\u76d6\u683c\u54c8\u57fa\u52a0\u575a\u6377\u91d1\u5361\u79d1\u53ef\u514b\u5e93\u62c9\u83b1\u5170\u52d2\u96f7\u91cc\u5386\u5229\u8fde\u5217\u5362\u9c81\u7f57\u6d1b\u9a6c\u6885\u8499\u7c73\u59c6\u5a1c\u6d85\u5b81\u8bfa\u5e15\u6cfc\u666e\u5947\u9f50\u4e54\u5207\u65e5\u8428\u8272\u5c71\u7533\u4ec0\u65af\u7d22\u5854\u5766\u7279\u6258\u5a03\u7ef4\u6587\u4e4c\u897f\u5e0c\u8c22\u4e9a\u8036\u53f6\u4f9d\u4f0a\u4ee5\u624e\u4f50\u67f4\u8fbe\u767b\u8482\u6208\u679c\u6d77\u8d6b\u534e\u970d\u5409\u5b63\u6d25\u67ef\u7406\u7433\u739b\u66fc\u7a46\u7eb3\u5c3c\u5951\u94a6\u4e18\u6851\u6c99\u820d\u6cf0\u56fe\u74e6\u4e07\u96c5\u5353\u5179";
    public static final String TRANS_JAPANESE = "\u5b89\u5965\u516b\u767d\u767e\u90a6\u4fdd\u5317\u500d\u672c\u6bd4\u6ee8\u535a\u6b65\u90e8\u5f69\u83dc\u4ed3\u660c\u957f\u671d\u6c60\u8d64\u5ddd\u8239\u6df3\u6b21\u6751\u5927\u4ee3\u5c9b\u7a3b\u9053\u5fb7\u5730\u5178\u6e21\u5c14\u7e41\u996d\u98ce\u798f\u5188\u9ad8\u5de5\u5bab\u53e4\u8c37\u5173\u5e7f\u6842\u8d35\u597d\u6d69\u548c\u5408\u6cb3\u9ed1\u6a2a\u6052\u5b8f\u540e\u6237\u8352\u7ed8\u5409\u7eaa\u4f73\u52a0\u89c1\u5065\u6c5f\u4ecb\u91d1\u4eca\u8fdb\u4e95\u9759\u656c\u9756\u4e45\u9152\u83ca\u4fca\u5eb7\u53ef\u514b\u53e3\u68a8\u7406\u91cc\u793c\u6817\u4e3d\u5229\u7acb\u51c9\u826f\u6797\u73b2\u94c3\u67f3\u9686\u9e7f\u9ebb\u739b\u7f8e\u840c\u5f25\u654f\u6728\u7eb3\u5357\u7537\u5185\u9e1f\u5b81\u670b\u7247\u5e73\u5d0e\u9f50\u5343\u524d\u6d45\u6865\u7434\u9752\u6e05\u5e86\u79cb\u4e18\u66f2\u6cc9\u4ec1\u5fcd\u65e5\u8363\u82e5\u4e09\u68ee\u7eb1\u6749\u5c71\u5584\u4e0a\u4f38\u795e\u5723\u77f3\u5b9e\u77e2\u4e16\u5e02\u5ba4\u6c34\u987a\u53f8\u677e\u6cf0\u6843\u85e4\u5929\u7530\u571f\u4e07\u671b\u5c3e\u672a\u6587\u6b66\u4e94\u821e\u897f\u7ec6\u590f\u5baa\u76f8\u5c0f\u5b5d\u65b0\u661f\u884c\u96c4\u79c0\u96c5\u4e9a\u5ca9\u6768\u6d0b\u9633\u9065\u91ce\u4e5f\u53f6\u4e00\u4f0a\u8863\u9038\u4e49\u76ca\u6a31\u6c38\u7531\u6709\u4f51\u5b87\u7fbd\u90c1\u6e0a\u5143\u57a3\u539f\u8fdc\u6708\u60a6\u65e9\u9020\u5219\u6cfd\u589e\u624e\u5b85\u7ae0\u662d\u6cbc\u771f\u653f\u679d\u77e5\u4e4b\u690d\u667a\u6cbb\u4e2d\u5fe0\u4ef2\u7af9\u52a9\u690e\u5b50\u4f50\u962a\u5742\u5800\u837b\u83c5\u85b0\u6d5c\u6fd1\u9e20\u7b71";
    public static final int TT_ENGLISH = 0;
    public static final int TT_RUSSIAN = 1;
    public static final int TT_JAPANESE = 2;
    public static final String SEPERATOR_C_SENTENCE = "\u3002\uff01\uff1f\uff1a\uff1b\u2026";
    public static final String SEPERATOR_C_SUB_SENTENCE = "\u3001\uff0c\uff08\uff09\u201c\u201d\u2018\u2019";
    public static final String SEPERATOR_E_SENTENCE = "!?:;";
    public static final String SEPERATOR_E_SUB_SENTENCE = ",()\"'";
    public static final String SEPERATOR_LINK = "\n\r \u3000";
    public static final String SENTENCE_BEGIN = "\u59cb##\u59cb";
    public static final String SENTENCE_END = "\u672b##\u672b";
    public static final String WORD_SEGMENTER = "@";
    public static final int MAX_WORDS_PER_SENTENCE = 120;
    public static final int MAX_UNKNOWN_PER_SENTENCE = 200;
    public static final int MAX_POS_PER_WORD = 20;
    public static final int LITTLE_FREQUENCY = 6;
    public static final int MAX_FREQUENCE = 2079997;
    public static final int MAX_SENTENCE_LEN = 2000;
    public static final double INFINITE_VALUE = 10000.0;
    public static final double SMOOTH_PARAM = 0.1;
    public static final String UNKNOWN_PERSON = "\u672a##\u4eba";
    public static final String UNKNOWN_SPACE = "\u672a##\u5730";
    public static final String UNKNOWN_NUM = "\u672a##\u6570";
    public static final String UNKNOWN_TIME = "\u672a##\u65f6";
    public static final String UNKNOWN_LETTER = "\u672a##\u4e32";

    public static boolean gbGenerate(String fileName) {
        PrintWriter out;
        block5: {
            File file = new File(fileName);
            out = new PrintWriter(new FileOutputStream(file));
            if (file.canWrite()) break block5;
            return false;
        }
        try {
            int i = 161;
            while (i < 255) {
                int j = 161;
                while (j < 255) {
                    out.println("" + i + j + "," + i + "," + j);
                    ++j;
                }
                ++i;
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static boolean CC_Generate(String fileName) {
        File file = new File(fileName);
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(file));
            int i = 176;
            while (i < 255) {
                int j = 161;
                while (j < 255) {
                    out.println("" + i + j + "," + i + "," + j);
                    ++j;
                }
                ++i;
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static boolean CC_Find(byte[] string, byte[] strCharSet) {
        int index;
        return string == null || strCharSet == null || (index = Utility.strstr(string, strCharSet)) == -1 || index % 2 != 1;
    }

    public static int charType(String str) {
        if (str != null && str.length() > 0) {
            byte b2;
            byte[] b = str.getBytes();
            byte b1 = b[0];
            byte by = b2 = b.length > 1 ? b[1] : (byte)0;
            if (Utility.getUnsigned(b1) < 128) {
                if ("\"!,.?()[]{}+=".indexOf((char)b1) != -1) {
                    return 6;
                }
                return 5;
            }
            if (Utility.getUnsigned(b1) == 162) {
                return 10;
            }
            if (Utility.getUnsigned(b1) == 163 && Utility.getUnsigned(b2) > 175 && Utility.getUnsigned(b2) < 186) {
                return 9;
            }
            if (Utility.getUnsigned(b1) == 163 && (Utility.getUnsigned(b2) >= 193 && Utility.getUnsigned(b2) <= 218 || Utility.getUnsigned(b2) >= 225 && Utility.getUnsigned(b2) <= 250)) {
                return 8;
            }
            if (Utility.getUnsigned(b1) == 161 || Utility.getUnsigned(b1) == 163) {
                return 6;
            }
            if (Utility.getUnsigned(b1) >= 176 && Utility.getUnsigned(b1) <= 247) {
                return 7;
            }
        }
        return 17;
    }

    public static int getCCPrefix(byte[] sSentence) {
        int nLen = sSentence.length;
        int nCurPos = 0;
        while (nCurPos < nLen && Utility.getUnsigned(sSentence[nCurPos]) > 175 && Utility.getUnsigned(sSentence[nCurPos]) < 248) {
            nCurPos += 2;
        }
        return nCurPos;
    }

    public static boolean isAllChinese(String str) {
        if (str != null) {
            int i = 0;
            while (i < str.length()) {
                byte[] b = str.substring(i, i + 1).getBytes();
                if (b.length == 2 && (Utility.getUnsigned(b[0]) >= 248 || Utility.getUnsigned(b[0]) <= 175 || Utility.getUnsigned(b[0]) >= 253 || Utility.getUnsigned(b[0]) <= 160)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean isAllNonChinese(byte[] sString) {
        int nLen = sString.length;
        int i = 0;
        while (i < nLen) {
            if (Utility.getUnsigned(sString[i]) < 248 && Utility.getUnsigned(sString[i]) > 175) {
                return false;
            }
            if (sString[i] < 0) {
                i += 2;
                continue;
            }
            ++i;
        }
        return true;
    }

    public static boolean isAllSingleByte(String str) {
        if (str != null) {
            int len = str.length();
            int i = 0;
            byte[] b = str.getBytes();
            while (i < len && b[i] < 128) {
                ++i;
            }
            return i >= len;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isAllNum(String str) {
        block3: {
            num = "\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff190123456789";
            prefix = "\u00b1+\u2014-\uff0b";
            mid = "\u2236:\uff1a\u00b7.\uff0e\uff0f/";
            tail = "\u767e\u5343\u4e07\u4ebf\u4f70\u4edf\uff05%\u2030";
            if (str == null || str.length() <= 0) break block3;
            i = 0;
            while (i < str.length()) {
                block4: {
                    ch = str.substring(i, i + 1);
                    if ((i != 0 || prefix.indexOf(ch) == -1) && num.indexOf(ch) == -1 && (i <= 0 || mid.indexOf(ch) == -1)) ** GOTO lbl15
                    break block4;
lbl-1000:
                    // 1 sources

                    {
                        if (++i < str.length()) {
                            ch = str.substring(i, i + 1);
                            continue;
                        }
                        return true;
lbl15:
                        // 2 sources

                        ** while (tail.indexOf((String)ch) != -1)
                    }
lbl16:
                    // 1 sources

                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isAllIndex(byte[] sString) {
        nLen = sString.length;
        i = 0;
        while (i < nLen - 1 && Utility.getUnsigned(sString[i]) == 162) {
            i += 2;
        }
        if (i < nLen) ** GOTO lbl9
        return true;
lbl-1000:
        // 1 sources

        {
            ++i;
lbl9:
            // 2 sources

            ** while (i < nLen && sString[i] > 64 && sString[i] < 91 || sString[i] > 96 && sString[i] < 123)
        }
lbl10:
        // 1 sources

        return i >= nLen;
    }

    public static boolean isAllLetter(String str) {
        int i = 0;
        if (str != null) {
            int nLen = str.length();
            byte[] b = str.getBytes();
            while (i < nLen - 1 && Utility.getUnsigned(b[i]) == 163 && (Utility.getUnsigned(b[i + 1]) >= 193 && Utility.getUnsigned(b[i + 1]) <= 218 || Utility.getUnsigned(b[i + 1]) >= 225 && Utility.getUnsigned(b[i + 1]) <= 250)) {
                i += 2;
            }
            return i >= nLen;
        }
        return false;
    }

    public static boolean isAllDelimiter(byte[] sString) {
        int nLen = sString.length;
        int i = 0;
        while (i < nLen - 1 && (Utility.getUnsigned(sString[i]) == 161 || Utility.getUnsigned(sString[i]) == 163)) {
            i += 2;
        }
        return i >= nLen;
    }

    public static int binarySearch(int val, int[] table) {
        if (table != null) {
            int len = table.length;
            int start = 0;
            int end = len - 1;
            int mid = (start + end) / 2;
            while (start <= end) {
                if (table[mid] == val) {
                    return mid;
                }
                if (table[mid] < val) {
                    start = mid + 1;
                } else {
                    end = mid - 1;
                }
                mid = (start + end) / 2;
            }
        }
        return -1;
    }

    public static boolean isForeign(String word) {
        if (word != null) {
            int foreignCount = Utility.getForeignCharCount(word);
            int charCount = word.length();
            if (charCount > 2 || foreignCount >= 1 * charCount / 2) {
                return true;
            }
        }
        return false;
    }

    public static boolean isAllForeign(String sWord) {
        int nForeignCount = Utility.getForeignCharCount(sWord);
        return 2 * nForeignCount == sWord.length();
    }

    public static boolean isAllChineseNum(String word) {
        String chineseNum = "\u96f6\u25cb\u4e00\u4e8c\u4e24\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341\u5eff\u767e\u5343\u4e07\u4ebf\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396\u62fe\u4f70\u4edf\u2236\u00b7\uff0e\uff0f\u70b9";
        String prefix = "\u51e0\u6570\u7b2c\u4e0a\u6210";
        if (word != null && word.length() > 0) {
            int i = 0;
            while (i < word.length()) {
                if (word.indexOf("\u5206\u4e4b", i) == i) {
                    ++i;
                } else {
                    String tchar = word.substring(i, i + 1);
                    if (chineseNum.indexOf(tchar) == -1 && (i != 0 || prefix.indexOf(tchar) == -1)) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static int getForeignCharCount(String sWord) {
        int nCount;
        int nForeignCount = Utility.getCharCount(TRANS_ENGLISH, sWord);
        if (nForeignCount <= (nCount = Utility.getCharCount(TRANS_JAPANESE, sWord))) {
            nForeignCount = nCount;
        }
        if (nForeignCount <= (nCount = Utility.getCharCount(TRANS_RUSSIAN, sWord))) {
            nForeignCount = nCount;
        }
        return nForeignCount;
    }

    public static int getCharCount(String charSet, String word) {
        int nCount = 0;
        if (word != null) {
            String temp = String.valueOf(word) + " ";
            int i = 0;
            while (i < word.length()) {
                String s = temp.substring(i, i + 1);
                if (charSet.indexOf(s) != -1) {
                    ++nCount;
                }
                ++i;
            }
        }
        return nCount;
    }

    public int GetForeignType(String sWord) {
        int nCount;
        int nType = 0;
        int nForeignCount = Utility.getCharCount(TRANS_ENGLISH, sWord);
        if (nForeignCount < (nCount = Utility.getCharCount(TRANS_RUSSIAN, sWord))) {
            nForeignCount = nCount;
            nType = 1;
        }
        if (nForeignCount < (nCount = Utility.getCharCount(TRANS_JAPANESE, sWord))) {
            nForeignCount = nCount;
            nType = 2;
        }
        return nType;
    }

    public static byte[] readBytes(DataInputStream in, int len) {
        if (in != null && len > 0) {
            byte[] b = new byte[len];
            try {
                int i = 0;
                while (i < len) {
                    b[i] = in.readByte();
                    ++i;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return b;
        }
        return null;
    }

    public static boolean PostfixSplit(byte[] sWord, byte[] sWordRet, byte[] sPostfix) {
        byte[] sSinglePostfix = POSTFIX_SINGLE.getBytes();
        byte[][] sMultiPostfix = new byte[POSTFIX_MUTIPLE.length][9];
        int i = 0;
        while (i < sMultiPostfix.length) {
            sMultiPostfix[i] = POSTFIX_MUTIPLE[i].getBytes();
            ++i;
        }
        int nPostfixLen = 0;
        int nWordLen = sWord.length;
        int i2 = 0;
        while (sMultiPostfix[i2][0] != 0 && !Utility.strncmp(GFCommon.bytesCopy(sWord, nWordLen - sMultiPostfix[i2].length, sWord.length - nWordLen + sMultiPostfix[i2].length), 0, sMultiPostfix[i2], sMultiPostfix[i2].length)) {
            ++i2;
        }
        GFCommon.bytesCopy(sPostfix, sMultiPostfix[i2], 0, sMultiPostfix.length);
        nPostfixLen = sMultiPostfix[i2].length;
        if (nPostfixLen == 0) {
            sPostfix[2] = 0;
            Utility.strncpy(sPostfix, GFCommon.bytesCopy(sWord, nWordLen - 2, 2), 2);
            if (Utility.CC_Find(sSinglePostfix, sPostfix)) {
                nPostfixLen = 2;
            }
        }
        Utility.strncpy(sWordRet, sWord, nWordLen - nPostfixLen);
        sWordRet[nWordLen - nPostfixLen] = 0;
        sPostfix[nPostfixLen] = 0;
        return true;
    }

    public static int strstr(byte[] b1, byte[] b2) {
        boolean flag = true;
        if (b1 != null && b2 != null) {
            int i = 0;
            while (i < b1.length) {
                if (b1[i] == b2[0] && b1.length - i >= b2.length) {
                    int j = 0;
                    while (j < b2.length) {
                        if (b2[j] != b1[i + j]) {
                            flag = false;
                            break;
                        }
                        ++j;
                    }
                    if (flag) {
                        return i;
                    }
                }
                ++i;
            }
        }
        return -1;
    }

    public static int strchr(byte[] bs, byte b) {
        if (bs != null) {
            int i = 0;
            while (i < bs.length) {
                if (bs[i] == b) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static boolean strncmp(byte[] b1, int startIndex, byte[] b2, int len) {
        if (b1 != null && b2 != null && len > 0 && b1.length >= len && b2.length >= len) {
            int i = startIndex;
            while (i < len) {
                if (b1[i] != b2[i]) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static int getUnsigned(byte b) {
        if (b > 0) {
            return b;
        }
        return b & 0xFF;
    }

    public static void strncpy(byte[] dest, byte[] src, int len) {
        if (dest != null && src != null && dest.length >= len && len <= src.length) {
            int i = 0;
            while (i < len) {
                dest[i] = src[i];
                ++i;
            }
        }
    }

    public static int CC_ID(String str) {
        int result = -1;
        if (str != null && str.length() > 0) {
            byte[] b = str.getBytes();
            result = (Utility.getUnsigned(b[0]) - 176) * 94 + (Utility.getUnsigned(b[1]) - 161);
        }
        return result;
    }

    public static int CC_CHAR1(int id) {
        return id / 94 + 176;
    }

    public static int CC_CHAR2(int id) {
        return id % 94 + 161;
    }

    public static int strcat(byte[] dest, byte[] src, int len) {
        if (dest != null && src != null && len > 0) {
            int i = 0;
            while (i < dest.length) {
                if (dest[i] == 0) {
                    int j = 0;
                    while (j < len) {
                        dest[i] = src[j];
                        ++j;
                    }
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int strcpy(byte[] dest, byte[] src) {
        return Utility.strcpy(dest, src, src.length);
    }

    public static int strcpy(byte[] dest, byte[] src, int len) {
        if (dest != null && src != null && len > 0) {
            int i = 0;
            i = 0;
            while (i < len) {
                dest[i] = src[i];
                ++i;
            }
            return i;
        }
        return -1;
    }

    public static String getGB(int id) {
        String result = null;
        if (id >= 0 && id < 6768) {
            byte[] b = new byte[]{(byte)Utility.CC_CHAR1(id), (byte)Utility.CC_CHAR2(id)};
            try {
                result = new String(b, "GBK");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static boolean isSingle(String s) {
        return s != null && s.getBytes().length == 1;
    }

    public static int[] removeInvalid(int[] src) {
        int[] result = null;
        int count = 0;
        if (src != null && src.length > 0) {
            int i = 0;
            while (i < src.length) {
                if (i != 0 && src[i] == 0) break;
                ++count;
                ++i;
            }
            result = new int[count];
            i = 0;
            while (i < count) {
                result[i] = src[i];
                ++i;
            }
        }
        return result;
    }

    public static boolean isYearTime(String snum) {
        if (snum != null) {
            int len = snum.length();
            String first = snum.substring(0, 1);
            if (Utility.isAllNum(snum) && (len == 4 || len == 2 && (GFString.cint(first) > 4 || GFString.cint(first) == 0))) {
                return true;
            }
            if (Utility.isAllNum(snum) && (len >= 6 || len == 4 && "\uff10\uff15\uff16\uff17\uff18\uff19".indexOf(first) != -1)) {
                return true;
            }
            if (Utility.getCharCount("\u96f6\u25cb\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396", snum) == len && len >= 2) {
                return true;
            }
            if (len == 4 && Utility.getCharCount("\u5343\u4edf\u96f6\u25cb", snum) == 2) {
                return true;
            }
            if (len == 1 && Utility.getCharCount("\u5343\u4edf", snum) == 1) {
                return true;
            }
            if (len == 2 && Utility.getCharCount("\u7532\u4e59\u4e19\u4e01\u620a\u5df1\u5e9a\u8f9b\u58ec\u7678", snum) == 1 && Utility.getCharCount("\u5b50\u4e11\u5bc5\u536f\u8fb0\u5df3\u5348\u672a\u7533\u9149\u620c\u4ea5", snum.substring(1)) == 1) {
                return true;
            }
        }
        return false;
    }

    public static boolean isInAggregate(String aggr, String str) {
        if (aggr != null && str != null) {
            int i = 0;
            while (i < str.length()) {
                String s = str.substring(i, i + 1);
                if (aggr.indexOf(s) == -1) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean isDBCCase(String str) {
        if (str != null) {
            str = String.valueOf(str) + " ";
            int i = 0;
            while (i < str.length()) {
                String s = str.substring(i, i + 1);
                if (s.getBytes().length != 1) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean isSBCCase(String str) {
        if (str != null) {
            str = String.valueOf(str) + " ";
            int i = 0;
            while (i < str.length()) {
                String s = str.substring(i, i + 1);
                if (s.getBytes().length != 2) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean isDelimiter(String str) {
        return str != null && ("-".equals(str) || "\uff0d".equals(str));
    }

    public static boolean isUnknownWord(String word) {
        return word != null && word.indexOf("\u672a##") == 0;
    }

    public static PersonName chineseNameSplit(String word, PosTagger personTagger) {
        PersonName result = null;
        if (word != null && personTagger != null) {
            String temp;
            String[] atoms;
            Dictionary personDict = personTagger.getUnknownDict();
            int len = word.length();
            if (len < 2 || len > 4) {
                return null;
            }
            String[] stringArray = atoms = GFString.atomSplit(word);
            int n = atoms.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (Utility.charType(s) != 7 && Utility.charType(s) != 17) {
                    return null;
                }
                ++n2;
            }
            String surName = null;
            int surNameLen = 2;
            if (len > 2) {
                surName = word.substring(0, surNameLen);
            } else if (len == 2) {
                surName = word;
            }
            if (!personDict.isExist(surName, 1)) {
                surNameLen = 1;
                if (len > 1) {
                    surName = word.substring(0, surNameLen);
                } else if (len == 1) {
                    surName = word;
                }
                if (!personDict.isExist(surName, 1)) {
                    surName = null;
                    surNameLen = 0;
                }
            }
            String giveName = word.substring(surNameLen);
            if (len > 3 && personDict.isExist(temp = word.substring(surNameLen, surNameLen + 1), 1)) {
                giveName = word.substring(surNameLen + 1);
            }
            double freq = personDict.getFreq(surName, 1);
            String temp2 = giveName.substring(0, 1);
            double freq2 = personDict.getFreq(temp2, 2);
            if (surNameLen != 2 && (surNameLen == 0 && len > 2 || giveName.length() > 2 || Utility.getForeignCharCount(word) >= 3 && freq < (double)(personDict.getFreq("\u5f20", 1) / 40) && freq2 < (double)(personDict.getFreq("\u534e", 2) / 20) || freq < 10.0 && Utility.getForeignCharCount(giveName) == (len - surNameLen) / 2)) {
                return null;
            }
            if (len == 2 && personTagger.isGivenName(word)) {
                return null;
            }
            result = new PersonName();
            result.setFirstName(surName);
            result.setLastName(giveName);
        }
        return result;
    }

    public static enum TAG_TYPE {
        TT_NORMAL,
        TT_PERSON,
        TT_PLACE,
        TT_TRANS_PERSON;

    }
}

