/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.util;

import cn.pconline.search.common.util.Config;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class Cn2Spell {
    private static Properties config = Config.config();
    private static Properties pinyinCheck = new Properties();
    private static HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();

    static {
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        String pyCheckFileName = config.getProperty("pinyin.simple.check.file");
        if (pyCheckFileName != null) {
            try {
                File file = new File(pyCheckFileName);
                FileReader reader = new FileReader(file);
                pinyinCheck.load(reader);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String check(String chinese, int i) {
        for (Object obj : pinyinCheck.keySet()) {
            String key = (String)obj;
            String value = (String)pinyinCheck.get(key);
            String[] ss = value.split(";");
            if (ss == null || i >= ss.length) continue;
            chinese = chinese.replace(key, ss[i]);
        }
        return chinese;
    }

    public static String getFirstAlphaOfSpell(String chinese) {
        chinese = Cn2Spell.check(chinese, 1);
        StringBuffer pinyinName = new StringBuffer();
        char[] nameChar = chinese.toCharArray();
        int i = 0;
        while (i < nameChar.length) {
            if (nameChar[i] > '\u0080') {
                try {
                    String[] strs = PinyinHelper.toHanyuPinyinStringArray((char)nameChar[i], (HanyuPinyinOutputFormat)defaultFormat);
                    if (strs != null) {
                        pinyinName.append(strs[0].charAt(0));
                    }
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
            } else {
                pinyinName.append(nameChar[i]);
            }
            ++i;
        }
        return pinyinName.toString();
    }

    public static String getFullSpell(String chinese) {
        return Cn2Spell.getFullSpell(chinese, null);
    }

    public static String getFullSpell(String chinese, String join) {
        chinese = Cn2Spell.check(chinese, 0);
        StringBuffer pinyinName = new StringBuffer();
        char[] nameChar = chinese.toCharArray();
        int i = 0;
        while (i < nameChar.length) {
            if (nameChar[i] > '\u0080') {
                try {
                    String[] strs = PinyinHelper.toHanyuPinyinStringArray((char)nameChar[i], (HanyuPinyinOutputFormat)defaultFormat);
                    if (join != null) {
                        pinyinName.append(join);
                    }
                    if (strs != null) {
                        pinyinName.append(strs[0]);
                    }
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
            } else {
                pinyinName.append(nameChar[i]);
            }
            ++i;
        }
        return pinyinName.toString();
    }
}

