package cn.pconline.search.common;

import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;

/**
 * solr搜索器
 * 
 * @author zengjie
 * @since 2013-9-16
 * @see
 */
public class SolrSearcher
{

    private SolrServer server;

    private SolrSearcher(String solrBaseUrl)
    {
        server = new HttpSolrServer(solrBaseUrl);
    }

    public static SolrSearcher getSolrSearcher()
    {
        return null;
    }

    /**
     * 执行搜索操作,返回solr的查询响应
     * 
     * @param index
     * @param q
     * @return
     */
    public QueryResponse search(String index, SolrQuery q)
    {
        QueryRequest req = new QueryRequest(q);
        req.setPath(index);
        try
        {
            return req.process(server);
        }
        catch (SolrServerException e)
        {
            throw new SearchException(e);
        }
    }

    /**
     * 处理查询返回的高亮结果，将高亮字符串放置到destMap中
     * 
     * @param q
     * @param rsp
     * @param destMap
     * @param keyField
     */
    public static void processHighLightResult(SolrDocument doc,
            QueryResponse rsp, Map<String, Object> destMap, String keyField,
            String hField, int size)
    {
        if (rsp.getResults().getNumFound() <= 0)
        {
            return;
        }
        Map<String, Map<String, List<String>>> hMap = rsp.getHighlighting();
        Object key = doc.get(keyField);
        Map<String, List<String>> hStrMap = hMap.get(key);
        List<String> strList = hStrMap.get(hField);
        hStrMap = hMap.get(key);
        if (CollectionUtils.isEmpty(strList))
        {
            String v = castToString(doc.get(hField));
            if (StringUtils.isEmpty(v))
            {
                return;
            }
            if (v.length() > size)
            {
                destMap.put(hField, v.subSequence(0, size));
            }
            else
            {
                destMap.put(hField, v);
            }
        }
        else
        {
            StringBuilder builder = new StringBuilder();
            for (String s : strList)
            {
                builder.append(s);
            }
            destMap.put(hField, builder.toString());
        }
    }

    private static String castToString(Object source)
    {
        if (source == null)
        {
            return null;
        }
        return source.toString();
    }

}
